/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.function;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.WordFactory;

public class CEntryPointSetup {
    public static final Word SINGLE_ISOLATE_SENTINEL = (Word)WordFactory.unsigned((long)0x150150150150150L);
    public static final int SINGLE_ISOLATE_TO_SINGLE_THREAD_ADDEND = 1575;
    public static final Word SINGLE_THREAD_SENTINEL = SINGLE_ISOLATE_SENTINEL.add(1575);

    public static final class LeaveTearDownIsolateEpilogue
    implements CEntryPointOptions.Epilogue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to leave the current IsolateThread context and to tear down the Isolate.");

        @Uninterruptible(reason="epilogue")
        static void leave() {
            int code = CEntryPointActions.leaveTearDownIsolate();
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }

    public static final class LeaveDetachThreadEpilogue
    implements CEntryPointOptions.Epilogue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to leave the current IsolateThread context and to detach the current thread.");

        @Uninterruptible(reason="epilogue")
        public static void leave() {
            int code = CEntryPointActions.leaveDetachThread();
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }

    public static final class LeaveEpilogue
    implements CEntryPointOptions.Epilogue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to leave the current IsolateThread context.");

        @Uninterruptible(reason="epilogue")
        static void leave() {
            int code = CEntryPointActions.leave();
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }

    public static final class EnterCreateIsolatePrologue
    implements CEntryPointOptions.Prologue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to create a new Isolate.");

        @Uninterruptible(reason="prologue")
        public static void enter() {
            int code = CEntryPointActions.enterCreateIsolate((CEntryPointCreateIsolateParameters)WordFactory.nullPointer());
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }

    public static final class EnterIsolatePrologue
    implements CEntryPointOptions.Prologue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to enter the provided Isolate in the current thread. The thread might not have been attached to the Isolate first.");

        @Uninterruptible(reason="prologue")
        static void enter(Isolate isolate) {
            int code = CEntryPointActions.enterIsolate(isolate);
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }

    public static final class EnterPrologue
    implements CEntryPointOptions.Prologue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to enter the specified IsolateThread context.");

        @Uninterruptible(reason="prologue")
        static void enter(IsolateThread thread) {
            int code = CEntryPointActions.enter(thread);
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }
}

