/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.monitor;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.monitor.MonitorSnippets;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.monitor.MultiThreadedMonitorSupport;
import com.oracle.svm.core.monitor.SingleThreadedMonitorSupport;
import java.util.Map;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class MonitorFeature
implements InternalFeature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            ImageSingletons.add(MonitorSupport.class, (Object)new MultiThreadedMonitorSupport());
        } else {
            ImageSingletons.add(MonitorSupport.class, (Object)new SingleThreadedMonitorSupport());
        }
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        new MonitorSnippets(options, providers).registerLowerings(lowerings);
    }

    @Override
    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            foreignCalls.register(MonitorSnippets.FOREIGN_CALLS);
        }
    }
}

