/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.sampler.SamplerBuffer;
import com.oracle.svm.core.sampler.SamplerBufferAccess;
import com.oracle.svm.core.sampler.SubstrateSigprofHandler;
import com.oracle.svm.core.util.VMError;
import jdk.jfr.internal.Options;
import org.graalvm.word.WordFactory;

class SamplerBufferPool {
    private static final long THREAD_BUFFER_SIZE = Options.getThreadBufferSize();
    private static final VMMutex mutex = new VMMutex("SamplerBufferPool");
    private static long bufferCount;

    SamplerBufferPool() {
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.", mayBeInlined=true)
    public static void releaseBufferAndAdjustCount(SamplerBuffer threadLocalBuffer) {
        SamplerBufferPool.adjustBufferCount0(threadLocalBuffer);
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.", mayBeInlined=true)
    public static void adjustBufferCount() {
        SamplerBufferPool.adjustBufferCount0((SamplerBuffer)WordFactory.nullPointer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.", mayBeInlined=true)
    private static void adjustBufferCount0(SamplerBuffer threadLocalBuffer) {
        block7: {
            mutex.lockNoTransition();
            try {
                SamplerBufferPool.releaseThreadLocalBuffer(threadLocalBuffer);
                long diff = SamplerBufferPool.diff();
                if (diff > 0L) {
                    int i = 0;
                    while ((long)i < diff) {
                        if (!SamplerBufferPool.allocateAndPush()) {
                            break block7;
                        }
                        ++i;
                    }
                    break block7;
                }
                for (long i = diff; i < 0L; ++i) {
                    if (SamplerBufferPool.popAndFree()) continue;
                    break;
                }
            }
            finally {
                mutex.unlock();
            }
        }
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.", mayBeInlined=true)
    private static void releaseThreadLocalBuffer(SamplerBuffer buffer) {
        if (buffer.isNonNull()) {
            if (SamplerBufferAccess.isEmpty(buffer)) {
                SamplerBufferAccess.free(buffer);
            } else {
                buffer.setFreeable(true);
                SubstrateSigprofHandler.singleton().fullBuffers().pushBuffer(buffer);
            }
            VMError.guarantee(bufferCount > 0L);
            --bufferCount;
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean allocateAndPush() {
        VMError.guarantee(bufferCount >= 0L);
        SamplerBuffer buffer = SamplerBufferAccess.allocate(WordFactory.unsigned((long)THREAD_BUFFER_SIZE));
        if (buffer.isNonNull()) {
            SubstrateSigprofHandler.singleton().availableBuffers().pushBuffer(buffer);
            ++bufferCount;
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean popAndFree() {
        VMError.guarantee(bufferCount > 0L);
        SamplerBuffer buffer = SubstrateSigprofHandler.singleton().availableBuffers().popBuffer();
        if (buffer.isNonNull()) {
            SamplerBufferAccess.free(buffer);
            --bufferCount;
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static long diff() {
        double diffD = (double)SubstrateSigprofHandler.singleton().substrateThreadMXBean().getThreadCount() * 1.5 - (double)bufferCount;
        return (long)(diffD + 0.5);
    }
}

