/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.sampler.SamplerBuffer;
import com.oracle.svm.core.sampler.SamplerSpinLock;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.WordFactory;

class SamplerBufferStack {
    private SamplerBuffer head;
    private final SamplerSpinLock spinLock = new SamplerSpinLock();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    SamplerBufferStack() {
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public void pushBuffer(SamplerBuffer buffer) {
        this.spinLock.lock();
        try {
            buffer.setNext(this.head);
            this.head = buffer;
        }
        finally {
            this.spinLock.unlock();
        }
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public SamplerBuffer popBuffer() {
        this.spinLock.lock();
        try {
            SamplerBuffer result = this.head;
            if (result.isNonNull()) {
                this.head = this.head.getNext();
                result.setNext((SamplerBuffer)WordFactory.nullPointer());
            }
            SamplerBuffer samplerBuffer = result;
            return samplerBuffer;
        }
        finally {
            this.spinLock.unlock();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isLockedByCurrentThread() {
        return this.spinLock.isOwner();
    }
}

