/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.events.SafepointBeginEvent;
import com.oracle.svm.core.jfr.events.SafepointEndEvent;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.nodes.CodeSynchronizationNode;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.thread.LoomSupport;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfos;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.atomic.AtomicInteger;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.PauseNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.MembarNode;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class Safepoint {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor ENTER_SLOW_PATH_SAFEPOINT_CHECK = SnippetRuntime.findForeignCall(Safepoint.class, "enterSlowPathSafepointCheck", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor ENTER_SLOW_PATH_TRANSITION_FROM_NATIVE_TO_NEW_STATUS = SnippetRuntime.findForeignCall(Safepoint.class, "enterSlowPathTransitionFromNativeToNewStatus", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor ENTER_SLOW_PATH_TRANSITION_FROM_VM_TO_JAVA = SnippetRuntime.findForeignCall(Safepoint.class, "enterSlowPathTransitionFromVMToJava", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{ENTER_SLOW_PATH_SAFEPOINT_CHECK, ENTER_SLOW_PATH_TRANSITION_FROM_NATIVE_TO_NEW_STATUS, ENTER_SLOW_PATH_TRANSITION_FROM_VM_TO_JAVA};
    static final FastThreadLocalInt safepointRequested = (FastThreadLocalInt)FastThreadLocalFactory.createInt("Safepoint.safepointRequested").setMaxOffset(63);
    static final int THREAD_REQUEST_RESET = Integer.MAX_VALUE;

    private Safepoint() {
    }

    private static long getSafepointPromptnessWarningNanos() {
        return Options.SafepointPromptnessWarningNanos.getValue();
    }

    private static long getSafepointPromptnessFailureNanos() {
        return Options.SafepointPromptnessFailureNanos.getValue();
    }

    @Uninterruptible(reason="Must not contain safepoint checks.")
    private static void slowPathSafepointCheck(int newStatus, boolean callerHasJavaFrameAnchor, boolean popFrameAnchor) {
        IsolateThread myself = CurrentIsolate.getCurrentThread();
        if (Master.singleton().getRequestingThread() == myself) {
            assert (!ThreadingSupportImpl.isRecurringCallbackRegistered(myself) || ThreadingSupportImpl.isRecurringCallbackPaused());
        } else {
            do {
                if (!Master.singleton().getRequestingThread().isNonNull()) continue;
                Statistics.incFrozen();
                Safepoint.freezeAtSafepoint(newStatus, callerHasJavaFrameAnchor);
                Statistics.incThawed();
                VMError.guarantee(VMThreads.StatusSupport.getStatusVolatile() == newStatus, "Transition to the new thread status must have been successful.");
            } while (VMThreads.StatusSupport.getStatusVolatile() != newStatus && !VMThreads.StatusSupport.compareAndSetNativeToNewStatus(newStatus));
        }
        VMError.guarantee(VMThreads.StatusSupport.getStatusVolatile() == newStatus, "Transition to the new thread status must have been successful.");
        if (popFrameAnchor) {
            assert (newStatus == 1);
            JavaFrameAnchors.popFrameAnchor();
        }
        if (newStatus == 1) {
            Safepoint.slowPathRunJavaStateActions();
        }
    }

    @Uninterruptible(reason="Must not contain safepoint checks.")
    private static void slowPathRunJavaStateActions() {
        if (VMThreads.ActionOnTransitionToJavaSupport.isActionPending()) {
            if (VMThreads.ActionOnTransitionToJavaSupport.isSynchronizeCode()) {
                CodeSynchronizationNode.synchronizeCode();
            } else assert (false) : "Unexpected action pending.";
            VMThreads.ActionOnTransitionToJavaSupport.clearActions();
        }
        ThreadingSupportImpl.onSafepointCheckSlowpath();
    }

    @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode")
    @Uninterruptible(reason="Must not contain safepoint checks.")
    private static void freezeAtSafepoint(int newStatus, boolean callerHasJavaFrameAnchor) {
        if (VMThreads.StatusSupport.isStatusJava()) {
            assert (newStatus == 1);
            CFunctionPrologueNode.cFunctionPrologue(3);
            Safepoint.notInlinedLockNoTransition();
            CFunctionEpilogueNode.cFunctionEpilogue(3);
        } else {
            VMError.guarantee(callerHasJavaFrameAnchor);
            Safepoint.notInlinedLockNoTransition();
            boolean result = VMThreads.StatusSupport.compareAndSetNativeToNewStatus(newStatus);
            if (!result) {
                throw VMError.shouldNotReachHere("Transition to the new thread status failed.");
            }
        }
        VMThreads.THREAD_MUTEX.unlock();
    }

    @NeverInline(value="CFunctionPrologue and CFunctionEpilogue are placed around call to this function")
    @Uninterruptible(reason="Must not contain safepoint checks.")
    private static void notInlinedLockNoTransition() {
        VMThreads.THREAD_MUTEX.lockNoTransition();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void setSafepointRequested(IsolateThread vmThread, int value) {
        assert (VMThreads.StatusSupport.isStatusCreated(vmThread) || VMOperationControl.mayExecuteVmOperations());
        assert (value > 0);
        safepointRequested.setVolatile(vmThread, value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void setSafepointRequested(int value) {
        assert (value >= 0);
        safepointRequested.setVolatile(value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static int getSafepointRequested(IsolateThread vmThread) {
        return safepointRequested.getVolatile(vmThread);
    }

    public static LocationIdentity getThreadLocalSafepointRequestedLocationIdentity() {
        return safepointRequested.getLocationIdentity();
    }

    public static int getThreadLocalSafepointRequestedOffset() {
        return VMThreadLocalInfos.getOffset(safepointRequested);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    @Uninterruptible(reason="Must not contain safepoint checks")
    private static void enterSlowPathSafepointCheck() throws Throwable {
        Safepoint.slowPathSafepointCheck();
    }

    @AlwaysInline(value="Always inline into foreign call stub")
    @Uninterruptible(reason="Must not contain safepoint checks")
    public static void slowPathSafepointCheck() throws Throwable {
        if (VMThreads.SafepointBehavior.ignoresSafepoints()) {
            Safepoint.setSafepointRequested(Integer.MAX_VALUE);
            return;
        }
        VMError.guarantee(VMThreads.StatusSupport.isStatusJava(), "Attempting to do a safepoint check when not in Java mode");
        try {
            Safepoint.slowPathSafepointCheck(1, false, false);
        }
        catch (SafepointException se) {
            throw se.inner;
        }
        catch (Throwable ex) {
            VMError.shouldNotReachHere(ex);
        }
        Safepoint.exitSlowPathCheck();
    }

    @Uninterruptible(reason="Must not contain safepoint checks")
    private static void exitSlowPathCheck() {
        if (VMThreads.ActionOnExitSafepointSupport.isActionPending()) {
            if (LoomSupport.isEnabled() && VMThreads.ActionOnExitSafepointSupport.getSwitchStack()) {
                VMThreads.ActionOnExitSafepointSupport.clearActions();
                KnownIntrinsics.farReturn(0, VMThreads.ActionOnExitSafepointSupport.getSwitchStackSP(), VMThreads.ActionOnExitSafepointSupport.getSwitchStackIP(), false);
            } else assert (false) : "Unexpected action pending.";
        }
    }

    public static void transitionNativeToJava(boolean popFrameAnchor) {
        VMThreads.StatusSupport.assertStatusNativeOrSafepoint();
        int newStatus = 1;
        if (BranchProbabilityNode.probability((double)0.999, (!ThreadingSupportImpl.needsNativeToJavaSlowpath() ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.999, (boolean)VMThreads.StatusSupport.compareAndSetNativeToNewStatus(newStatus))) {
            if (popFrameAnchor) {
                JavaFrameAnchors.popFrameAnchor();
            }
        } else {
            Safepoint.callSlowPathNativeToNewStatus(ENTER_SLOW_PATH_TRANSITION_FROM_NATIVE_TO_NEW_STATUS, newStatus, popFrameAnchor);
        }
        MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.NONE, (LocationIdentity)LocationIdentity.ANY_LOCATION);
    }

    @Uninterruptible(reason="Must not contain safepoint checks")
    public static boolean tryFastTransitionNativeToVM() {
        VMThreads.StatusSupport.assertStatusNativeOrSafepoint();
        return VMThreads.StatusSupport.compareAndSetNativeToNewStatus(4);
    }

    @Uninterruptible(reason="Must not contain safepoint checks")
    public static void slowTransitionNativeToVM() {
        boolean needSlowPath;
        VMThreads.StatusSupport.assertStatusNativeOrSafepoint();
        int newStatus = 4;
        boolean bl = needSlowPath = !VMThreads.StatusSupport.compareAndSetNativeToNewStatus(newStatus);
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (boolean)needSlowPath)) {
            Safepoint.callSlowPathNativeToNewStatus(ENTER_SLOW_PATH_TRANSITION_FROM_NATIVE_TO_NEW_STATUS, newStatus, false);
        }
    }

    @Uninterruptible(reason="Must not contain safepoint checks")
    public static void transitionVMToJava(boolean popFrameAnchor) {
        boolean needSlowPath;
        VMThreads.StatusSupport.assertStatusVM();
        VMThreads.StatusSupport.setStatusJavaUnguarded();
        if (popFrameAnchor) {
            JavaFrameAnchors.popFrameAnchor();
        }
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (boolean)(needSlowPath = ThreadingSupportImpl.needsNativeToJavaSlowpath()))) {
            Safepoint.callSlowPathSafepointCheck(ENTER_SLOW_PATH_TRANSITION_FROM_VM_TO_JAVA);
        }
    }

    @Uninterruptible(reason="Must not contain safepoint checks")
    public static void transitionJavaToVM() {
        VMThreads.StatusSupport.assertStatusJava();
        VMThreads.StatusSupport.setStatusVM();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void transitionVMToNative() {
        VMThreads.StatusSupport.assertStatusVM();
        VMThreads.StatusSupport.setStatusNative();
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callSlowPathSafepointCheck(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="Must not contain safepoint checks")
    private static void enterSlowPathTransitionFromNativeToNewStatus(int newStatus, boolean popFrameAnchor) {
        VMError.guarantee(VMThreads.StatusSupport.isStatusNativeOrSafepoint(), "Must either be at a safepoint or in native mode");
        VMError.guarantee(!VMThreads.SafepointBehavior.ignoresSafepoints(), "The safepoint handling doesn't change the status of threads that ignore safepoints. So, the fast path transition must succeed and this slow path must not be called");
        Statistics.incSlowPathFrozen();
        try {
            Safepoint.slowPathSafepointCheck(newStatus, true, popFrameAnchor);
        }
        finally {
            Statistics.incSlowPathThawed();
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callSlowPathNativeToNewStatus(@Node.ConstantNodeParameter ForeignCallDescriptor var0, int var1, boolean var2);

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="Must not contain safepoint checks.")
    private static void enterSlowPathTransitionFromVMToJava() {
        VMError.guarantee(VMThreads.StatusSupport.isStatusJava(), "Must be already back in Java mode");
        Safepoint.slowPathRunJavaStateActions();
    }

    public static final class Statistics {
        private static long startNanos;
        private static long frozenNanos;
        private static long thawedNanos;
        private static int requested;
        private static int installed;
        private static int released;
        private static final UninterruptibleUtils.AtomicInteger frozen;
        private static final UninterruptibleUtils.AtomicInteger thawed;
        private static final UninterruptibleUtils.AtomicInteger slowPathFrozen;
        private static final AtomicInteger slowPathThawed;

        private Statistics() {
        }

        public static void reset() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                startNanos = 0L;
                frozenNanos = 0L;
                thawedNanos = 0L;
                requested = 0;
                installed = 0;
                released = 0;
                frozen.set(0);
                thawed.set(0);
                slowPathFrozen.set(0);
                slowPathThawed.set(0);
            }
        }

        public static long getStartNanos() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return startNanos;
        }

        public static void setStartNanos() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                startNanos = System.nanoTime();
            }
        }

        public static long getFrozenNanos() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return frozenNanos;
        }

        public static void setFrozenNanos() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                frozenNanos = TimeUtils.nanoSecondsSince(Statistics.getStartNanos());
            }
        }

        public static long getThawedNanos() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return thawedNanos;
        }

        public static void setThawedNanos() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                thawedNanos = TimeUtils.nanoSecondsSince(Statistics.getStartNanos());
            }
        }

        public static int getRequested() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return requested;
        }

        public static void incRequested() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                ++requested;
            }
        }

        public static int getInstalled() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return installed;
        }

        public static void incInstalled() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                ++installed;
            }
        }

        public static int getReleased() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return released;
        }

        public static void incReleased() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                ++released;
            }
        }

        public static int getFrozen() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return frozen.get();
        }

        @Uninterruptible(reason="Called when safepoints are requested.")
        public static void incFrozen() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                frozen.incrementAndGet();
            }
        }

        public static int getThawed() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return thawed.get();
        }

        @Uninterruptible(reason="Called during safepointing.")
        public static void incThawed() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                thawed.incrementAndGet();
            }
        }

        public static int getSlowPathFrozen() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return slowPathFrozen.get();
        }

        @Uninterruptible(reason="Called when safepoints are requested.")
        public static void incSlowPathFrozen() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                slowPathFrozen.incrementAndGet();
            }
        }

        public static int getSlowPathThawed() {
            assert (Options.GatherSafepointStatistics.getValue().booleanValue()) : "Should have set GatherSafepointStatistics.";
            return slowPathThawed.get();
        }

        @Uninterruptible(reason="Called when safepoints are requested.")
        public static void incSlowPathThawed() {
            if (Options.GatherSafepointStatistics.getValue().booleanValue()) {
                slowPathThawed.incrementAndGet();
            }
        }

        public static Log toLog(Log log, boolean newLine, String prefix) {
            if (log.isEnabled() && Options.GatherSafepointStatistics.getValue().booleanValue()) {
                if (newLine) {
                    log.newline();
                }
                log.string("[Safepoint.Statistics: ").string(prefix).newline();
                log.string("      startNanos: ").signed(Statistics.getStartNanos()).newline();
                log.string("     frozenNanos: ").signed(Statistics.getFrozenNanos()).newline();
                log.string("     thawedNanos: ").signed(Statistics.getThawedNanos()).newline();
                log.string("       requested: ").signed(Statistics.getRequested()).newline();
                log.string("       installed: ").signed(Statistics.getInstalled()).newline();
                log.string("        released: ").signed(Statistics.getReleased()).newline();
                log.string("          frozen: ").signed(Statistics.getFrozen()).newline();
                log.string("          thawed: ").signed(Statistics.getThawed()).newline();
                log.string("  slowPathFrozen: ").signed(Statistics.getSlowPathFrozen()).newline();
                log.string("  slowPathThawed: ").signed(Statistics.getSlowPathThawed()).string("]").newline();
            }
            return log;
        }

        static {
            frozen = new UninterruptibleUtils.AtomicInteger(0);
            thawed = new UninterruptibleUtils.AtomicInteger(0);
            slowPathFrozen = new UninterruptibleUtils.AtomicInteger(0);
            slowPathThawed = new AtomicInteger(0);
        }

        public static class Options {
            public static final HostedOptionKey<Boolean> GatherSafepointStatistics = new HostedOptionKey<Boolean>(false);
        }
    }

    public static final class Master {
        private static final int NOT_AT_SAFEPOINT = 0;
        private static final int SYNCHRONIZING = 1;
        private static final int AT_SAFEPOINT = 2;
        private volatile int safepointState = 0;
        private volatile UnsignedWord safepointId;
        private volatile IsolateThread requestingThread;

        static void initialize() {
            ImageSingletons.add(Master.class, (Object)new Master());
        }

        @Fold
        public static Master singleton() {
            return (Master)ImageSingletons.lookup(Master.class);
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        private Master() {
        }

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="The safepoint logic must not allocate.")
        protected boolean freeze(String reason) {
            boolean lock;
            assert (SubstrateOptions.MultiThreaded.getValue().booleanValue()) : "Should only freeze for a safepoint when multi-threaded.";
            assert (VMOperationControl.mayExecuteVmOperations());
            long startTicks = JfrTicks.elapsedTicks();
            boolean bl = lock = !VMThreads.THREAD_MUTEX.isOwner();
            if (lock) {
                VMThreads.THREAD_MUTEX.lock();
            }
            this.requestingThread = CurrentIsolate.getCurrentThread();
            Statistics.reset();
            Statistics.setStartNanos();
            ((Heap)ImageSingletons.lookup(Heap.class)).prepareForSafepoint();
            this.safepointState = 1;
            int numJavaThreads = Master.requestSafepoints(reason);
            Master.waitForSafepoints(reason);
            Statistics.setFrozenNanos();
            this.safepointState = 2;
            this.safepointId = this.safepointId.add(1);
            SafepointBeginEvent.emit(this.getSafepointId(), numJavaThreads, startTicks);
            return lock;
        }

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="The safepoint logic must not allocate.")
        protected void thaw(String reason, boolean unlock) {
            assert (SubstrateOptions.MultiThreaded.getValue().booleanValue()) : "Should only thaw from a safepoint when multi-threaded.";
            assert (VMOperationControl.mayExecuteVmOperations());
            long startTicks = JfrTicks.elapsedTicks();
            this.safepointState = 0;
            Master.releaseSafepoints(reason);
            SafepointEndEvent.emit(this.getSafepointId(), startTicks);
            ((Heap)ImageSingletons.lookup(Heap.class)).endSafepoint();
            Statistics.setThawedNanos();
            this.requestingThread = (IsolateThread)WordFactory.nullPointer();
            if (unlock) {
                VMThreads.THREAD_MUTEX.unlock();
            }
            VMThreads.singleton().cleanupExitedOsThreads();
        }

        private static boolean isMyself(IsolateThread thread) {
            return thread == CurrentIsolate.getCurrentThread();
        }

        private static int requestSafepoints(String reason) {
            VMThreads.THREAD_MUTEX.assertIsOwner("Must hold mutex while requesting a safepoint.");
            Log trace = Log.noopLog().string("[Safepoint.Master.requestSafepoints:  reason: ").string(reason);
            int numOfThreads = 0;
            IsolateThread vmThread = VMThreads.firstThread();
            while (vmThread.isNonNull()) {
                ++numOfThreads;
                if (!Master.isMyself(vmThread) && !VMThreads.SafepointBehavior.ignoresSafepoints(vmThread)) {
                    Master.requestSafepoint(vmThread);
                }
                vmThread = VMThreads.nextThread(vmThread);
            }
            trace.string("  returns");
            if (trace.isEnabled() && Statistics.Options.GatherSafepointStatistics.getValue().booleanValue()) {
                trace.string(" with requests: ").signed(Statistics.getRequested());
            }
            trace.string("]").newline();
            return numOfThreads;
        }

        private static void requestSafepoint(IsolateThread vmThread) {
            if (ThreadingSupportImpl.isRecurringCallbackSupported()) {
                int value;
                do {
                    value = safepointRequested.getVolatile(vmThread);
                    assert (value >= 0) : "the value can only be negative if a safepoint was requested";
                } while (!safepointRequested.compareAndSet(vmThread, value, -value));
            } else {
                safepointRequested.setVolatile(vmThread, 0);
            }
            Statistics.incRequested();
        }

        private static void restoreSafepointRequestedValue(IsolateThread vmThread) {
            int value = Safepoint.getSafepointRequested(vmThread);
            if (value < 0) {
                int newValue = -(value + 2);
                assert (newValue >= -2 && newValue < Integer.MAX_VALUE) : "overflow";
                newValue = newValue <= 0 ? 1 : newValue;
                Safepoint.setSafepointRequested(vmThread, newValue);
            }
        }

        private static void waitForSafepoints(String reason) {
            long startNanos;
            VMThreads.THREAD_MUTEX.assertIsOwner("Must hold mutex while waiting for safepoints.");
            long loopNanos = startNanos = System.nanoTime();
            long warningNanos = -1L;
            long failureNanos = -1L;
            int loopCount = 1;
            while (true) {
                int atSafepoint = 0;
                int ignoreSafepoints = 0;
                int notAtSafepoint = 0;
                int lostUpdates = 0;
                IsolateThread vmThread = VMThreads.firstThread();
                while (vmThread.isNonNull()) {
                    if (!Master.isMyself(vmThread)) {
                        int status = VMThreads.StatusSupport.getStatusVolatile(vmThread);
                        int safepointBehavior = VMThreads.SafepointBehavior.getSafepointBehaviorVolatile(vmThread);
                        if (safepointBehavior == 1) {
                            ++notAtSafepoint;
                        } else if (safepointBehavior == 2) {
                            ++ignoreSafepoints;
                        } else {
                            assert (safepointBehavior == 0);
                            switch (status) {
                                case 1: 
                                case 4: {
                                    if (Safepoint.getSafepointRequested(vmThread) > 0) {
                                        Master.requestSafepoint(vmThread);
                                        ++lostUpdates;
                                    }
                                    ++notAtSafepoint;
                                    break;
                                }
                                case 2: {
                                    ++atSafepoint;
                                    break;
                                }
                                case 3: {
                                    if (VMThreads.StatusSupport.compareAndSetNativeToSafepoint(vmThread)) {
                                        ++atSafepoint;
                                        Statistics.incInstalled();
                                        break;
                                    }
                                    ++notAtSafepoint;
                                    break;
                                }
                                default: {
                                    throw VMError.shouldNotReachHere("Unexpected thread status");
                                }
                            }
                        }
                    }
                    vmThread = VMThreads.nextThread(vmThread);
                }
                if (notAtSafepoint == 0) {
                    return;
                }
                if (warningNanos == -1L || failureNanos == -1L) {
                    warningNanos = Safepoint.getSafepointPromptnessWarningNanos();
                    failureNanos = Safepoint.getSafepointPromptnessFailureNanos();
                }
                long nanosSinceStart = TimeUtils.nanoSecondsSince(startNanos);
                if (warningNanos > 0L || failureNanos > 0L) {
                    boolean fatalError;
                    long nanosSinceLastWarning = TimeUtils.nanoSecondsSince(loopNanos);
                    boolean printWarning = warningNanos > 0L && TimeUtils.nanoTimeLessThan(warningNanos, nanosSinceLastWarning);
                    boolean bl = fatalError = failureNanos > 0L && TimeUtils.nanoTimeLessThan(failureNanos, nanosSinceStart);
                    if (printWarning || fatalError) {
                        Log.log().string("[Safepoint.Master: not all threads reached a safepoint (").string(reason).string(") within ").signed(warningNanos).string(" ns. Total wait time so far: ").signed(nanosSinceStart).string(" ns.").newline();
                        Log.log().string("  loopCount: ").signed(loopCount).string("  atSafepoint: ").signed(atSafepoint).string("  ignoreSafepoints: ").signed(ignoreSafepoints).string("  notAtSafepoint: ").signed(notAtSafepoint).string("  lostUpdates: ").signed(lostUpdates).string("]").newline();
                        loopNanos = System.nanoTime();
                        if (fatalError) {
                            VMError.guarantee(false, "Safepoint promptness failure.");
                        }
                    }
                }
                if (VMThreads.singleton().supportsNativeYieldAndSleep()) {
                    if (nanosSinceStart < 1000000L) {
                        VMThreads.singleton().yield();
                    } else {
                        VMThreads.singleton().nativeSleep(1);
                    }
                } else {
                    PauseNode.pause();
                }
                ++loopCount;
            }
        }

        private static void releaseSafepoints(String reason) {
            Log trace = Log.noopLog().string("[Safepoint.Master.releaseSafepoints:").string("  reason: ").string(reason).newline();
            VMThreads.THREAD_MUTEX.assertIsOwner("Must hold mutex when releasing safepoints.");
            IsolateThread vmThread = VMThreads.firstThread();
            while (vmThread.isNonNull()) {
                if (!Master.isMyself(vmThread) && !VMThreads.SafepointBehavior.ignoresSafepoints(vmThread)) {
                    if (trace.isEnabled()) {
                        trace.string("  vmThread status: ").string(VMThreads.StatusSupport.getStatusString(vmThread));
                    }
                    Master.restoreSafepointRequestedValue(vmThread);
                    VMThreads.StatusSupport.setStatusNative(vmThread);
                    Statistics.incReleased();
                    if (trace.isEnabled()) {
                        trace.string("  ->  ").string(VMThreads.StatusSupport.getStatusString(vmThread)).newline();
                    }
                }
                vmThread = VMThreads.nextThread(vmThread);
            }
            trace.string("]").newline();
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected IsolateThread getRequestingThread() {
            return this.requestingThread;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected boolean isFrozen() {
            return this.safepointState == 2;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public UnsignedWord getSafepointId() {
            return this.safepointId;
        }

        public static class TestingBackdoor {
            public static int countingVMOperation() {
                Log trace = Log.log().string("[Safepoint.Master.TestingBackdoor.countingVMOperation:").newline();
                int atSafepoint = 0;
                int ignoreSafepoints = 0;
                int notAtSafepoint = 0;
                IsolateThread vmThread = VMThreads.firstThread();
                while (vmThread.isNonNull()) {
                    int safepointBehavior = VMThreads.SafepointBehavior.getSafepointBehaviorVolatile(vmThread);
                    int status = VMThreads.StatusSupport.getStatusVolatile(vmThread);
                    if (safepointBehavior == 1) {
                        ++notAtSafepoint;
                    } else if (safepointBehavior == 2) {
                        ++ignoreSafepoints;
                    } else {
                        assert (safepointBehavior == 0);
                        switch (status) {
                            case 2: {
                                ++atSafepoint;
                                break;
                            }
                            default: {
                                ++notAtSafepoint;
                            }
                        }
                    }
                    vmThread = VMThreads.nextThread(vmThread);
                }
                trace.string("  atSafepoint: ").signed(atSafepoint).string("  ignoreSafepoints: ").signed(ignoreSafepoints).string("  notAtSafepoint: ").signed(notAtSafepoint);
                trace.string("]").newline();
                return atSafepoint;
            }

            @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
            public static int getCurrentThreadSafepointRequestedCount() {
                return Safepoint.getSafepointRequested(CurrentIsolate.getCurrentThread());
            }
        }
    }

    static class SafepointException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        final Throwable inner;

        SafepointException(Throwable inner) {
            this.inner = inner;
        }
    }

    public static class Options {
        public static final RuntimeOptionKey<Long> SafepointPromptnessWarningNanos = new RuntimeOptionKey<Long>(TimeUtils.millisToNanos(0L), RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
        public static final RuntimeOptionKey<Long> SafepointPromptnessFailureNanos = new RuntimeOptionKey<Long>(TimeUtils.millisToNanos(0L), RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
    }
}

