/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.thread.VMThreads;
import jdk.internal.misc.Unsafe;
import org.graalvm.compiler.nodes.PauseNode;

public class SpinLockUtils {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();

    @Uninterruptible(reason="This method does not do a transition, so the whole critical section must be uninterruptible.", callerMustBe=true)
    public static void lockNoTransition(Object obj, long intFieldOffset) {
        if (UNSAFE.compareAndSetInt(obj, intFieldOffset, 0, 1)) {
            return;
        }
        int yields = 0;
        while (true) {
            if (UNSAFE.getIntVolatile(obj, intFieldOffset) != 0) {
                if (VMThreads.singleton().supportsNativeYieldAndSleep()) {
                    if (yields > 5) {
                        VMThreads.singleton().nativeSleep(1);
                        continue;
                    }
                    VMThreads.singleton().yield();
                    ++yields;
                    continue;
                }
                PauseNode.pause();
                continue;
            }
            if (UNSAFE.compareAndSetInt(obj, intFieldOffset, 0, 1)) break;
        }
    }

    @Uninterruptible(reason="The whole critical section must be uninterruptible.", callerMustBe=true)
    public static void unlock(Object obj, long intFieldOffset) {
        UNSAFE.putIntVolatile(obj, intFieldOffset, 0);
    }
}

