/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.logging.ConsoleHandler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
public class LoggingFeature
implements Feature {
    private final boolean trace = Options.TraceLoggingFeature.getValue();
    private boolean reflectionConfigured = false;
    private Field loggersField;

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return Options.EnableLoggingFeature.getValue();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        LogManager.getLogManager();
        this.loggersField = ((FeatureImpl.DuringSetupAccessImpl)access).findField("sun.util.logging.PlatformLogger", "loggers");
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        access.rescanRoot(this.loggersField);
        if (!this.reflectionConfigured && access.getMetaAccess().optionalLookupJavaType(Logger.class).isPresent()) {
            this.registerForReflection(ConsoleHandler.class);
            this.registerForReflection(SimpleFormatter.class);
            this.reflectionConfigured = true;
            access.requireAnalysisIteration();
        }
    }

    private void registerForReflection(Class<?> clazz) {
        try {
            this.trace("Registering " + clazz + " for reflection.");
            RuntimeReflection.register((Class[])new Class[]{clazz});
            RuntimeReflection.register((Executable[])new Executable[]{clazz.getConstructor(new Class[0])});
        }
        catch (NoSuchMethodException e) {
            VMError.shouldNotReachHere(e);
        }
    }

    private void trace(String msg) {
        if (this.trace) {
            System.out.println("LoggingFeature: " + msg);
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> EnableLoggingFeature = new HostedOptionKey<Boolean>(true);
        public static final HostedOptionKey<Boolean> TraceLoggingFeature = new HostedOptionKey<Boolean>(false);
    }
}

