/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.option.ValidatableOptionKey;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class ValidateImageBuildOptionsFeature
implements InternalFeature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        UnmodifiableMapCursor cursor = RuntimeOptionValues.singleton().getMap().getEntries();
        while (cursor.advance()) {
            ValidateImageBuildOptionsFeature.validate((OptionKey)cursor.getKey());
        }
        cursor = HostedOptionValues.singleton().getMap().getEntries();
        while (cursor.advance()) {
            ValidateImageBuildOptionsFeature.validate((OptionKey)cursor.getKey());
        }
    }

    private static void validate(OptionKey<?> option) {
        ValidatableOptionKey o;
        if (option instanceof ValidatableOptionKey && (o = (ValidatableOptionKey)option).hasBeenSet()) {
            o.validate();
        }
    }
}

