/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.stack.ParameterizedStackFrameVisitor;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

class SamplingStackVisitor
extends ParameterizedStackFrameVisitor<StackTrace> {
    SamplingStackVisitor() {
    }

    @Override
    protected boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame, StackTrace data) {
        VMError.guarantee(data.num < 2048, "The call stack depth of the thread  exceeds the maximal set value.");
        data.data[data.num++] = ip.rawValue();
        return true;
    }

    @Override
    protected boolean unknownFrame(Pointer sp, CodePointer ip, DeoptimizedFrame deoptimizedFrame, StackTrace data) {
        return false;
    }

    public static class StackTrace {
        static final int MAX_STACK_DEPTH = 2048;
        long[] data = new long[2048];
        int num = 0;
    }
}

