/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c;

import com.oracle.svm.core.c.struct.OffsetOf;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.PointerBase;

public final class OffsetOfSupportImpl
implements OffsetOf.Support {
    private final NativeLibraries nativeLibraries;
    private final MetaAccessProvider metaAccess;

    public OffsetOfSupportImpl(NativeLibraries nativeLibraries, MetaAccessProvider metaAccess) {
        this.nativeLibraries = nativeLibraries;
        this.metaAccess = metaAccess;
    }

    @Override
    public int offsetOf(Class<? extends PointerBase> clazz, String fieldName) {
        ResolvedJavaType type = this.metaAccess.lookupJavaType(clazz);
        ElementInfo typeInfo = this.nativeLibraries.findElementInfo((AnnotatedElement)type);
        VMError.guarantee(typeInfo instanceof StructInfo, "Class parameter " + type.toJavaName(true) + " of call to " + SizeOf.class.getSimpleName() + " is not an annotated C struct");
        StructInfo structInfo = (StructInfo)typeInfo;
        for (ElementInfo element : structInfo.getChildren()) {
            StructFieldInfo field;
            if (!(element instanceof StructFieldInfo) || !(field = (StructFieldInfo)element).getName().equals(fieldName)) continue;
            return field.getOffsetInfo().getProperty();
        }
        throw VMError.shouldNotReachHere("Field " + fieldName + " of C struct " + type.toJavaName(true) + " was not found");
    }
}

