/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoImpl;
import com.oracle.svm.core.code.CodeInfoTether;
import com.oracle.svm.core.code.InstalledCodeObserver;
import com.oracle.svm.core.code.InstalledCodeObserverSupport;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.code.UntetheredCodeInfoAccess;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.heap.CodeReferenceMapDecoder;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.util.VMError;
import java.util.EnumSet;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class RuntimeCodeInfoAccess {
    private static final NonmovableArrayAction RELEASE_ACTION = new NonmovableArrayAction(){

        @Override
        @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
        public void apply(NonmovableArray<?> array) {
            NonmovableArrays.releaseUnmanagedArray(array);
        }
    };
    private static final NonmovableArrayAction GUARANTEE_ALL_OBJECTS_IN_IMAGE_HEAP_ACTION = new NonmovableArrayAction(){

        @Override
        @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
        public void apply(NonmovableArray<?> arg) {
            NonmovableObjectArray array = (NonmovableObjectArray)arg;
            if (array.isNonNull()) {
                int length = NonmovableArrays.lengthOf(array);
                for (int i = 0; i < length; ++i) {
                    Object obj = NonmovableArrays.getObject(array, i);
                    VMError.guarantee(obj == null || Heap.getHeap().isInImageHeap(obj));
                }
            }
        }
    };

    private RuntimeCodeInfoAccess() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static SubstrateInstalledCode getInstalledCode(CodeInfo info) {
        return (SubstrateInstalledCode)CodeInfoAccess.getObjectField(info, 2);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> getCodeObserverHandles(CodeInfo info) {
        return RuntimeCodeInfoAccess.cast(info).getCodeObserverHandles();
    }

    public static void initialize(CodeInfo info, Pointer codeStart, int codeSize, int dataOffset, int dataSize, int codeAndDataMemorySize, int tier, NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> observerHandles, boolean allObjectsAreInImageHeap) {
        CodeInfoImpl impl = RuntimeCodeInfoAccess.cast(info);
        impl.setCodeStart((CodePointer)codeStart);
        impl.setCodeSize(WordFactory.unsigned((int)codeSize));
        impl.setDataOffset(WordFactory.unsigned((int)dataOffset));
        impl.setDataSize(WordFactory.unsigned((int)dataSize));
        impl.setCodeAndDataMemorySize(WordFactory.unsigned((int)codeAndDataMemorySize));
        impl.setTier(tier);
        impl.setCodeObserverHandles(observerHandles);
        impl.setAllObjectsAreInImageHeap(allObjectsAreInImageHeap);
    }

    public static void setCodeObjectConstantsInfo(CodeInfo info, NonmovableArray<Byte> refMapEncoding, long refMapIndex) {
        CodeInfoImpl impl = RuntimeCodeInfoAccess.cast(info);
        assert (impl.getCodeStart().isNonNull());
        impl.setCodeConstantsReferenceMapEncoding(refMapEncoding);
        impl.setCodeConstantsReferenceMapIndex(refMapIndex);
    }

    public static NonmovableArray<Byte> getCodeConstantsReferenceMapEncoding(CodeInfo info) {
        return RuntimeCodeInfoAccess.cast(info).getCodeConstantsReferenceMapEncoding();
    }

    public static long getCodeConstantsReferenceMapIndex(CodeInfo info) {
        return RuntimeCodeInfoAccess.cast(info).getCodeConstantsReferenceMapIndex();
    }

    public static NonmovableArray<Byte> getDeoptimizationEncodings(CodeInfo info) {
        return RuntimeCodeInfoAccess.cast(info).getDeoptimizationEncodings();
    }

    public static NonmovableArray<Integer> getDeoptimizationStartOffsets(CodeInfo info) {
        return RuntimeCodeInfoAccess.cast(info).getDeoptimizationStartOffsets();
    }

    public static NonmovableObjectArray<Object> getDeoptimizationObjectConstants(CodeInfo info) {
        return RuntimeCodeInfoAccess.cast(info).getDeoptimizationObjectConstants();
    }

    @Uninterruptible(reason="Nonmovable object arrays are not visible to GC until installed.")
    public static void setDeoptimizationMetadata(CodeInfo info, NonmovableArray<Integer> startOffsets, NonmovableArray<Byte> encodings, NonmovableObjectArray<Object> objectConstants) {
        CodeInfoImpl impl = RuntimeCodeInfoAccess.cast(info);
        impl.setDeoptimizationStartOffsets(startOffsets);
        impl.setDeoptimizationEncodings(encodings);
        impl.setDeoptimizationObjectConstants(objectConstants);
        if (!SubstrateUtil.HOSTED) {
            Heap.getHeap().getRuntimeCodeInfoGCSupport().registerDeoptMetadata(impl);
        }
    }

    public static CodeInfoTether beforeInstallInCurrentIsolate(CodeInfo info, SubstrateInstalledCode installedCode) {
        CodeInfoTether tether = new CodeInfoTether(true);
        RuntimeCodeInfoAccess.setObjectData(info, tether, installedCode.getName(), installedCode);
        return tether;
    }

    @Uninterruptible(reason="Makes the object data visible to the GC.")
    private static void setObjectData(CodeInfo info, CodeInfoTether tether, String name, SubstrateInstalledCode installedCode) {
        NonmovableObjectArray<Object> objectFields = RuntimeCodeInfoAccess.cast(info).getObjectFields();
        NonmovableArrays.setObject(objectFields, 0, tether);
        NonmovableArrays.setObject(objectFields, 1, name);
        NonmovableArrays.setObject(objectFields, 2, installedCode);
        if (!SubstrateUtil.HOSTED) {
            Heap.getHeap().getRuntimeCodeInfoGCSupport().registerObjectFields(info);
        }
    }

    public static Object[] prepareHeapObjectData(CodeInfoTether tether, String name, SubstrateInstalledCode installedCode) {
        Object[] objectFields = new Object[]{tether, name, installedCode};
        return objectFields;
    }

    public static boolean areAllObjectsOnImageHeap(CodeInfo info) {
        return RuntimeCodeInfoAccess.cast(info).getAllObjectsAreInImageHeap();
    }

    public static boolean walkStrongReferences(CodeInfo info, ObjectReferenceVisitor visitor) {
        return NonmovableArrays.walkUnmanagedObjectArray(RuntimeCodeInfoAccess.cast(info).getObjectFields(), visitor, 0, 2);
    }

    public static boolean walkWeakReferences(CodeInfo info, ObjectReferenceVisitor visitor) {
        CodeInfoImpl impl = RuntimeCodeInfoAccess.cast(info);
        boolean continueVisiting = true;
        boolean bl = continueVisiting = continueVisiting && NonmovableArrays.walkUnmanagedObjectArray(impl.getObjectFields(), visitor, 2, 1);
        if (CodeInfoAccess.isAliveState(impl.getState())) {
            continueVisiting = continueVisiting && CodeReferenceMapDecoder.walkOffsetsFromPointer((PointerBase)impl.getCodeStart(), impl.getCodeConstantsReferenceMapEncoding(), impl.getCodeConstantsReferenceMapIndex(), visitor, null);
        }
        continueVisiting = continueVisiting && NonmovableArrays.walkUnmanagedObjectArray(impl.getFrameInfoObjectConstants(), visitor);
        continueVisiting = continueVisiting && NonmovableArrays.walkUnmanagedObjectArray(impl.getFrameInfoSourceClasses(), visitor);
        continueVisiting = continueVisiting && NonmovableArrays.walkUnmanagedObjectArray(impl.getFrameInfoSourceMethodNames(), visitor);
        continueVisiting = continueVisiting && NonmovableArrays.walkUnmanagedObjectArray(impl.getDeoptimizationObjectConstants(), visitor);
        return continueVisiting;
    }

    public static boolean walkObjectFields(CodeInfo info, ObjectReferenceVisitor visitor) {
        return NonmovableArrays.walkUnmanagedObjectArray(RuntimeCodeInfoAccess.cast(info).getObjectFields(), visitor);
    }

    public static CodeInfo allocateMethodInfo() {
        NonmovableObjectArray<Object> objectFields = NonmovableArrays.createObjectArray(Object[].class, 3);
        return RuntimeCodeInfoAccess.allocateMethodInfo(objectFields);
    }

    public static CodeInfo allocateMethodInfo(NonmovableObjectArray<Object> objectData) {
        CodeInfoImpl info = (CodeInfoImpl)UnmanagedMemory.calloc((UnsignedWord)CodeInfoAccess.getSizeOfCodeInfo());
        assert (objectData.isNonNull() && NonmovableArrays.lengthOf(objectData) == 3);
        info.setObjectFields(objectData);
        RuntimeCodeInfoMemory.singleton().add(info);
        return info;
    }

    @Uninterruptible(reason="Prevent the GC from running - otherwise, it could accidentally visit the freed memory.")
    static void freePartially(CodeInfo info, boolean notifyGC) {
        CodeInfoImpl impl = RuntimeCodeInfoAccess.cast(info);
        assert (CodeInfoAccess.isAliveState(impl.getState()) || impl.getState() == 3) : "unexpected state (probably already released)";
        if (notifyGC) {
            Heap.getHeap().getRuntimeCodeInfoGCSupport().unregisterCodeConstants(info);
        }
        NonmovableArrays.releaseUnmanagedArray(impl.getCodeObserverHandles());
        impl.setCodeObserverHandles((NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle>)NonmovableArrays.nullArray());
        RuntimeCodeInfoAccess.releaseCodeMemory(impl.getCodeStart(), impl.getCodeAndDataMemorySize());
        CodeInfoAccess.setState(info, 4);
    }

    public static CodePointer allocateCodeMemory(UnsignedWord size) {
        return (CodePointer)CommittedMemoryProvider.get().allocateExecutableMemory(size, WordFactory.unsigned((int)SubstrateOptions.codeAlignment()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void releaseCodeMemory(CodePointer codeStart, UnsignedWord codeSize) {
        CommittedMemoryProvider.get().freeExecutableMemory((PointerBase)codeStart, codeSize, WordFactory.unsigned((int)SubstrateOptions.codeAlignment()));
    }

    public static int makeCodeMemoryExecutableReadOnly(CodePointer codeStart, UnsignedWord codeSize) {
        return CommittedMemoryProvider.get().protect((PointerBase)codeStart, codeSize, EnumSet.of(CommittedMemoryProvider.Access.READ, CommittedMemoryProvider.Access.EXECUTE));
    }

    public static int makeCodeMemoryExecutableWritable(CodePointer start, UnsignedWord size) {
        return CommittedMemoryProvider.get().protect((PointerBase)start, size, EnumSet.of(CommittedMemoryProvider.Access.READ, CommittedMemoryProvider.Access.WRITE, CommittedMemoryProvider.Access.EXECUTE));
    }

    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    static void releaseMethodInfoOnTearDown(CodeInfo info) {
        InstalledCodeObserverSupport.removeObserversOnTearDown(RuntimeCodeInfoAccess.getCodeObserverHandles(info));
        assert (((CodeInfoTether)UntetheredCodeInfoAccess.getTetherUnsafe(info)).getCount() == 1) : "CodeInfo tether must not be referenced by non-teardown code.";
        RuntimeCodeInfoAccess.free(info, true);
    }

    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public static void free(CodeInfo info, boolean notifyGC) {
        CodeInfoImpl impl = RuntimeCodeInfoAccess.cast(info);
        if (CodeInfoAccess.isAliveState(impl.getState()) || impl.getState() == 3) {
            RuntimeCodeInfoAccess.freePartially(info, notifyGC);
        }
        if (notifyGC) {
            Heap.getHeap().getRuntimeCodeInfoGCSupport().unregisterRuntimeCodeInfo(info);
        }
        if (!impl.getAllObjectsAreInImageHeap()) {
            RuntimeCodeInfoAccess.forEachArray(info, RELEASE_ACTION);
        }
        impl.setState(6);
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)info);
    }

    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public static void guaranteeAllObjectsInImageHeap(CodeInfo info) {
        RuntimeCodeInfoAccess.forEachObjectArray(info, GUARANTEE_ALL_OBJECTS_IN_IMAGE_HEAP_ACTION);
    }

    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public static void forEachArray(CodeInfo info, NonmovableArrayAction action) {
        CodeInfoImpl impl = RuntimeCodeInfoAccess.cast(info);
        action.apply(impl.getCodeInfoIndex());
        action.apply(impl.getCodeInfoEncodings());
        action.apply(impl.getStackReferenceMapEncoding());
        action.apply(impl.getFrameInfoEncodings());
        action.apply(impl.getDeoptimizationStartOffsets());
        action.apply(impl.getDeoptimizationEncodings());
        action.apply(impl.getCodeConstantsReferenceMapEncoding());
        action.apply(impl.getCodeObserverHandles());
        RuntimeCodeInfoAccess.forEachObjectArray(info, action);
    }

    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public static void forEachObjectArray(CodeInfo info, NonmovableArrayAction action) {
        CodeInfoImpl impl = RuntimeCodeInfoAccess.cast(info);
        action.apply(impl.getObjectFields());
        action.apply(impl.getFrameInfoObjectConstants());
        action.apply(impl.getFrameInfoSourceClasses());
        action.apply(impl.getFrameInfoSourceMethodNames());
        action.apply(impl.getDeoptimizationObjectConstants());
    }

    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    private static CodeInfoImpl cast(CodeInfo info) {
        assert (CodeInfoAccess.isValid(info));
        return (CodeInfoImpl)info;
    }

    public static interface NonmovableArrayAction {
        @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
        public void apply(NonmovableArray<?> var1);
    }
}

