/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.graal.nodes.SubstrateFieldLocationIdentity;
import com.oracle.svm.core.util.Counter;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;

public class SubstrateTemplates
extends SnippetTemplate.AbstractTemplates {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected SubstrateTemplates(OptionValues options, Providers providers) {
        super(options, providers);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected SnippetTemplate.SnippetInfo snippet(Class<? extends Snippets> declaringClass, String methodName, ResolvedJavaMethod original, Object receiver, LocationIdentity ... privateLocations) {
        return this.snippet(declaringClass, methodName, original, receiver, (Object[])privateLocations);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected SnippetTemplate.SnippetInfo snippet(Class<? extends Snippets> declaringClass, String methodName, Object receiver, Object[] privateLocations) {
        return this.snippet(declaringClass, methodName, null, receiver, privateLocations);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected SnippetTemplate.SnippetInfo snippet(Class<? extends Snippets> declaringClass, String methodName, Object[] privateLocations) {
        return this.snippet(declaringClass, methodName, null, null, privateLocations);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected SnippetTemplate.SnippetInfo snippet(Class<? extends Snippets> declaringClass, String methodName, ResolvedJavaMethod original, Object receiver, Object[] privateLocations) {
        return super.snippet(declaringClass, methodName, original, receiver, SubstrateTemplates.toLocationIdentity(this.providers.getMetaAccess(), privateLocations));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static LocationIdentity[] toLocationIdentity(MetaAccessProvider metaAccess, Object[] objects) {
        ArrayList<LocationIdentity> locations = new ArrayList<LocationIdentity>(objects.length + 1);
        for (Object object : objects) {
            SubstrateTemplates.addLocationIdentity(metaAccess, object, locations);
        }
        SubstrateTemplates.addLocationIdentity(metaAccess, Counter.VALUE_FIELD, locations);
        return locations.toArray(new LocationIdentity[locations.size()]);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void addLocationIdentity(MetaAccessProvider metaAccess, Object object, List<LocationIdentity> locations) {
        Object location;
        if (object instanceof LocationIdentity) {
            location = (LocationIdentity)object;
        } else if (object instanceof Field) {
            location = new SubstrateFieldLocationIdentity(metaAccess.lookupJavaField((Field)object));
        } else {
            throw VMError.shouldNotReachHere("Cannot convert to LocationIdentity: " + object.getClass().getName());
        }
        if (location.isMutable()) {
            locations.add((LocationIdentity)location);
        }
    }
}

