/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.headers.Sysctl;
import com.oracle.svm.core.posix.headers.darwin.DarwinSysctl;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={PhysicalMemory.PhysicalMemorySupport.class})
class PhysicalMemorySupportImpl
implements PhysicalMemory.PhysicalMemorySupport {
    PhysicalMemorySupportImpl() {
    }

    @Override
    public UnsignedWord size() {
        CIntPointer namePointer = (CIntPointer)StackValue.get((int)2, CIntPointer.class);
        namePointer.write(0, DarwinSysctl.CTL_HW());
        namePointer.write(1, DarwinSysctl.HW_MEMSIZE());
        WordPointer physicalMemoryPointer = (WordPointer)StackValue.get(WordPointer.class);
        WordPointer physicalMemorySizePointer = (WordPointer)StackValue.get(WordPointer.class);
        physicalMemorySizePointer.write((WordBase)SizeOf.unsigned(WordPointer.class));
        int sysctlResult = Sysctl.sysctl(namePointer, 2L, (PointerBase)physicalMemoryPointer, physicalMemorySizePointer, WordFactory.nullPointer(), 0L);
        if (sysctlResult != 0) {
            Log.log().string("DarwinPhysicalMemory.PhysicalMemorySupportImpl.size(): sysctl() returns with errno: ").signed(LibC.errno()).newline();
            throw VMError.shouldNotReachHere("DarwinPhysicalMemory.PhysicalMemorySupportImpl.size() failed.");
        }
        return (UnsignedWord)physicalMemoryPointer.read();
    }
}

