/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.target;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.reflect.ReflectionMetadataDecoder;
import com.oracle.svm.core.reflect.Target_java_lang_reflect_RecordComponent;
import com.oracle.svm.core.reflect.target.ReflectionMetadataEncoding;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_AccessibleObject;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Constructor;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Executable;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Field;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Method;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Parameter;
import com.oracle.svm.core.reflect.target.Target_jdk_internal_reflect_ConstructorAccessor;
import com.oracle.svm.core.reflect.target.Target_jdk_internal_reflect_MethodAccessor;
import com.oracle.svm.core.util.ByteArrayReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.function.Function;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeReader;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticallyRegisteredImageSingleton(value={ReflectionMetadataDecoder.class})
public class ReflectionMetadataDecoderImpl
implements ReflectionMetadataDecoder {
    public static final int FIRST_ERROR_INDEX = -2;
    public static final int NO_METHOD_METADATA = -1;
    public static final int NULL_OBJECT = -1;
    public static final int COMPLETE_FLAG_INDEX = 31;
    public static final int COMPLETE_FLAG_MASK = Integer.MIN_VALUE;
    public static final int IN_HEAP_FLAG_INDEX = 30;
    public static final int IN_HEAP_FLAG_MASK = 0x40000000;
    public static final int HIDING_FLAG_INDEX = 29;
    public static final int HIDING_FLAG_MASK = 0x20000000;
    public static final int ALL_FLAGS_MASK = -536870912;

    static byte[] getEncoding() {
        return ((ReflectionMetadataEncoding)ImageSingletons.lookup(ReflectionMetadataEncoding.class)).getEncoding();
    }

    @Override
    public Field[] parseFields(DynamicHub declaringType, int index, boolean publicOnly, boolean reflectOnly) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        CodeInfo codeInfo = CodeInfoTable.getImageCodeInfo();
        return ReflectionMetadataDecoderImpl.decodeArray(reader, Field.class, i -> ReflectionMetadataDecoderImpl.decodeField(reader, codeInfo, DynamicHub.toClass(declaringType), publicOnly, reflectOnly));
    }

    @Override
    public Method[] parseMethods(DynamicHub declaringType, int index, boolean publicOnly, boolean reflectOnly) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        CodeInfo codeInfo = CodeInfoTable.getImageCodeInfo();
        return ReflectionMetadataDecoderImpl.decodeArray(reader, Method.class, i -> ReflectionMetadataDecoderImpl.decodeMethod(reader, codeInfo, DynamicHub.toClass(declaringType), publicOnly, reflectOnly));
    }

    @Override
    public Constructor<?>[] parseConstructors(DynamicHub declaringType, int index, boolean publicOnly, boolean reflectOnly) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        CodeInfo codeInfo = CodeInfoTable.getImageCodeInfo();
        return ReflectionMetadataDecoderImpl.decodeArray(reader, Constructor.class, i -> ReflectionMetadataDecoderImpl.decodeConstructor(reader, codeInfo, DynamicHub.toClass(declaringType), publicOnly, reflectOnly));
    }

    @Override
    public Class<?>[] parseClasses(int index) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        CodeInfo codeInfo = CodeInfoTable.getImageCodeInfo();
        return ReflectionMetadataDecoderImpl.decodeArray(reader, Class.class, i -> ReflectionMetadataDecoderImpl.decodeType(reader, codeInfo));
    }

    @Override
    public Target_java_lang_reflect_RecordComponent[] parseRecordComponents(DynamicHub declaringType, int index) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        CodeInfo codeInfo = CodeInfoTable.getImageCodeInfo();
        return ReflectionMetadataDecoderImpl.decodeArray(reader, Target_java_lang_reflect_RecordComponent.class, i -> ReflectionMetadataDecoderImpl.decodeRecordComponent(reader, codeInfo, DynamicHub.toClass(declaringType)));
    }

    @Override
    public Parameter[] parseReflectParameters(Executable executable, byte[] encoding) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])encoding, (long)0L, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        CodeInfo codeInfo = CodeInfoTable.getImageCodeInfo();
        return ReflectionMetadataDecoderImpl.decodeArray(reader, Parameter.class, i -> ReflectionMetadataDecoderImpl.decodeReflectParameter(reader, codeInfo, executable, i));
    }

    @Override
    public Object[] parseEnclosingMethod(int index) {
        if (ReflectionMetadataDecoderImpl.isErrorIndex(index)) {
            ReflectionMetadataDecoderImpl.decodeAndThrowError(index);
        }
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        CodeInfo codeInfo = CodeInfoTable.getImageCodeInfo();
        Class<?> declaringClass = ReflectionMetadataDecoderImpl.decodeType(reader, codeInfo);
        String name = ReflectionMetadataDecoderImpl.decodeName(reader, codeInfo);
        String descriptor = ReflectionMetadataDecoderImpl.decodeName(reader, codeInfo);
        return new Object[]{declaringClass, name, descriptor};
    }

    @Override
    public byte[] parseByteArray(int index) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])ReflectionMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return ReflectionMetadataDecoderImpl.decodeByteArray(reader);
    }

    @Override
    public boolean isHiding(int modifiers) {
        return (modifiers & 0x20000000) != 0;
    }

    @Override
    public long getMetadataByteLength() {
        return ((ReflectionMetadataEncoding)ImageSingletons.lookup(ReflectionMetadataEncoding.class)).getEncoding().length;
    }

    public static boolean isErrorIndex(int index) {
        return index < -1;
    }

    private static <T extends Throwable> void decodeAndThrowError(int index) throws T {
        assert (ReflectionMetadataDecoderImpl.isErrorIndex(index));
        int decodedIndex = -2 - index;
        throw (Throwable)NonmovableArrays.getObject(CodeInfoAccess.getFrameInfoObjectConstants(CodeInfoTable.getImageCodeInfo()), decodedIndex);
    }

    private static Field decodeField(UnsafeArrayTypeReader buf, CodeInfo info, Class<?> declaringClass, boolean publicOnly, boolean reflectOnly) {
        Class<?> type;
        boolean hiding;
        boolean complete;
        int modifiers = buf.getUVInt();
        boolean inHeap = (modifiers & 0x40000000) != 0;
        boolean bl = complete = (modifiers & Integer.MIN_VALUE) != 0;
        if (inHeap) {
            Field field = (Field)ReflectionMetadataDecoderImpl.decodeObject(buf, info);
            if (publicOnly && !Modifier.isPublic(field.getModifiers())) {
                return null;
            }
            if (reflectOnly && !complete) {
                return null;
            }
            return field;
        }
        boolean bl2 = hiding = (modifiers & 0x20000000) != 0;
        assert (!complete || !hiding);
        modifiers &= Integer.MAX_VALUE;
        String name = ReflectionMetadataDecoderImpl.decodeName(buf, info);
        Class<?> clazz = type = complete || hiding ? ReflectionMetadataDecoderImpl.decodeType(buf, info) : null;
        if (!complete) {
            if (reflectOnly != hiding) {
                return null;
            }
            Target_java_lang_reflect_Field field = new Target_java_lang_reflect_Field();
            if (JavaVersionUtil.JAVA_SPEC >= 17) {
                field.constructorJDK17OrLater(declaringClass, name, type, modifiers, false, -1, null, null);
            } else {
                field.constructorJDK11OrEarlier(declaringClass, name, type, modifiers, -1, null, null);
            }
            return SubstrateUtil.cast(field, Field.class);
        }
        boolean trustedFinal = JavaVersionUtil.JAVA_SPEC >= 17 ? buf.getU1() == 1 : false;
        String signature = ReflectionMetadataDecoderImpl.decodeName(buf, info);
        byte[] annotations = ReflectionMetadataDecoderImpl.decodeByteArray(buf);
        byte[] typeAnnotations = ReflectionMetadataDecoderImpl.decodeByteArray(buf);
        int offset = buf.getSVInt();
        String deletedReason = ReflectionMetadataDecoderImpl.decodeName(buf, info);
        if (publicOnly && !Modifier.isPublic(modifiers)) {
            return null;
        }
        Target_java_lang_reflect_Field field = new Target_java_lang_reflect_Field();
        if (JavaVersionUtil.JAVA_SPEC >= 17) {
            field.constructorJDK17OrLater(declaringClass, name, type, modifiers, trustedFinal, -1, signature, annotations);
        } else {
            field.constructorJDK11OrEarlier(declaringClass, name, type, modifiers, -1, signature, annotations);
        }
        field.offset = offset;
        field.deletedReason = deletedReason;
        SubstrateUtil.cast((Object)field, Target_java_lang_reflect_AccessibleObject.class).typeAnnotations = typeAnnotations;
        return SubstrateUtil.cast(field, Field.class);
    }

    private static Method decodeMethod(UnsafeArrayTypeReader buf, CodeInfo info, Class<?> declaringClass, boolean publicOnly, boolean reflectOnly) {
        return (Method)ReflectionMetadataDecoderImpl.decodeExecutable(buf, info, declaringClass, publicOnly, reflectOnly, true);
    }

    private static Constructor<?> decodeConstructor(UnsafeArrayTypeReader buf, CodeInfo info, Class<?> declaringClass, boolean publicOnly, boolean reflectOnly) {
        return (Constructor)ReflectionMetadataDecoderImpl.decodeExecutable(buf, info, declaringClass, publicOnly, reflectOnly, false);
    }

    private static Executable decodeExecutable(UnsafeArrayTypeReader buf, CodeInfo info, Class<?> declaringClass, boolean publicOnly, boolean reflectOnly, boolean isMethod) {
        Target_java_lang_reflect_Executable executable;
        Class<?> returnType;
        boolean hiding;
        boolean complete;
        int modifiers = buf.getUVInt();
        boolean inHeap = (modifiers & 0x40000000) != 0;
        boolean bl = complete = (modifiers & Integer.MIN_VALUE) != 0;
        if (inHeap) {
            Executable executable2 = (Executable)ReflectionMetadataDecoderImpl.decodeObject(buf, info);
            if (publicOnly && !Modifier.isPublic(executable2.getModifiers())) {
                return null;
            }
            if (reflectOnly && !complete) {
                return null;
            }
            return executable2;
        }
        boolean bl2 = hiding = (modifiers & 0x20000000) != 0;
        assert (!complete || !hiding);
        modifiers &= Integer.MAX_VALUE;
        String name = isMethod ? ReflectionMetadataDecoderImpl.decodeName(buf, info) : null;
        Class[] parameterTypes = ReflectionMetadataDecoderImpl.decodeArray(buf, Class.class, i -> ReflectionMetadataDecoderImpl.decodeType(buf, info));
        Class<?> clazz = returnType = isMethod && (complete || hiding) ? ReflectionMetadataDecoderImpl.decodeType(buf, info) : null;
        if (!complete) {
            if (reflectOnly != hiding) {
                return null;
            }
            if (isMethod) {
                Target_java_lang_reflect_Method method = new Target_java_lang_reflect_Method();
                method.constructor(declaringClass, name, parameterTypes, returnType, null, modifiers, -1, null, null, null, null);
                return SubstrateUtil.cast(method, Executable.class);
            }
            Target_java_lang_reflect_Constructor constructor = new Target_java_lang_reflect_Constructor();
            constructor.constructor(declaringClass, parameterTypes, null, modifiers, -1, null, null, null);
            return SubstrateUtil.cast(constructor, Executable.class);
        }
        Class[] exceptionTypes = ReflectionMetadataDecoderImpl.decodeArray(buf, Class.class, i -> ReflectionMetadataDecoderImpl.decodeType(buf, info));
        String signature = ReflectionMetadataDecoderImpl.decodeName(buf, info);
        byte[] annotations = ReflectionMetadataDecoderImpl.decodeByteArray(buf);
        byte[] parameterAnnotations = ReflectionMetadataDecoderImpl.decodeByteArray(buf);
        byte[] annotationDefault = isMethod && declaringClass.isAnnotation() ? ReflectionMetadataDecoderImpl.decodeByteArray(buf) : null;
        byte[] typeAnnotations = ReflectionMetadataDecoderImpl.decodeByteArray(buf);
        byte[] reflectParameters = ReflectionMetadataDecoderImpl.decodeByteArray(buf);
        Object accessor = ReflectionMetadataDecoderImpl.decodeObject(buf, info);
        if (publicOnly && !Modifier.isPublic(modifiers)) {
            return null;
        }
        if (isMethod) {
            Target_java_lang_reflect_Method method = new Target_java_lang_reflect_Method();
            method.constructor(declaringClass, name, parameterTypes, returnType, exceptionTypes, modifiers, -1, signature, annotations, parameterAnnotations, annotationDefault);
            method.methodAccessor = (Target_jdk_internal_reflect_MethodAccessor)accessor;
            executable = SubstrateUtil.cast(method, Target_java_lang_reflect_Executable.class);
        } else {
            Target_java_lang_reflect_Constructor constructor = new Target_java_lang_reflect_Constructor();
            constructor.constructor(declaringClass, parameterTypes, exceptionTypes, modifiers, -1, signature, annotations, parameterAnnotations);
            constructor.constructorAccessor = (Target_jdk_internal_reflect_ConstructorAccessor)accessor;
            executable = SubstrateUtil.cast(constructor, Target_java_lang_reflect_Executable.class);
        }
        executable.rawParameters = reflectParameters;
        SubstrateUtil.cast((Object)executable, Target_java_lang_reflect_AccessibleObject.class).typeAnnotations = typeAnnotations;
        return SubstrateUtil.cast(executable, Executable.class);
    }

    private static Target_java_lang_reflect_RecordComponent decodeRecordComponent(UnsafeArrayTypeReader buf, CodeInfo info, Class<?> declaringClass) {
        String name = ReflectionMetadataDecoderImpl.decodeName(buf, info);
        Class<?> type = ReflectionMetadataDecoderImpl.decodeType(buf, info);
        String signature = ReflectionMetadataDecoderImpl.decodeName(buf, info);
        Method accessor = (Method)ReflectionMetadataDecoderImpl.decodeObject(buf, info);
        byte[] annotations = ReflectionMetadataDecoderImpl.decodeByteArray(buf);
        byte[] typeAnnotations = ReflectionMetadataDecoderImpl.decodeByteArray(buf);
        Target_java_lang_reflect_RecordComponent recordComponent = new Target_java_lang_reflect_RecordComponent();
        recordComponent.clazz = declaringClass;
        recordComponent.name = name;
        recordComponent.type = type;
        recordComponent.signature = signature;
        recordComponent.accessor = accessor;
        recordComponent.annotations = annotations;
        recordComponent.typeAnnotations = typeAnnotations;
        return recordComponent;
    }

    private static Parameter decodeReflectParameter(UnsafeArrayTypeReader buf, CodeInfo info, Executable executable, int i) {
        String name = ReflectionMetadataDecoderImpl.decodeName(buf, info);
        int modifiers = buf.getUVInt();
        Target_java_lang_reflect_Parameter parameter = new Target_java_lang_reflect_Parameter();
        parameter.constructor(name, modifiers, executable, i);
        return SubstrateUtil.cast(parameter, Parameter.class);
    }

    private static Class<?> decodeType(UnsafeArrayTypeReader buf, CodeInfo info) {
        int classIndex = buf.getSVInt();
        if (classIndex == -1) {
            return null;
        }
        return NonmovableArrays.getObject(CodeInfoAccess.getFrameInfoSourceClasses(info), classIndex);
    }

    private static String decodeName(UnsafeArrayTypeReader buf, CodeInfo info) {
        int nameIndex = buf.getSVInt();
        String name = NonmovableArrays.getObject(CodeInfoAccess.getFrameInfoSourceMethodNames(info), nameIndex);
        return name == null ? null : name.intern();
    }

    private static Object decodeObject(UnsafeArrayTypeReader buf, CodeInfo info) {
        int objectIndex = buf.getSVInt();
        if (objectIndex == -1) {
            return null;
        }
        return NonmovableArrays.getObject(CodeInfoAccess.getFrameInfoObjectConstants(info), objectIndex);
    }

    private static <T> T[] decodeArray(UnsafeArrayTypeReader buf, Class<T> elementType, Function<Integer, T> elementDecoder) {
        int length = buf.getUVInt();
        Object[] result = (Object[])Array.newInstance(elementType, length);
        int valueCount = 0;
        for (int i = 0; i < length; ++i) {
            T element = elementDecoder.apply(i);
            if (element == null) continue;
            result[valueCount++] = element;
        }
        return Arrays.copyOf(result, valueCount);
    }

    private static byte[] decodeByteArray(UnsafeArrayTypeReader buf) {
        int length = buf.getUVInt();
        if (length == -1) {
            return null;
        }
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)buf.getS1();
        }
        return result;
    }
}

