/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image.sources;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.image.sources.SourceCache;
import java.nio.file.Path;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class SourceCacheFeature
implements InternalFeature {
    SourceCacheFeature() {
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        FeatureImpl.AfterAnalysisAccessImpl accessImpl = (FeatureImpl.AfterAnalysisAccessImpl)access;
        ImageClassLoader loader = accessImpl.getImageClassLoader();
        for (Path entry : loader.classpath()) {
            SourceCache.addClassPathEntry(entry);
        }
        for (Path entry : loader.modulepath()) {
            SourceCache.addModulePathEntry(entry);
        }
        if (SubstrateOptions.DebugInfoSourceSearchPath.getValue() != null) {
            for (String searchPathEntry : OptionUtils.flatten(",", SubstrateOptions.DebugInfoSourceSearchPath.getValue())) {
                SourceCache.addSourcePathEntry(searchPathEntry);
            }
        }
    }
}

