/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.traceid;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.traceid.JfrTraceIdEpoch;
import com.oracle.svm.core.jfr.traceid.JfrTraceIdMap;
import jdk.jfr.Event;
import jdk.jfr.internal.Type;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrTraceId {
    private static final int TRACE_ID_SHIFT = 16;
    private static final long JDK_JFR_EVENT_SUBCLASS = 16L;
    private static final long JDK_JFR_EVENT_CLASS = 32L;

    @Uninterruptible(reason="Epoch must not change.")
    public static void setUsedThisEpoch(Class<?> clazz) {
        JfrTraceId.tag(clazz, JfrTraceIdEpoch.getInstance().thisEpochBit());
    }

    @Uninterruptible(reason="Epoch must not change.")
    public static void clearUsedPreviousEpoch(Class<?> clazz) {
        JfrTraceId.clear(clazz, JfrTraceIdEpoch.getInstance().previousEpochBit());
    }

    @Uninterruptible(reason="Epoch must not change.")
    public static boolean isUsedPreviousEpoch(Class<?> clazz) {
        long predicate = JfrTraceIdEpoch.getInstance().previousEpochBit();
        return JfrTraceId.predicate(clazz, predicate);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getTraceIdRaw(Class<?> clazz) {
        return JfrTraceIdMap.singleton().getId(clazz);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getTraceId(Class<?> clazz) {
        long id = JfrTraceId.getTraceIdRaw(clazz);
        return id >>> 16;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long load(Class<?> clazz) {
        assert (clazz != null);
        JfrTraceId.setUsedThisEpoch(clazz);
        return JfrTraceId.getTraceId(clazz);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void tag(Class<?> clazz, long bits) {
        JfrTraceIdMap map = JfrTraceIdMap.singleton();
        long id = map.getId(clazz);
        map.setId(clazz, id | bits & 0xFFL);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void clear(Class<?> clazz, long bits) {
        JfrTraceIdMap map = JfrTraceIdMap.singleton();
        long id = map.getId(clazz);
        map.setId(clazz, id & (bits ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean predicate(Class<?> clazz, long bits) {
        JfrTraceIdMap map = JfrTraceIdMap.singleton();
        long id = map.getId(clazz);
        return (id & bits) != 0L;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void tag(int index, long value) {
        JfrTraceIdMap map = JfrTraceIdMap.singleton();
        long id = map.getId(index);
        map.setId(index, id | value);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void assign(Class<?> clazz, int index) {
        assert (clazz != null);
        if (JfrTraceIdMap.singleton().getId(index) != -1L) {
            return;
        }
        long typeId = JfrTraceId.getTypeId(clazz);
        JfrTraceIdMap.singleton().setId(index, typeId << 16);
        if ((jdk.internal.event.Event.class == clazz || Event.class == clazz) && clazz.getClassLoader() == null || clazz.getClassLoader() == ClassLoader.getSystemClassLoader()) {
            JfrTraceId.tag(index, 32L);
        }
        if ((jdk.internal.event.Event.class.isAssignableFrom(clazz) || Event.class.isAssignableFrom(clazz)) && clazz.getClassLoader() == null || clazz.getClassLoader() == ClassLoader.getSystemClassLoader()) {
            JfrTraceId.tag(index, 16L);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static long getTypeId(Class<?> clazz) {
        if (clazz == Void.TYPE) {
            return 0L;
        }
        return Type.getTypeId(clazz);
    }
}

