/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.darwin.DarwinPthread;
import com.oracle.svm.core.posix.headers.darwin.DarwinThreadInfo;
import com.oracle.svm.core.thread.ThreadCpuTimeSupport;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CIntPointer;

@AutomaticallyRegisteredImageSingleton(value={ThreadCpuTimeSupport.class})
final class DarwinThreadCpuTimeSupport
implements ThreadCpuTimeSupport {
    DarwinThreadCpuTimeSupport() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getCurrentThreadCpuTime(boolean includeSystemTime) {
        Pthread.pthread_t pthread = Pthread.pthread_self();
        return this.getThreadCpuTime(pthread, includeSystemTime);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getThreadCpuTime(VMThreads.OSThreadHandle osThreadHandle, boolean includeSystemTime) {
        int threadsMachPort = DarwinPthread.pthread_mach_thread_np((Pthread.pthread_t)osThreadHandle);
        CIntPointer sizePointer = (CIntPointer)StackValue.get((int)4);
        sizePointer.write(DarwinThreadInfo.THREAD_INFO_MAX());
        DarwinThreadInfo.thread_basic_info_data_t basicThreadInfo = (DarwinThreadInfo.thread_basic_info_data_t)StackValue.get(DarwinThreadInfo.thread_basic_info_data_t.class);
        if (DarwinThreadInfo.thread_info(threadsMachPort, DarwinThreadInfo.THREAD_BASIC_INFO(), basicThreadInfo, sizePointer) != 0) {
            return -1L;
        }
        long seconds = basicThreadInfo.user_time().seconds();
        long micros = basicThreadInfo.user_time().microseconds();
        if (includeSystemTime) {
            seconds += (long)basicThreadInfo.system_time().seconds();
            micros += (long)basicThreadInfo.system_time().microseconds();
        }
        return seconds * 1000000000L + micros * 1000L;
    }
}

