/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationMetadata;
import java.lang.constant.Constable;
import java.nio.ByteBuffer;
import java.util.Objects;
import jdk.internal.reflect.ConstantPool;
import sun.invoke.util.Wrapper;

public final class AnnotationPrimitiveValue
extends AnnotationMemberValue {
    private final char tag;
    private final Object value;

    static AnnotationPrimitiveValue extract(ByteBuffer buf, ConstantPool cp, char tag, boolean skip) {
        Constable value;
        int constIndex = buf.getShort() & 0xFFFF;
        if (skip) {
            return null;
        }
        switch (tag) {
            case 'B': {
                value = Byte.valueOf((byte)cp.getIntAt(constIndex));
                break;
            }
            case 'C': {
                value = Character.valueOf((char)cp.getIntAt(constIndex));
                break;
            }
            case 'D': {
                value = Double.valueOf(cp.getDoubleAt(constIndex));
                break;
            }
            case 'F': {
                value = Float.valueOf(cp.getFloatAt(constIndex));
                break;
            }
            case 'I': {
                value = Integer.valueOf(cp.getIntAt(constIndex));
                break;
            }
            case 'J': {
                value = Long.valueOf(cp.getLongAt(constIndex));
                break;
            }
            case 'S': {
                value = Short.valueOf((short)cp.getIntAt(constIndex));
                break;
            }
            case 'Z': {
                value = Boolean.valueOf(cp.getIntAt(constIndex) != 0);
                break;
            }
            default: {
                throw new AnnotationMetadata.AnnotationExtractionError("Invalid annotation encoding. Unknown tag " + tag);
            }
        }
        assert (Wrapper.forWrapperType(value.getClass()).basicTypeChar() == tag);
        return new AnnotationPrimitiveValue(tag, (Object)value);
    }

    AnnotationPrimitiveValue(Class<?> type, Object value) {
        this((type.isPrimitive() ? Wrapper.forPrimitiveType(type) : Wrapper.forWrapperType(type)).basicTypeChar(), value);
    }

    private AnnotationPrimitiveValue(char tag, Object value) {
        this.tag = tag;
        this.value = value;
    }

    @Override
    public char getTag() {
        return this.tag;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Object get(Class<?> memberType) {
        return AnnotationMetadata.checkResult(this.value, memberType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationPrimitiveValue that = (AnnotationPrimitiveValue)o;
        return this.tag == that.tag && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(Character.valueOf(this.tag), this.value);
    }
}

