/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.results.StaticAnalysisResults;
import com.oracle.svm.core.graal.nodes.DeoptEntryBeginNode;
import com.oracle.svm.core.graal.nodes.DeoptEntryNode;
import com.oracle.svm.core.graal.nodes.DeoptEntrySupport;
import com.oracle.svm.core.graal.nodes.DeoptProxyAnchorNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.nodes.DeoptProxyNode;
import com.oracle.svm.hosted.phases.HostedBciBlockMapping;
import com.oracle.svm.hosted.phases.SubstrateGraphBuilderPhase;
import java.util.List;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.BytecodeStream;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.BciBlockMapping;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnreachableBeginNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.options.OptionValues;

class HostedBytecodeParser
extends SubstrateGraphBuilderPhase.SubstrateBytecodeParser {
    private int currentDeoptIndex;

    HostedBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
        super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext, true);
    }

    public HostedMethod getMethod() {
        return (HostedMethod)super.getMethod();
    }

    protected boolean forceLoopPhis() {
        return this.getMethod().compilationInfo.isDeoptTarget() || super.forceLoopPhis();
    }

    protected boolean stampFromValueForForcedPhis() {
        return true;
    }

    public boolean allowDeoptInPlugins() {
        return false;
    }

    @Override
    protected boolean asyncExceptionLiveness() {
        return HostedBytecodeParser.isDeoptimizationEnabled() && this.getMethod().canDeoptimize();
    }

    protected BciBlockMapping generateBlockMap() {
        int maxDuplicationBoost = 2;
        if (HostedBytecodeParser.isDeoptimizationEnabled() && this.isMethodDeoptTarget()) {
            return HostedBciBlockMapping.create(this.stream, this.code, this.options, this.graph.getDebug(), false, maxDuplicationBoost);
        }
        return BciBlockMapping.create((BytecodeStream)this.stream, (Bytecode)this.code, (OptionValues)this.options, (DebugContext)this.graph.getDebug(), (boolean)this.asyncExceptionLiveness(), (int)maxDuplicationBoost);
    }

    protected void build(FixedWithNextNode startInstruction, FrameStateBuilder startFrameState) {
        super.build(startInstruction, startFrameState);
        this.getGraph().getGraphState().setGuardsStage(GraphState.GuardsStage.FIXED_DEOPTS);
        assert (!this.getMethod().isEntryPoint()) : "Cannot directly use as entry point, create a call stub ";
        if (this.getMethod().compilationInfo.isDeoptTarget()) {
            for (DeoptProxyNode deoptProxy : this.graph.getNodes(DeoptProxyNode.TYPE)) {
                assert (deoptProxy.hasProxyPoint());
            }
        }
    }

    @Override
    public MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, StampPair returnStamp, JavaTypeProfile profile) {
        StaticAnalysisResults staticAnalysisResults = this.getMethod().getProfilingInfo();
        return new SubstrateMethodCallTargetNode(invokeKind, targetMethod, args, returnStamp, staticAnalysisResults.getTypeProfile(this.bci()), staticAnalysisResults.getMethodProfile(this.bci()), staticAnalysisResults.getStaticTypeProfile(this.bci()));
    }

    protected void createExceptionDispatch(BciBlockMapping.ExceptionDispatchBlock block) {
        if (block instanceof HostedBciBlockMapping.DeoptEntryInsertionPoint) {
            assert (block instanceof HostedBciBlockMapping.DeoptExceptionDispatchBlock);
            this.insertDeoptNode((HostedBciBlockMapping.DeoptEntryInsertionPoint)block);
            List successors = block.getSuccessors();
            assert (successors.size() <= 1);
            BciBlockMapping.ExceptionDispatchBlock successor = successors.isEmpty() ? this.blockMap.getUnwindBlock() : (BciBlockMapping.BciBlock)successors.get(0);
            this.appendGoto((BciBlockMapping.BciBlock)successor);
        } else {
            super.createExceptionDispatch(block);
        }
    }

    protected void iterateBytecodesForBlock(BciBlockMapping.BciBlock block) {
        if (block instanceof HostedBciBlockMapping.DeoptEntryInsertionPoint) {
            assert (block instanceof HostedBciBlockMapping.DeoptBciBlock);
            assert (block.getSuccessors().size() == 1 || block.getSuccessors().size() == 2);
            assert (block.getSuccessor(0).isInstructionBlock());
            this.stream.setBCI(block.getStartBci());
            this.insertDeoptNode((HostedBciBlockMapping.DeoptEntryInsertionPoint)block);
            this.appendGoto(block.getSuccessor(0));
        } else {
            super.iterateBytecodesForBlock(block);
        }
    }

    private void insertDeoptNode(HostedBciBlockMapping.DeoptEntryInsertionPoint deopt) {
        if (deopt instanceof HostedBciBlockMapping.DeoptBciBlock) {
            assert (!this.frameState.rethrowException());
        } else {
            assert (deopt instanceof HostedBciBlockMapping.DeoptExceptionDispatchBlock);
            assert (this.frameState.rethrowException());
        }
        DeoptEntrySupport deoptNode = (DeoptEntrySupport)this.graph.add((Node)(deopt.isProxy() ? new DeoptProxyAnchorNode() : new DeoptEntryNode()));
        FrameState stateAfter = this.frameState.create(deopt.frameStateBci(), (StateSplit)deoptNode);
        deoptNode.setStateAfter(stateAfter);
        if (this.lastInstr != null) {
            this.lastInstr.setNext(deoptNode.asFixedNode());
        }
        if (deopt.isProxy()) {
            this.lastInstr = (DeoptProxyAnchorNode)deoptNode;
        } else {
            assert (!deopt.duringCall()) : "Implicit deopt entries from invokes cannot have explicit deopt entries.";
            DeoptEntryNode deoptEntryNode = (DeoptEntryNode)deoptNode;
            deoptEntryNode.setNext((AbstractBeginNode)this.graph.add((Node)new DeoptEntryBeginNode()));
            if (!deopt.rethrowException()) {
                FrameStateBuilder originalFrameState = this.frameState.copy();
                ExceptionObjectNode newExceptionObject = (ExceptionObjectNode)this.graph.add((Node)new ExceptionObjectNode(this.getMetaAccess()));
                this.frameState.clearStack();
                this.frameState.push(JavaKind.Object, (ValueNode)newExceptionObject);
                this.frameState.setRethrowException(true);
                int bci = ((HostedBciBlockMapping.DeoptBciBlock)deopt).getStartBci();
                newExceptionObject.setStateAfter(this.frameState.create(bci, (StateSplit)newExceptionObject));
                deoptEntryNode.setExceptionEdge((AbstractBeginNode)newExceptionObject);
                this.insertProxies((FixedNode)newExceptionObject, this.frameState);
                newExceptionObject.setNext((FixedNode)this.handleException((ValueNode)newExceptionObject, bci, false));
                this.frameState = originalFrameState;
            } else {
                AbstractBeginNode newExceptionEdge = (AbstractBeginNode)this.graph.add((Node)new UnreachableBeginNode());
                newExceptionEdge.setNext((FixedNode)this.graph.add((Node)new LoweredDeadEndNode()));
                deoptEntryNode.setExceptionEdge(newExceptionEdge);
            }
            this.lastInstr = deoptEntryNode.next();
        }
        this.insertProxies(deoptNode.asFixedNode(), this.frameState);
    }

    private void insertProxies(FixedNode deoptTarget, FrameStateBuilder state) {
        state.insertProxies(value -> this.createProxyNode((ValueNode)value, deoptTarget));
        ++this.currentDeoptIndex;
    }

    private ValueNode createProxyNode(ValueNode value, FixedNode deoptTarget) {
        ValueNode v = DeoptProxyNode.create(value, (ValueNode)deoptTarget, this.currentDeoptIndex);
        if (v.graph() != null) {
            return v;
        }
        return (ValueNode)this.graph.addOrUniqueWithInputs((Node)v);
    }
}

