/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reachability;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import com.oracle.graal.reachability.ReachabilityAnalysisMethod;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jdk.vm.ci.code.BytecodePosition;

public class ReachabilityInvokeInfo
implements InvokeInfo {
    private final ReachabilityAnalysisMethod targetMethod;
    private final BytecodePosition position;
    private final boolean isDirectInvoke;

    public ReachabilityInvokeInfo(ReachabilityAnalysisMethod targetMethod, BytecodePosition position, boolean isDirectInvoke) {
        this.targetMethod = targetMethod;
        this.position = position;
        this.isDirectInvoke = isDirectInvoke;
    }

    public boolean canBeStaticallyBound() {
        return this.getCallees().size() <= 1;
    }

    public AnalysisMethod getTargetMethod() {
        return this.targetMethod;
    }

    public Collection<AnalysisMethod> getCallees() {
        if (this.isDirectInvoke) {
            return List.of(this.targetMethod);
        }
        return Arrays.asList(this.targetMethod.getImplementations());
    }

    public BytecodePosition getPosition() {
        return this.position;
    }

    public boolean isDirectInvoke() {
        return this.isDirectInvoke;
    }
}

