/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK17OrLater;
import com.oracle.svm.core.jdk.JDK19OrLater;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.jdk.localization.substitutions.Target_java_nio_charset_Charset;
import com.oracle.svm.util.ReflectionUtil;
import java.nio.charset.Charset;
import java.util.function.BooleanSupplier;
import jdk.internal.util.StaticProperty;
import org.graalvm.nativeimage.ImageSingletons;

@Substitute
@TargetClass(value=StaticProperty.class)
final class Target_jdk_internal_util_StaticProperty {
    Target_jdk_internal_util_StaticProperty() {
    }

    @Substitute
    private static String javaHome() {
        return null;
    }

    @Substitute
    private static String userHome() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).userHome();
    }

    @Substitute
    private static String userDir() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).userDir();
    }

    @Substitute
    private static String userName() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).userName();
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    private static String javaIoTmpDir() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).javaIoTmpDir();
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    private static String javaLibraryPath() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).javaLibraryPath();
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    private static String sunBootLibraryPath() {
        String value = ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).savedProperties.get("sun.boot.library.path");
        return value == null ? "" : value;
    }

    @Substitute
    private static String jdkSerialFilter() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).savedProperties.get("jdk.serialFilter");
    }

    @Substitute
    @TargetElement(onlyWith={StaticPropertyJdkSerialFilterFactoryAvailable.class})
    private static String jdkSerialFilterFactory() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).savedProperties.get("jdk.serialFilterFactory");
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public static String nativeEncoding() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).savedProperties.get("native.encoding");
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public static String fileEncoding() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).savedProperties.get("file.encoding");
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public static String javaPropertiesDate() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).savedProperties.getOrDefault("java.properties.date", null);
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public static String jnuEncoding() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).savedProperties.get("sun.jnu.encoding");
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public static Charset jnuCharset() {
        String jnuEncoding = ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).savedProperties.get("sun.jnu.encoding");
        return Target_java_nio_charset_Charset.forName(jnuEncoding, Charset.defaultCharset());
    }

    private static class StaticPropertyJdkSerialFilterFactoryAvailable
    extends StaticPropertyMethodAvailable {
        protected StaticPropertyJdkSerialFilterFactoryAvailable() {
            super("jdkSerialFilterFactory");
        }
    }

    private static abstract class StaticPropertyMethodAvailable
    implements BooleanSupplier {
        private final String methodName;

        protected StaticPropertyMethodAvailable(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public boolean getAsBoolean() {
            return ReflectionUtil.lookupMethod((boolean)true, StaticProperty.class, (String)this.methodName, (Class[])new Class[0]) != null;
        }
    }
}

