/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.common.option.LocatableOption;
import com.oracle.svm.common.option.MultiOptionValue;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.ValidatableOptionKey;
import java.util.function.Consumer;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.OptionKey;

public class HostedOptionKey<T>
extends OptionKey<T>
implements ValidatableOptionKey {
    private final Consumer<HostedOptionKey<T>> validation;

    public HostedOptionKey(T defaultValue) {
        this(defaultValue, null);
    }

    public HostedOptionKey(T defaultValue, Consumer<HostedOptionKey<T>> validation) {
        super(defaultValue);
        this.validation = validation;
    }

    @Fold
    public T getValue() {
        return (T)this.getValue(HostedOptionValues.singleton());
    }

    @Override
    @Fold
    public boolean hasBeenSet() {
        return this.hasBeenSet(HostedOptionValues.singleton());
    }

    protected boolean checkDescriptorExists() {
        return true;
    }

    public void update(EconomicMap<OptionKey<?>, Object> values, Object boxedValue) {
        Object defaultValue = this.getDefaultValue();
        if (defaultValue instanceof MultiOptionValue) {
            MultiOptionValue value = (MultiOptionValue)values.get((Object)this);
            if (value == null) {
                value = ((MultiOptionValue)defaultValue).createCopy();
            }
            value.valueUpdate(boxedValue);
            super.update(values, (Object)value);
        } else {
            super.update(values, LocatableOption.rawValue((Object)boxedValue));
        }
    }

    @Override
    public void validate() {
        if (this.validation != null) {
            this.validation.accept(this);
        }
    }
}

