/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.sampler.SubstrateSigprofHandler;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={SubstrateSigprofHandler.class})
public class PosixSubstrateSigprofHandler
extends SubstrateSigprofHandler {
    public static final long INTERVAL_S = 0L;
    public static final long INTERVAL_uS = 20000L;
    private static final CEntryPointLiteral<Signal.AdvancedSignalDispatcher> advancedSignalDispatcher = CEntryPointLiteral.create(PosixSubstrateSigprofHandler.class, (String)"dispatch", (Class[])new Class[]{Integer.TYPE, Signal.siginfo_t.class, Signal.ucontext_t.class});

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PosixSubstrateSigprofHandler() {
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in sigprof signal handler.")
    @Uninterruptible(reason="Signal handler may only execute uninterruptible code.")
    private static void dispatch(int signalNumber, Signal.siginfo_t sigInfo, Signal.ucontext_t uContext) {
        if (PosixSubstrateSigprofHandler.tryEnterIsolate()) {
            PosixSubstrateSigprofHandler.doUninterruptibleStackWalk(uContext);
        }
    }

    private static void registerSigprofSignal() {
        VMError.guarantee(SubstrateOptions.EnableSignalHandling.getValue(), "Trying to install a signal handler while signal handling is disabled.");
        int structSigActionSize = SizeOf.get(Signal.sigaction.class);
        Signal.sigaction structSigAction = (Signal.sigaction)StackValue.get((int)structSigActionSize);
        LibC.memset(structSigAction, WordFactory.signed((int)0), WordFactory.unsigned((int)structSigActionSize));
        structSigAction.sa_flags(Signal.SA_SIGINFO() | Signal.SA_NODEFER());
        structSigAction.sa_sigaction((Signal.AdvancedSignalDispatcher)advancedSignalDispatcher.getFunctionPointer());
        Signal.sigaction(Signal.SignalEnum.SIGPROF.getCValue(), structSigAction, (Signal.sigaction)WordFactory.nullPointer());
    }

    private static int callSetitimer() {
        Time.itimerval newValue = (Time.itimerval)StackValue.get(Time.itimerval.class);
        Time.itimerval oldValue = (Time.itimerval)StackValue.get(Time.itimerval.class);
        newValue.it_value().set_tv_sec(0L);
        newValue.it_value().set_tv_usec(20000L);
        newValue.it_interval().set_tv_sec(0L);
        newValue.it_interval().set_tv_usec(20000L);
        return Time.NoTransitions.setitimer(Time.TimerTypeEnum.ITIMER_PROF, newValue, oldValue);
    }

    @Override
    protected void install0() {
        PosixSubstrateSigprofHandler.registerSigprofSignal();
        PosixUtils.checkStatusIs0(PosixSubstrateSigprofHandler.callSetitimer(), "setitimer(which, newValue, oldValue): wrong arguments.");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected UnsignedWord createThreadLocalKey() {
        Pthread.pthread_key_tPointer key = (Pthread.pthread_key_tPointer)StackValue.get(Pthread.pthread_key_tPointer.class);
        PosixUtils.checkStatusIs0(Pthread.pthread_key_create(key, WordFactory.nullPointer()), "pthread_key_create(key, keyDestructor): failed.");
        return key.read();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void deleteThreadLocalKey(UnsignedWord key) {
        int resultCode = Pthread.pthread_key_delete((Pthread.pthread_key_t)key);
        PosixUtils.checkStatusIs0(resultCode, "pthread_key_delete(key): failed.");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void setThreadLocalKeyValue(UnsignedWord key, IsolateThread value) {
        int resultCode = Pthread.pthread_setspecific((Pthread.pthread_key_t)key, (VoidPointer)value);
        PosixUtils.checkStatusIs0(resultCode, "pthread_setspecific(key, value): wrong arguments.");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected IsolateThread getThreadLocalKeyValue(UnsignedWord key) {
        return (IsolateThread)Pthread.pthread_getspecific((Pthread.pthread_key_t)key);
    }
}

