/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.windows.headers.MemoryAPI;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={StackOverflowCheck.OSSupport.class})
@Platforms(value={Platform.WINDOWS.class})
class WindowsStackOverflowSupport
implements StackOverflowCheck.OSSupport {
    WindowsStackOverflowSupport() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void getStackInformation(WordPointer stackEndPtr, WordPointer stackSizePtr) {
        int sizeOfMInfo = SizeOf.get(MemoryAPI.MEMORY_BASIC_INFORMATION.class);
        MemoryAPI.MEMORY_BASIC_INFORMATION minfo = (MemoryAPI.MEMORY_BASIC_INFORMATION)StackValue.get((int)sizeOfMInfo);
        MemoryAPI.VirtualQuery(minfo, minfo, WordFactory.unsigned((int)sizeOfMInfo));
        Pointer stackBottom = (Pointer)minfo.AllocationBase();
        stackEndPtr.write((WordBase)stackBottom);
        UnsignedWord stackSize = minfo.RegionSize();
        while (true) {
            MemoryAPI.VirtualQuery((PointerBase)stackBottom.add(stackSize), minfo, WordFactory.unsigned((int)sizeOfMInfo));
            if (!stackBottom.equal((ComparableWord)minfo.AllocationBase())) break;
            stackSize = stackSize.add(minfo.RegionSize());
        }
        stackSizePtr.write((WordBase)stackSize);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord lookupStackBase() {
        WordPointer stackEndPtr = (WordPointer)StackValue.get(WordPointer.class);
        WordPointer stackSizePtr = (WordPointer)StackValue.get(WordPointer.class);
        WindowsStackOverflowSupport.getStackInformation(stackEndPtr, stackSizePtr);
        UnsignedWord stackEnd = (UnsignedWord)stackEndPtr.read();
        UnsignedWord stackSize = (UnsignedWord)stackSizePtr.read();
        return stackEnd.add(stackSize);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord lookupStackEnd() {
        return this.lookupStackEnd((UnsignedWord)WordFactory.zero());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord lookupStackEnd(UnsignedWord requestedStackSize) {
        UnsignedWord stackSize;
        WordPointer stackEndPtr = (WordPointer)StackValue.get(WordPointer.class);
        WordPointer stackSizePtr = (WordPointer)StackValue.get(WordPointer.class);
        WindowsStackOverflowSupport.getStackInformation(stackEndPtr, stackSizePtr);
        UnsignedWord stackEnd = (UnsignedWord)stackEndPtr.read();
        if (requestedStackSize.notEqual((UnsignedWord)WordFactory.zero()) && (stackSize = (UnsignedWord)stackSizePtr.read()).aboveThan(requestedStackSize)) {
            UnsignedWord stackAdjustment = stackSize.subtract(requestedStackSize);
            return stackEnd.add(stackAdjustment);
        }
        return stackEnd;
    }
}

