/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import java.util.ArrayList;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeJNIAccess;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
@AutomaticallyRegisteredFeature
public class JNIRegistrationPrefs
extends JNIRegistrationUtil
implements InternalFeature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        String preferencesImplementation = JNIRegistrationPrefs.getPlatformPreferencesClassName();
        JNIRegistrationPrefs.rerunClassInit((Feature.FeatureAccess)access, preferencesImplementation);
        ArrayList triggers = new ArrayList();
        triggers.add(JNIRegistrationPrefs.clazz((Feature.FeatureAccess)access, preferencesImplementation));
        if (JNIRegistrationPrefs.isDarwin()) {
            String darwinSpecificClass = "java.util.prefs.MacOSXPreferencesFile";
            JNIRegistrationPrefs.rerunClassInit((Feature.FeatureAccess)access, darwinSpecificClass);
            triggers.add(JNIRegistrationPrefs.clazz((Feature.FeatureAccess)access, darwinSpecificClass));
        }
        access.registerReachabilityHandler(JNIRegistrationPrefs::handlePreferencesClassReachable, triggers.toArray());
    }

    private static String getPlatformPreferencesClassName() {
        if (JNIRegistrationPrefs.isLinux()) {
            return "java.util.prefs.FileSystemPreferences";
        }
        if (JNIRegistrationPrefs.isWindows()) {
            return "java.util.prefs.WindowsPreferences";
        }
        if (JNIRegistrationPrefs.isDarwin()) {
            return "java.util.prefs.MacOSXPreferences";
        }
        throw VMError.shouldNotReachHere("Unexpected platform");
    }

    private static void handlePreferencesClassReachable(Feature.DuringAnalysisAccess access) {
        NativeLibraries nativeLibraries = ((FeatureImpl.DuringAnalysisAccessImpl)access).getNativeLibraries();
        NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("prefs");
        nativeLibraries.addStaticJniLibrary("prefs", new String[0]);
        if (JNIRegistrationPrefs.isDarwin()) {
            RuntimeJNIAccess.register((Class[])new Class[]{String[].class});
        }
    }
}

