/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.graal.lir.DeoptEntryOp;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.StackLockValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.JavaValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;

class Instance {
    private Map<Integer, Object> allowedStackSlots;

    Instance() {
    }

    public void run(LIRGenerationResult lirGenRes) {
        LIR ir = lirGenRes.getLIR();
        DebugContext debug = ir.getDebug();
        FrameMap frameMap = lirGenRes.getFrameMap();
        for (AbstractBlockBase block : ir.linearScanOrder()) {
            if (block == null) continue;
            for (LIRInstruction op : ir.getLIRforBlock(block)) {
                op.forEachState((instruction, state) -> this.doState(debug, frameMap, instruction, state));
            }
        }
    }

    private static boolean isImplicitDeoptEntry(LIRFrameState state) {
        BytecodeFrame frame = state.topFrame;
        if (frame.duringCall) {
            return state.validForDeoptimization && ((HostedMethod)frame.getMethod()).compilationInfo.isDeoptEntry(frame.getBCI(), frame.duringCall, frame.rethrowException);
        }
        return false;
    }

    private void doState(DebugContext debug, FrameMap frameMap, LIRInstruction op, LIRFrameState state) {
        SubstrateReferenceMap refMap = (SubstrateReferenceMap)state.debugInfo().getReferenceMap();
        if (op instanceof DeoptEntryOp || Instance.isImplicitDeoptEntry(state)) {
            BytecodeFrame frame = state.topFrame;
            Map<Integer, Object> allUsedRegisters = refMap.getDebugAllUsedRegisters();
            Map<Integer, Object> allUsedStackSlots = refMap.getDebugAllUsedStackSlots();
            if (allUsedRegisters != null && !allUsedRegisters.isEmpty()) {
                throw VMError.shouldNotReachHere("Deoptimization target must not use any registers");
            }
            if (allUsedStackSlots != null) {
                int firstBci;
                HashMap<Integer, Object> cleanedStackSlots = new HashMap<Integer, Object>(allUsedStackSlots);
                do {
                    for (JavaValue v : frame.values) {
                        JavaValue value = v;
                        if (value instanceof StackLockValue) {
                            StackLockValue lock = (StackLockValue)value;
                            assert (ValueUtil.isIllegal((Value)lock.getSlot()));
                            value = lock.getOwner();
                        }
                        if (value instanceof StackSlot) {
                            StackSlot stackSlot = (StackSlot)value;
                            int offset = stackSlot.getOffset(frameMap.totalFrameSize());
                            debug.log("remove slot %d: %s", offset, (Object)stackSlot);
                            cleanedStackSlots.remove(offset);
                            continue;
                        }
                        if (ValueUtil.isConstantJavaValue((JavaValue)value) || ValueUtil.isIllegalJavaValue((JavaValue)value) || ReservedRegisters.singleton().isAllowedInFrameState(value)) continue;
                        throw VMError.shouldNotReachHere("unknown value in deopt target: " + value);
                    }
                } while ((frame = frame.caller()) != null);
                int n = firstBci = state.topFrame.getMethod().isSynchronized() ? -2 : 0;
                if (state.topFrame.getBCI() == firstBci && state.topFrame.caller() == null && !state.topFrame.duringCall && !state.topFrame.rethrowException) {
                    assert (op instanceof DeoptEntryOp);
                    assert (this.allowedStackSlots == null);
                    this.allowedStackSlots = new HashMap<Integer, Object>(cleanedStackSlots);
                } else {
                    if (this.allowedStackSlots == null) {
                        this.allowedStackSlots = new HashMap<Integer, Object>();
                    }
                    for (Integer key : this.allowedStackSlots.keySet()) {
                        cleanedStackSlots.remove(key);
                    }
                    if (!cleanedStackSlots.isEmpty()) {
                        throw VMError.shouldNotReachHere("unknown values in stack slots: method " + state.topFrame.getMethod().toString() + ", op " + op.id() + " " + op + ": " + cleanedStackSlots);
                    }
                }
            }
        }
    }
}

