/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.hosted.code.NonBytecodeStaticMethod;
import com.oracle.svm.hosted.reflect.ReflectionGraphKit;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;

public class ReflectionExpandSignatureMethod
extends NonBytecodeStaticMethod {
    private final boolean isStatic;
    private final Class<?>[] argTypes;
    private final JavaKind returnKind;

    public ReflectionExpandSignatureMethod(String name, ResolvedJavaMethod prototype, boolean isStatic, Class<?>[] argTypes, JavaKind returnKind) {
        super(name, prototype.getDeclaringClass(), prototype.getSignature(), prototype.getConstantPool());
        this.isStatic = isStatic;
        this.argTypes = argTypes;
        this.returnKind = returnKind;
    }

    public StructuredGraph buildGraph(DebugContext ctx, ResolvedJavaMethod m, HostedProviders providers, GraphProvider.Purpose purpose) {
        InvokeWithExceptionNode returnValue;
        ReflectionGraphKit graphKit = new ReflectionGraphKit(ctx, providers, m);
        ValueNode receiver = graphKit.loadLocal(0, JavaKind.Object);
        ValueNode argumentArray = graphKit.loadLocal(1, JavaKind.Object);
        ValueNode invokedMethod = graphKit.loadLocal(2, JavaKind.Object);
        graphKit.getFrameState().clearLocals();
        int receiverOffset = this.isStatic ? 0 : 1;
        ValueNode[] args = new ValueNode[this.argTypes.length + receiverOffset];
        ResolvedJavaType[] signature = new ResolvedJavaType[this.argTypes.length + receiverOffset];
        if (!this.isStatic) {
            signature[0] = providers.getMetaAccess().lookupJavaType(Object.class);
            args[0] = receiver;
        }
        graphKit.fillArgsArray(argumentArray, receiverOffset, args, this.argTypes);
        for (int i = 0; i < this.argTypes.length; ++i) {
            signature[i + receiverOffset] = providers.getMetaAccess().lookupJavaType(this.argTypes[i]);
        }
        CallTargetNode callTarget = (CallTargetNode)graphKit.append((ValueNode)new IndirectCallTargetNode(invokedMethod, args, StampPair.createSingle((Stamp)StampFactory.forKind((JavaKind)this.returnKind)), (JavaType[])signature, null, (CallingConvention.Type)SubstrateCallingConventionKind.Java.toType(true), CallTargetNode.InvokeKind.Static));
        InvokeWithExceptionNode invoke = graphKit.startInvokeWithException(callTarget, graphKit.getFrameState(), graphKit.bci());
        graphKit.exceptionPart();
        graphKit.branchToInvocationTargetException(graphKit.exceptionObject());
        graphKit.endInvokeWithException();
        if (this.returnKind == JavaKind.Void) {
            returnValue = graphKit.createObject(null);
        } else {
            returnValue = invoke;
            if (this.returnKind.isPrimitive()) {
                ResolvedJavaType boxedRetType = graphKit.getMetaAccess().lookupJavaType(this.returnKind.toBoxedJavaClass());
                returnValue = graphKit.createBoxing((ValueNode)returnValue, this.returnKind, boxedRetType);
            }
        }
        graphKit.createReturn((ValueNode)returnValue, JavaKind.Object);
        graphKit.emitIllegalArgumentException(this.isStatic ? null : receiver, argumentArray);
        graphKit.emitInvocationTargetException();
        return graphKit.finalizeGraph();
    }
}

