/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.PointerBase;

public abstract class PlatformNativeLibrarySupport {
    public static final String[] defaultBuiltInLibraries = new String[]{"java", "nio", "net", "zip"};
    private static final String[] defaultBuiltInPkgNatives = new String[]{"com_sun_demo_jvmti_hprof", "com_sun_java_util_jar_pack", "com_sun_net_ssl", "com_sun_nio_file", "com_sun_security_cert_internal_x509", "java_io", "java_lang", "java_math", "java_net", "java_nio", "java_security", "java_text", "java_time", "java_util", "javax_net", "javax_script", "javax_security", "jdk_internal_org", "jdk_internal_misc", "jdk_internal_util", "jdk_internal_jimage", "jdk_internal_vm", "jdk_net", "sun_invoke", "sun_launcher", "sun_misc", "sun_net", "sun_nio", "sun_reflect", "sun_text", "sun_util", "com_oracle_svm_core_jdk"};
    private static final String[] defaultBuiltInPkgNativesBlacklist = new String[]{"sun_security_krb5_SCDynamicStoreConfig_getKerberosConfig", "sun_security_krb5_Config_getWindowsDirectory", "jdk_internal_org_jline_terminal_impl_jna_win_Kernel32Impl"};
    private List<String> builtInPkgNatives = new ArrayList<String>();
    private boolean builtInPkgNativesSealed;

    public static PlatformNativeLibrarySupport singleton() {
        return (PlatformNativeLibrarySupport)ImageSingletons.lookup(PlatformNativeLibrarySupport.class);
    }

    protected PlatformNativeLibrarySupport() {
        if (Platform.includedIn(InternalPlatform.PLATFORM_JNI.class)) {
            this.builtInPkgNatives.addAll(Arrays.asList(defaultBuiltInPkgNatives));
        }
    }

    public boolean isBuiltinLibrary(String name) {
        return false;
    }

    public void addBuiltinPkgNativePrefix(String name) {
        if (this.builtInPkgNativesSealed) {
            throw VMError.shouldNotReachHere("Cannot register any more packages as built-ins because information has already been used.");
        }
        this.builtInPkgNatives.add(name);
    }

    public boolean isBuiltinPkgNative(String name) {
        this.builtInPkgNativesSealed = true;
        String commonPrefix = "Java_";
        if (name.startsWith(commonPrefix)) {
            String strippedName = name.substring(commonPrefix.length());
            for (String str : defaultBuiltInPkgNativesBlacklist) {
                if (!strippedName.startsWith(str)) continue;
                return false;
            }
            for (String str : this.builtInPkgNatives) {
                if (!strippedName.startsWith(str)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract NativeLibrary createLibrary(String var1, boolean var2);

    public abstract PointerBase findBuiltinSymbol(String var1);

    public abstract boolean initializeBuiltinLibraries();

    public static interface NativeLibrary {
        public String getCanonicalIdentifier();

        public boolean isBuiltin();

        public boolean load();

        public boolean isLoaded();

        public PointerBase findSymbol(String var1);
    }
}

