/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import java.util.ArrayList;
import java.util.List;
import jdk.jfr.Event;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrJavaEvents {
    private static final List<Class<? extends jdk.internal.event.Event>> EVENT_CLASSES = new ArrayList<Class<? extends jdk.internal.event.Event>>();
    private static final List<Class<? extends Event>> JFR_EVENT_CLASSES = new ArrayList<Class<? extends Event>>();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static synchronized void registerEventClass(Class<? extends jdk.internal.event.Event> eventClass) {
        EVENT_CLASSES.add(eventClass);
        if (Event.class.isAssignableFrom(eventClass)) {
            JFR_EVENT_CLASSES.add(eventClass);
        }
    }

    public static List<Class<? extends jdk.internal.event.Event>> getAllEventClasses() {
        return EVENT_CLASSES;
    }

    public static List<Class<? extends Event>> getJfrEventClasses() {
        return JFR_EVENT_CLASSES;
    }
}

