/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.thread.Continuation;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.thread.LoomVirtualThreads;
import com.oracle.svm.core.thread.SubstrateVirtualThreads;
import com.oracle.svm.core.thread.VirtualThreads;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;

@AutomaticallyRegisteredFeature
public class ContinuationsFeature
implements InternalFeature {
    private boolean finishedRegistration = false;

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        int firstLoomPreviewVersion = 19;
        int lastLoomPreviewVersion = 20;
        boolean supportLoom = false;
        if (JavaVersionUtil.JAVA_SPEC >= 19) {
            boolean haveLoom;
            if (JavaVersionUtil.JAVA_SPEC > 20) {
                haveLoom = true;
            } else {
                try {
                    haveLoom = (Boolean)Class.forName("jdk.internal.misc.PreviewFeatures").getDeclaredMethod("isEnabled", new Class[0]).invoke(null, new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw VMError.shouldNotReachHere(e);
                }
                if (!haveLoom) {
                    RuntimeClassInitialization.initializeAtRunTime((String[])new String[]{"jdk.internal.vm.Continuation"});
                }
            }
            boolean bl = supportLoom = haveLoom && !DeoptimizationSupport.enabled() && !SubstrateOptions.useLLVMBackend();
        }
        if (supportLoom) {
            LoomVirtualThreads vt = new LoomVirtualThreads();
            ImageSingletons.add(VirtualThreads.class, (Object)vt);
            ImageSingletons.add(LoomVirtualThreads.class, (Object)vt);
        } else if (SubstrateOptions.SupportContinuations.getValue().booleanValue()) {
            if (DeoptimizationSupport.enabled()) {
                throw UserError.abort("Option %s is in use, but is not supported together with Truffle JIT compilation.", SubstrateOptionsParser.commandArgument(SubstrateOptions.SupportContinuations, "+"));
            }
            if (SubstrateOptions.useLLVMBackend()) {
                throw UserError.abort("Option %s is in use, but is not supported together with the LLVM backend.", SubstrateOptionsParser.commandArgument(SubstrateOptions.SupportContinuations, "+"));
            }
            if (JavaVersionUtil.JAVA_SPEC == 17) {
                ImageSingletons.add(VirtualThreads.class, (Object)new SubstrateVirtualThreads());
            } else {
                if (JavaVersionUtil.JAVA_SPEC >= 19 && JavaVersionUtil.JAVA_SPEC <= 20) {
                    throw UserError.abort("Virtual threads on JDK %d are supported only with preview features enabled (--enable-preview). Using option %s is unnecessary.", JavaVersionUtil.JAVA_SPEC, SubstrateOptionsParser.commandArgument(SubstrateOptions.SupportContinuations, "+"));
                }
                throw UserError.abort("Option %s is in use, but is not supported on JDK %d.", SubstrateOptionsParser.commandArgument(SubstrateOptions.SupportContinuations, "+"), JavaVersionUtil.JAVA_SPEC);
            }
        }
        this.finishedRegistration = true;
    }

    boolean hasFinishedRegistration() {
        return this.finishedRegistration;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (Continuation.isSupported()) {
            if (!ImageSingletons.contains(ContinuationSupport.class)) {
                ImageSingletons.add(ContinuationSupport.class, (Object)new ContinuationSupport());
            }
            Field ipField = ReflectionUtil.lookupField(StoredContinuation.class, (String)"ip");
            access.registerAsAccessed(ipField);
            access.registerReachabilityHandler(a -> access.registerAsInHeap(StoredContinuation.class), new Object[]{ReflectionUtil.lookupMethod(StoredContinuationAccess.class, (String)"allocate", (Class[])new Class[]{Integer.TYPE})});
        } else {
            access.registerReachabilityHandler(a -> ContinuationsFeature.abortIfUnsupported(), new Object[]{StoredContinuationAccess.class});
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (Continuation.isSupported()) {
            Field ipField = ReflectionUtil.lookupField(StoredContinuation.class, (String)"ip");
            long offset = access.objectFieldOffset(ipField);
            ContinuationSupport.singleton().setIPOffset(offset);
        }
    }

    static void abortIfUnsupported() {
        VMError.guarantee(Continuation.isSupported(), "Virtual thread internals are reachable but support is not available or active.");
    }
}

