/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.LinkAtBuildTimeSupport;
import com.oracle.svm.hosted.classinitialization.AllowAllHostedUsagesClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.ClassInitializationConfiguration;
import com.oracle.svm.hosted.classinitialization.ClassInitializationOptions;
import com.oracle.svm.hosted.classinitialization.ClassOrPackageConfig;
import com.oracle.svm.hosted.classinitialization.InitKind;
import com.oracle.svm.hosted.classinitialization.ProvenSafeClassInitializationSupport;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;
import org.graalvm.nativeimage.impl.clinit.ClassInitializationTracking;

public abstract class ClassInitializationSupport
implements RuntimeClassInitializationSupport {
    final ClassInitializationConfiguration classInitializationConfiguration = new ClassInitializationConfiguration();
    final ConcurrentMap<Class<?>, InitKind> classInitKinds = new ConcurrentHashMap();
    boolean configurationSealed;
    final ImageClassLoader loader;
    UnsupportedFeatures unsupportedFeatures;
    final MetaAccessProvider metaAccess;

    public static ClassInitializationSupport create(MetaAccessProvider metaAccess, ImageClassLoader loader) {
        if (ClassInitializationOptions.UseNewExperimentalClassInitialization.getValue().booleanValue()) {
            System.out.println("WARNING: using new experimental class initialization strategy. Image size and peak performance are not optimized yet!");
            return new AllowAllHostedUsagesClassInitializationSupport(metaAccess, loader);
        }
        return new ProvenSafeClassInitializationSupport(metaAccess, loader);
    }

    ClassInitializationSupport(MetaAccessProvider metaAccess, ImageClassLoader loader) {
        this.metaAccess = metaAccess;
        this.loader = loader;
    }

    public void setConfigurationSealed(boolean sealed) {
        this.configurationSealed = sealed;
        if (this.configurationSealed && ClassInitializationOptions.PrintClassInitialization.getValue().booleanValue()) {
            List<ClassOrPackageConfig> allConfigs = this.classInitializationConfiguration.allConfigs();
            allConfigs.sort(Comparator.comparing(ClassOrPackageConfig::getName));
            ReportUtils.report((String)"class initialization configuration", (String)SubstrateOptions.reportsPath(), (String)"class_initialization_configuration", (String)"csv", writer -> {
                writer.println("Class or Package Name, Initialization Kind, Reasons");
                for (ClassOrPackageConfig config : allConfigs) {
                    writer.append(config.getName()).append(", ").append(config.getKind().toString()).append(", ").append(String.join((CharSequence)" and ", config.getReasons())).append(System.lineSeparator());
                }
            });
        }
    }

    void setUnsupportedFeatures(UnsupportedFeatures unsupportedFeatures) {
        this.unsupportedFeatures = unsupportedFeatures;
    }

    InitKind specifiedInitKindFor(Class<?> clazz) {
        return (InitKind)((Object)this.classInitializationConfiguration.lookupKind(clazz.getTypeName()).getLeft());
    }

    Boolean isStrictlyDefined(Class<?> clazz) {
        return (Boolean)this.classInitializationConfiguration.lookupKind(clazz.getTypeName()).getRight();
    }

    Set<Class<?>> classesWithKind(InitKind kind) {
        return this.classInitKinds.entrySet().stream().filter(e -> e.getValue() == kind).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public boolean shouldInitializeAtRuntime(ResolvedJavaType type) {
        return this.computeInitKindAndMaybeInitializeClass(ClassInitializationSupport.getJavaClass(type)) != InitKind.BUILD_TIME;
    }

    public boolean shouldInitializeAtRuntime(Class<?> clazz) {
        return this.computeInitKindAndMaybeInitializeClass(clazz) != InitKind.BUILD_TIME;
    }

    public void maybeInitializeHosted(ResolvedJavaType type) {
        this.computeInitKindAndMaybeInitializeClass(ClassInitializationSupport.getJavaClass(type));
    }

    InitKind ensureClassInitialized(Class<?> clazz, boolean allowErrors) {
        try {
            Unsafe.getUnsafe().ensureClassInitialized(clazz);
            this.loader.watchdog.recordActivity();
            return InitKind.BUILD_TIME;
        }
        catch (NoClassDefFoundError ex) {
            if (allowErrors || !LinkAtBuildTimeSupport.singleton().linkAtBuildTime(clazz)) {
                return InitKind.RUN_TIME;
            }
            return this.reportInitializationError("Class initialization of " + clazz.getTypeName() + " failed. " + LinkAtBuildTimeSupport.singleton().errorMessageFor(clazz) + " " + ClassInitializationSupport.instructionsToInitializeAtRuntime(clazz), clazz, ex);
        }
        catch (Throwable t) {
            if (allowErrors) {
                return InitKind.RUN_TIME;
            }
            return this.reportInitializationError("Class initialization of " + clazz.getTypeName() + " failed. " + ClassInitializationSupport.instructionsToInitializeAtRuntime(clazz), clazz, t);
        }
    }

    private InitKind reportInitializationError(String msg, Class<?> clazz, Throwable t) {
        if (this.unsupportedFeatures != null) {
            this.unsupportedFeatures.addMessage(clazz.getTypeName(), null, msg, null, t);
            return InitKind.RUN_TIME;
        }
        throw UserError.abort(t, "%s", msg);
    }

    private static String instructionsToInitializeAtRuntime(Class<?> clazz) {
        return "Use the option " + SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, clazz.getTypeName(), "initialize-at-run-time") + " to explicitly request delayed initialization of this class.";
    }

    static Class<?> getJavaClass(ResolvedJavaType type) {
        return OriginalClassProvider.getJavaClass((ResolvedJavaType)type);
    }

    public void initializeAtRunTime(String name, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        Class<?> clazz = this.loader.findClass(name).get();
        if (clazz != null) {
            this.classInitializationConfiguration.insert(name, InitKind.RUN_TIME, reason, true);
            this.initializeAtRunTime(clazz, reason);
        } else {
            this.classInitializationConfiguration.insert(name, InitKind.RUN_TIME, reason, false);
        }
    }

    public void initializeAtBuildTime(String name, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        Class<?> clazz = this.loader.findClass(name).get();
        if (clazz != null) {
            this.classInitializationConfiguration.insert(name, InitKind.BUILD_TIME, reason, true);
            this.initializeAtBuildTime(clazz, reason);
        } else {
            this.classInitializationConfiguration.insert(name, InitKind.BUILD_TIME, reason, false);
        }
    }

    public void rerunInitialization(String name, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        Class<?> clazz = this.loader.findClass(name).get();
        if (clazz != null) {
            this.classInitializationConfiguration.insert(name, InitKind.RERUN, reason, true);
            this.rerunInitialization(clazz, reason);
        } else {
            this.classInitializationConfiguration.insert(name, InitKind.RERUN, reason, false);
        }
    }

    static boolean isClassListedInStringOption(LocatableMultiOptionValue.Strings option, Class<?> clazz) {
        return option.values().contains(clazz.getName());
    }

    private static boolean isObjectInstantiationForClassTracked(Class<?> clazz) {
        return SubstrateOptions.TraceObjectInstantiation.hasBeenSet() && ClassInitializationSupport.isClassListedInStringOption(SubstrateOptions.TraceObjectInstantiation.getValue(), clazz);
    }

    public String objectInstantiationTraceMessage(Object obj, String action) {
        Map instantiatedObjects = ClassInitializationTracking.instantiatedObjects;
        if (!ClassInitializationSupport.isObjectInstantiationForClassTracked(obj.getClass())) {
            return " To see how this object got instantiated use " + SubstrateOptionsParser.commandArgument(SubstrateOptions.TraceObjectInstantiation, obj.getClass().getName()) + ".";
        }
        if (instantiatedObjects.containsKey(obj)) {
            String culprit = null;
            StackTraceElement[] trace = (StackTraceElement[])instantiatedObjects.get(obj);
            boolean containsLambdaMetaFactory = false;
            for (StackTraceElement stackTraceElement : trace) {
                if (stackTraceElement.getMethodName().equals("<clinit>")) {
                    culprit = stackTraceElement.getClassName();
                }
                if (!stackTraceElement.getClassName().equals("java.lang.invoke.LambdaMetafactory")) continue;
                containsLambdaMetaFactory = true;
            }
            if (containsLambdaMetaFactory) {
                return " Object was instantiated through a lambda (https://github.com/oracle/graal/issues/1218). Try marking " + obj.getClass().getTypeName() + " for build-time initialization with " + SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, obj.getClass().getTypeName(), "initialize-at-build-time") + ".";
            }
            if (culprit != null) {
                return " Object has been initialized by the " + culprit + " class initializer with a trace: \n " + ClassInitializationSupport.getTraceString((StackTraceElement[])instantiatedObjects.get(obj)) + ". " + action;
            }
            return " Object has been initialized through the following trace:\n" + ClassInitializationSupport.getTraceString((StackTraceElement[])instantiatedObjects.get(obj)) + ". " + action;
        }
        return " Object has been initialized without the native-image initialization instrumentation and the stack trace can't be tracked.";
    }

    static String getTraceString(StackTraceElement[] trace) {
        StringBuilder b = new StringBuilder();
        for (StackTraceElement stackTraceElement : trace) {
            b.append("\tat ").append(stackTraceElement.toString()).append("\n");
        }
        return b.toString();
    }

    public abstract void forceInitializeHosted(Class<?> var1, String var2, boolean var3);

    abstract InitKind computeInitKindAndMaybeInitializeClass(Class<?> var1);

    abstract String reasonForClass(Class<?> var1);

    abstract boolean checkDelayedInitialization();

    abstract void doLateInitialization(AnalysisUniverse var1, AnalysisMetaAccess var2);
}

