/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code.amd64;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.code.PatchConsumerFactory;
import com.oracle.svm.hosted.code.HostedImageHeapConstantPatch;
import com.oracle.svm.hosted.code.amd64.AMD64HostedPatcher;
import java.util.function.Consumer;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.AMD64.class})
class AMD64HostedPatcherFeature
implements InternalFeature {
    AMD64HostedPatcherFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(PatchConsumerFactory.HostedPatchConsumerFactory.class, (Object)new PatchConsumerFactory.HostedPatchConsumerFactory(){

            @Override
            public Consumer<Assembler.CodeAnnotation> newConsumer(final CompilationResult compilationResult) {
                return new Consumer<Assembler.CodeAnnotation>(){

                    @Override
                    public void accept(Assembler.CodeAnnotation annotation) {
                        if (annotation instanceof AMD64BaseAssembler.OperandDataAnnotation) {
                            compilationResult.addAnnotation((CompilationResult.CodeAnnotation)new AMD64HostedPatcher((AMD64BaseAssembler.OperandDataAnnotation)annotation));
                        } else if (annotation instanceof AMD64BaseAssembler.AddressDisplacementAnnotation) {
                            AMD64BaseAssembler.AddressDisplacementAnnotation dispAnnotation = (AMD64BaseAssembler.AddressDisplacementAnnotation)annotation;
                            compilationResult.addAnnotation((CompilationResult.CodeAnnotation)new HostedImageHeapConstantPatch(dispAnnotation.operandPosition, (JavaConstant)dispAnnotation.annotation));
                        }
                    }
                };
            }
        });
    }
}

