/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.svm.hosted.ameta.ReadableJavaField;
import com.oracle.svm.hosted.annotation.AnnotationWrapper;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public class SubstitutionField
implements ReadableJavaField,
OriginalFieldProvider,
AnnotationWrapper {
    private final ResolvedJavaField original;
    private final ResolvedJavaField annotated;
    private final boolean isUserSubstitution;

    public SubstitutionField(ResolvedJavaField original, ResolvedJavaField annotated, boolean isUserSubstitution) {
        this.original = original;
        this.annotated = annotated;
        this.isUserSubstitution = isUserSubstitution;
    }

    @Override
    public boolean isValueAvailableBeforeAnalysis() {
        return true;
    }

    @Override
    public boolean injectFinalForRuntimeCompilation() {
        return false;
    }

    @Override
    public JavaConstant readValue(MetaAccessProvider metaAccess, ClassInitializationSupport classInitializationSupport, JavaConstant receiver) {
        JavaConstant value = ReadableJavaField.readFieldValue(metaAccess, classInitializationSupport, this.original, receiver);
        if (value == null) {
            value = ReadableJavaField.readFieldValue(metaAccess, classInitializationSupport, this.annotated, receiver);
        }
        return value;
    }

    public boolean isUserSubstitution() {
        return this.isUserSubstitution;
    }

    public ResolvedJavaField getOriginal() {
        return this.original;
    }

    public ResolvedJavaField getAnnotated() {
        return this.annotated;
    }

    public int getModifiers() {
        return this.annotated.getModifiers();
    }

    public int getOffset() {
        return this.annotated.getOffset();
    }

    public boolean isInternal() {
        return this.annotated.isInternal();
    }

    public boolean isSynthetic() {
        return this.annotated.isSynthetic();
    }

    public String getName() {
        return this.annotated.getName();
    }

    public JavaType getType() {
        return this.annotated.getType();
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.annotated.getDeclaringClass();
    }

    @Override
    public AnnotatedElement getAnnotationRoot() {
        return this.annotated;
    }

    public Field getJavaField() {
        return OriginalFieldProvider.getJavaField((ResolvedJavaField)this.original);
    }
}

