/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.heap.AbstractMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.List;
import javax.management.ObjectName;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.management.Util;

public abstract class CodeCachePoolMXBean
extends AbstractMXBean
implements MemoryPoolMXBean {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    CodeCachePoolMXBean() {
    }

    protected abstract long getCurrentSize();

    protected abstract long getPeakSize();

    @Override
    public MemoryUsage getUsage() {
        long used = this.getCurrentSize();
        return new MemoryUsage(-1L, used, used, -1L);
    }

    @Override
    public MemoryUsage getPeakUsage() {
        long peak = this.getPeakSize();
        return new MemoryUsage(-1L, peak, peak, -1L);
    }

    @Override
    public MemoryType getType() {
        return MemoryType.NON_HEAP;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String[] getMemoryManagerNames() {
        return new String[]{"code cache"};
    }

    @Override
    public long getUsageThreshold() {
        throw new UnsupportedOperationException("Usage threshold is not supported");
    }

    @Override
    public void setUsageThreshold(long threshold) {
        throw new UnsupportedOperationException("Usage threshold is not supported");
    }

    @Override
    public boolean isUsageThresholdExceeded() {
        throw new UnsupportedOperationException("Usage threshold is not supported");
    }

    @Override
    public long getUsageThresholdCount() {
        throw new UnsupportedOperationException("Usage threshold is not supported");
    }

    @Override
    public boolean isUsageThresholdSupported() {
        return false;
    }

    @Override
    public long getCollectionUsageThreshold() {
        throw new UnsupportedOperationException("Collection usage threshold is not supported");
    }

    @Override
    public void setCollectionUsageThreshold(long threshold) {
        throw new UnsupportedOperationException("Collection usage threshold is not supported");
    }

    @Override
    public boolean isCollectionUsageThresholdExceeded() {
        throw new UnsupportedOperationException("Collection usage threshold is not supported");
    }

    @Override
    public long getCollectionUsageThresholdCount() {
        throw new UnsupportedOperationException("Collection usage threshold is not supported");
    }

    @Override
    public MemoryUsage getCollectionUsage() {
        return new MemoryUsage(-1L, 0L, 0L, -1L);
    }

    @Override
    public boolean isCollectionUsageThresholdSupported() {
        return false;
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=MemoryPool", this.getName());
    }

    public static List<MemoryPoolMXBean> getMemoryPools() {
        return List.of(new CodeAndDataPool(), new NativeMetadataPool());
    }

    static final class CodeAndDataPool
    extends CodeCachePoolMXBean {
        CodeAndDataPool() {
        }

        @Override
        protected long getCurrentSize() {
            RuntimeCodeInfoMemory.SizeCounters counters = RuntimeCodeInfoMemory.singleton().getSizeCounters();
            return counters.codeAndDataMemorySize().rawValue();
        }

        @Override
        protected long getPeakSize() {
            RuntimeCodeInfoMemory.SizeCounters counters = RuntimeCodeInfoMemory.singleton().getPeakSizeCounters();
            return counters.codeAndDataMemorySize().rawValue();
        }

        @Override
        public void resetPeakUsage() {
            RuntimeCodeInfoMemory.singleton().clearPeakCodeAndDataCounters();
        }

        @Override
        public String getName() {
            return "runtime code cache (code and data)";
        }
    }

    static final class NativeMetadataPool
    extends CodeCachePoolMXBean {
        NativeMetadataPool() {
        }

        @Override
        protected long getCurrentSize() {
            RuntimeCodeInfoMemory.SizeCounters counters = RuntimeCodeInfoMemory.singleton().getSizeCounters();
            return counters.nativeMetadataSize().rawValue();
        }

        @Override
        protected long getPeakSize() {
            RuntimeCodeInfoMemory.SizeCounters counters = RuntimeCodeInfoMemory.singleton().getPeakSizeCounters();
            return counters.nativeMetadataSize().rawValue();
        }

        @Override
        public void resetPeakUsage() {
            RuntimeCodeInfoMemory.singleton().clearPeakNativeMetadataCounters();
        }

        @Override
        public String getName() {
            return "runtime code cache (native metadata)";
        }
    }
}

