/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.Timer;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class GCAccounting {
    private long incrementalCollectionCount = 0L;
    private long incrementalCollectionTotalNanos = 0L;
    private long completeCollectionCount = 0L;
    private long completeCollectionTotalNanos = 0L;
    private UnsignedWord totalCollectedChunkBytes = (UnsignedWord)WordFactory.zero();
    private UnsignedWord totalAllocatedChunkBytes = (UnsignedWord)WordFactory.zero();
    private UnsignedWord lastIncrementalCollectionPromotedChunkBytes = (UnsignedWord)WordFactory.zero();
    private boolean lastIncrementalCollectionOverflowedSurvivors = false;
    private UnsignedWord youngChunkBytesBefore = (UnsignedWord)WordFactory.zero();
    private UnsignedWord oldChunkBytesBefore = (UnsignedWord)WordFactory.zero();
    private UnsignedWord oldChunkBytesAfter = (UnsignedWord)WordFactory.zero();
    private UnsignedWord totalCollectedObjectBytes = (UnsignedWord)WordFactory.zero();
    private UnsignedWord youngObjectBytesBefore = (UnsignedWord)WordFactory.zero();
    private UnsignedWord oldObjectBytesBefore = (UnsignedWord)WordFactory.zero();
    private UnsignedWord allocatedObjectBytes = (UnsignedWord)WordFactory.zero();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    GCAccounting() {
    }

    public long getIncrementalCollectionCount() {
        return this.incrementalCollectionCount;
    }

    public long getIncrementalCollectionTotalNanos() {
        return this.incrementalCollectionTotalNanos;
    }

    public long getCompleteCollectionCount() {
        return this.completeCollectionCount;
    }

    public long getCompleteCollectionTotalNanos() {
        return this.completeCollectionTotalNanos;
    }

    UnsignedWord getTotalAllocatedChunkBytes() {
        return this.totalAllocatedChunkBytes;
    }

    UnsignedWord getTotalCollectedChunkBytes() {
        return this.totalCollectedChunkBytes;
    }

    UnsignedWord getTotalCollectedObjectBytes() {
        return this.totalCollectedObjectBytes;
    }

    UnsignedWord getAllocatedObjectBytes() {
        return this.allocatedObjectBytes;
    }

    UnsignedWord getOldGenerationAfterChunkBytes() {
        return this.oldChunkBytesAfter;
    }

    UnsignedWord getYoungChunkBytesBefore() {
        return this.youngChunkBytesBefore;
    }

    UnsignedWord getLastIncrementalCollectionPromotedChunkBytes() {
        return this.lastIncrementalCollectionPromotedChunkBytes;
    }

    public boolean hasLastIncrementalCollectionOverflowedSurvivors() {
        return this.lastIncrementalCollectionOverflowedSurvivors;
    }

    void beforeCollection(boolean completeCollection) {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        this.youngChunkBytesBefore = youngGen.getChunkBytes();
        this.oldChunkBytesBefore = oldGen.getChunkBytes();
        this.totalAllocatedChunkBytes = this.totalAllocatedChunkBytes.add(youngGen.getEden().getChunkBytes());
        if (SerialGCOptions.PrintGCSummary.getValue().booleanValue()) {
            UnsignedWord edenObjectBytesBefore = youngGen.getEden().computeObjectBytes();
            this.youngObjectBytesBefore = edenObjectBytesBefore.add(youngGen.computeSurvivorObjectBytes());
            this.oldObjectBytesBefore = oldGen.computeObjectBytes();
            this.allocatedObjectBytes = this.allocatedObjectBytes.add(edenObjectBytesBefore);
        }
        if (!completeCollection) {
            this.lastIncrementalCollectionOverflowedSurvivors = false;
        }
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void onSurvivorOverflowed() {
        this.lastIncrementalCollectionOverflowedSurvivors = true;
    }

    void afterCollection(boolean completeCollection, Timer collectionTimer) {
        if (completeCollection) {
            this.afterCompleteCollection(collectionTimer);
        } else {
            this.afterIncrementalCollection(collectionTimer);
        }
    }

    private void afterIncrementalCollection(Timer collectionTimer) {
        ++this.incrementalCollectionCount;
        this.afterCollectionCommon();
        this.lastIncrementalCollectionPromotedChunkBytes = this.oldChunkBytesAfter.subtract(this.oldChunkBytesBefore);
        this.incrementalCollectionTotalNanos += collectionTimer.getMeasuredNanos();
    }

    private void afterCompleteCollection(Timer collectionTimer) {
        ++this.completeCollectionCount;
        this.afterCollectionCommon();
        this.completeCollectionTotalNanos += collectionTimer.getMeasuredNanos();
    }

    private void afterCollectionCommon() {
        UnsignedWord afterChunkBytes;
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        UnsignedWord youngChunkBytesAfter = youngGen.getChunkBytes();
        this.oldChunkBytesAfter = oldGen.getChunkBytes();
        UnsignedWord beforeChunkBytes = this.youngChunkBytesBefore.add(this.oldChunkBytesBefore);
        if (beforeChunkBytes.aboveOrEqual(afterChunkBytes = youngChunkBytesAfter.add(this.oldChunkBytesAfter))) {
            UnsignedWord collectedChunkBytes = beforeChunkBytes.subtract(afterChunkBytes);
            this.totalCollectedChunkBytes = this.totalCollectedChunkBytes.add(collectedChunkBytes);
        }
        if (SerialGCOptions.PrintGCSummary.getValue().booleanValue()) {
            UnsignedWord afterObjectBytesAfter = youngGen.computeObjectBytes().add(oldGen.computeObjectBytes());
            UnsignedWord beforeObjectBytes = this.youngObjectBytesBefore.add(this.oldObjectBytesBefore);
            if (beforeObjectBytes.aboveOrEqual(afterObjectBytesAfter)) {
                UnsignedWord collectedObjectBytes = beforeObjectBytes.subtract(afterObjectBytesAfter);
                this.totalCollectedObjectBytes = this.totalCollectedObjectBytes.add(collectedObjectBytes);
            }
        }
    }
}

