/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.CPUFeatureAccess;
import com.oracle.svm.core.IsolateArgumentParser;
import com.oracle.svm.core.IsolateListenerSupport;
import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.nodes.CEntryPointEnterNode;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.graal.nodes.CEntryPointUtilityNode;
import com.oracle.svm.core.graal.nodes.WriteCurrentVMThreadNode;
import com.oracle.svm.core.graal.nodes.WriteHeapBaseNode;
import com.oracle.svm.core.graal.snippets.CEntryPointListenerSupport;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.heap.ReferenceHandler;
import com.oracle.svm.core.heap.ReferenceHandlerThread;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionParser;
import com.oracle.svm.core.os.MemoryProtectionProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import jdk.internal.misc.Unsafe;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.PauseNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class CEntryPointSnippets
extends SubstrateTemplates
implements Snippets {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_ISOLATE = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "createIsolate", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor INITIALIZE_ISOLATE = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "initializeIsolate", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor ATTACH_THREAD = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "attachThread", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor ENSURE_JAVA_THREAD = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "ensureJavaThread", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor ENTER_BY_ISOLATE_MT = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "enterByIsolateMT", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor DETACH_THREAD_MT = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "detachThreadMT", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor REPORT_EXCEPTION = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "reportException", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor TEAR_DOWN_ISOLATE = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "tearDownIsolate", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor IS_ATTACHED_MT = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "isAttachedMT", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor FAIL_FATALLY = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "failFatally", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor VERIFY_ISOLATE_THREAD = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "verifyIsolateThread", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{CREATE_ISOLATE, INITIALIZE_ISOLATE, ATTACH_THREAD, ENSURE_JAVA_THREAD, ENTER_BY_ISOLATE_MT, DETACH_THREAD_MT, REPORT_EXCEPTION, TEAR_DOWN_ISOLATE, IS_ATTACHED_MT, FAIL_FATALLY, VERIFY_ISOLATE_THREAD};
    private static final CGlobalData<PointerBase> FIRST_ISOLATE_INIT_STATE = CGlobalDataFactory.createWord();
    private static boolean isolateInitialized;
    private final SnippetTemplate.SnippetInfo createIsolate;
    private final SnippetTemplate.SnippetInfo attachThread;
    private final SnippetTemplate.SnippetInfo enter;
    private final SnippetTemplate.SnippetInfo enterByIsolate;
    private final SnippetTemplate.SnippetInfo returnFromJavaToC;
    private final SnippetTemplate.SnippetInfo detachThread;
    private final SnippetTemplate.SnippetInfo reportException;
    private final SnippetTemplate.SnippetInfo tearDownIsolate;
    private final SnippetTemplate.SnippetInfo isAttached;
    private final SnippetTemplate.SnippetInfo failFatally;

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCall(@Node.ConstantNodeParameter ForeignCallDescriptor var0, CEntryPointCreateIsolateParameters var1, int var2);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCall(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Isolate var1, boolean var2, boolean var3, int var4, boolean var5);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCall(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Isolate var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCall(@Node.ConstantNodeParameter ForeignCallDescriptor var0, IsolateThread var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCall(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Throwable var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCallInitializeIsolate(@Node.ConstantNodeParameter ForeignCallDescriptor var0, CEntryPointCreateIsolateParameters var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCallTearDownIsolate(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native boolean runtimeCallIsAttached(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Isolate var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native void runtimeCallFailFatally(@Node.ConstantNodeParameter ForeignCallDescriptor var0, int var1, CCharPointer var2);

    @Fold
    static boolean hasHeapBase() {
        return ((CompressEncoding)ImageSingletons.lookup(CompressEncoding.class)).hasBase();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setHeapBase(PointerBase heapBase) {
        if (CEntryPointSnippets.hasHeapBase()) {
            WriteHeapBaseNode.writeCurrentVMHeapBase(heapBase);
            if (MemoryProtectionProvider.isAvailable()) {
                MemoryProtectionProvider.singleton().unlockCurrentIsolate();
            }
        } else {
            WriteHeapBaseNode.writeCurrentVMHeapBase(WordFactory.nullPointer());
        }
    }

    @Snippet(allowMissingProbabilities=true)
    public static int createIsolateSnippet(CEntryPointCreateIsolateParameters parameters, @Snippet.ConstantParameter int vmThreadSize) {
        int result;
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            WriteCurrentVMThreadNode.writeCurrentVMThread((IsolateThread)WordFactory.nullPointer());
        }
        if ((result = CEntryPointSnippets.runtimeCall(CREATE_ISOLATE, parameters, vmThreadSize)) != 0) {
            return result;
        }
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            Safepoint.transitionNativeToJava(false);
        }
        result = CEntryPointSnippets.runtimeCallInitializeIsolate(INITIALIZE_ISOLATE, parameters);
        return result;
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int createIsolate(CEntryPointCreateIsolateParameters providedParameters, int vmThreadSize) {
        WordPointer isolatePtr;
        int error;
        UnsignedWord imagePageSize;
        boolean validPageSize;
        CPUFeatureAccess cpuFeatureAccess = (CPUFeatureAccess)ImageSingletons.lookup(CPUFeatureAccess.class);
        if (cpuFeatureAccess.verifyHostSupportsArchitectureEarly() != 0) {
            return 23;
        }
        UnsignedWord runtimePageSize = VirtualMemoryProvider.get().getGranularity();
        boolean bl = validPageSize = runtimePageSize.equal(imagePageSize = WordFactory.unsigned((int)SubstrateOptions.getPageSize())) || Heap.getHeap().allowPageSizeMismatch() && UnsignedUtils.isAMultiple(imagePageSize, runtimePageSize);
        if (!validPageSize) {
            return 24;
        }
        CLongPointer parsedArgs = (CLongPointer)StackValue.get((int)IsolateArgumentParser.getStructSize());
        CEntryPointCreateIsolateParameters parameters = providedParameters;
        if (parameters.isNull() || parameters.version() < 1) {
            parameters = (CEntryPointCreateIsolateParameters)StackValue.get(CEntryPointCreateIsolateParameters.class);
            parameters.setReservedSpaceSize((UnsignedWord)WordFactory.zero());
            parameters.setVersion(1);
        }
        IsolateArgumentParser.parse(parameters, parsedArgs);
        if (parameters.reservedSpaceSize().equal(0)) {
            parameters.setReservedSpaceSize(WordFactory.unsigned((long)parsedArgs.read(IsolateArgumentParser.getOptionIndex(SubstrateGCOptions.ReservedAddressSpaceSize))));
        }
        if ((error = Isolates.create(isolatePtr = (WordPointer)StackValue.get(WordPointer.class), parameters)) != 0) {
            return error;
        }
        Isolate isolate = (Isolate)isolatePtr.read();
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            CEntryPointSnippets.setHeapBase(Isolates.getHeapBase(isolate));
        }
        return CEntryPointSnippets.createIsolate0(parsedArgs, isolate, vmThreadSize);
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    @NeverInline(value="Ensure this code cannot rise above where heap base is set.")
    private static int createIsolate0(CLongPointer parsedArgs, Isolate isolate, int vmThreadSize) {
        IsolateArgumentParser.singleton().persistOptions(parsedArgs);
        IsolateListenerSupport.singleton().afterCreateIsolate(isolate);
        CodeInfoTable.prepareImageCodeInfo();
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue() && !VMThreads.ensureInitialized()) {
            return 11;
        }
        int error = CEntryPointSnippets.attachThread(isolate, false, false, vmThreadSize, true);
        if (error != 0) {
            return error;
        }
        PlatformThreads.singleton().initializeIsolate();
        return 0;
    }

    public static boolean isIsolateInitialized() {
        return isolateInitialized;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int initializeIsolate(CEntryPointCreateIsolateParameters parameters) {
        boolean firstIsolate = false;
        long initStateAddr = FIRST_ISOLATE_INIT_STATE.get().rawValue();
        int state = Unsafe.getUnsafe().getInt(initStateAddr);
        if (state != 2 && !(firstIsolate = Unsafe.getUnsafe().compareAndSetInt(null, initStateAddr, 0, 1))) {
            while (state == 1) {
                PauseNode.pause();
                state = Unsafe.getUnsafe().getIntVolatile(null, initStateAddr);
            }
            if (state == -1) {
                return 13;
            }
        }
        Isolates.setCurrentIsFirstIsolate(firstIsolate);
        Isolates.setCurrentStartTime();
        if (VMOperationControl.useDedicatedVMOperationThread()) {
            VMOperationControl.startVMOperationThread();
        }
        if (ReferenceHandler.useDedicatedThread()) {
            ReferenceHandlerThread.start();
        }
        if (parameters.isNonNull() && parameters.version() >= 3 && parameters.getArgv().isNonNull()) {
            boolean exitWhenArgumentParsingFails = true;
            boolean ignoreUnrecognized = false;
            if (parameters.version() >= 4) {
                ignoreUnrecognized = parameters.getIgnoreUnrecognizedArguments();
                exitWhenArgumentParsingFails = parameters.getExitWhenArgumentParsingFails();
            }
            String[] args = SubstrateUtil.convertCToJavaArgs(parameters.getArgc(), parameters.getArgv());
            try {
                args = RuntimeOptionParser.parseAndConsumeAllOptions(args, ignoreUnrecognized);
            }
            catch (IllegalArgumentException e) {
                if (exitWhenArgumentParsingFails) {
                    Log.logStream().println("error: " + e.getMessage());
                    System.exit(1);
                }
                CEntryPointActions.leaveTearDownIsolate();
                return 22;
            }
            if (ImageSingletons.contains(JavaMainWrapper.JavaMainSupport.class)) {
                ((JavaMainWrapper.JavaMainSupport)ImageSingletons.lookup(JavaMainWrapper.JavaMainSupport.class)).mainArgs = args;
            }
        }
        boolean success = PlatformNativeLibrarySupport.singleton().initializeBuiltinLibraries();
        if (firstIsolate) {
            state = success ? 2 : -1;
            Unsafe.getUnsafe().putIntVolatile(null, initStateAddr, state);
        }
        if (!success) {
            CEntryPointActions.leaveTearDownIsolate();
            return 13;
        }
        StackOverflowCheck.singleton().updateStackOverflowBoundary();
        PhysicalMemory.size();
        assert (!isolateInitialized);
        isolateInitialized = true;
        try {
            RuntimeSupport.executeInitializationHooks();
        }
        catch (Throwable t) {
            System.err.println("Uncaught exception while running initialization hooks:");
            t.printStackTrace();
            CEntryPointActions.leaveTearDownIsolate();
            return 13;
        }
        return 0;
    }

    @Snippet(allowMissingProbabilities=true)
    public static int attachThreadSnippet(Isolate isolate, boolean startedByIsolate, boolean ensureJavaThread, boolean inCrashHandler, @Snippet.ConstantParameter int vmThreadSize) {
        int error;
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            WriteCurrentVMThreadNode.writeCurrentVMThread((IsolateThread)WordFactory.nullPointer());
        }
        if ((error = CEntryPointSnippets.runtimeCall(ATTACH_THREAD, isolate, startedByIsolate, inCrashHandler, vmThreadSize, ensureJavaThread)) != 0) {
            return error;
        }
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue() && !inCrashHandler) {
            Safepoint.transitionNativeToJava(false);
        }
        if (ensureJavaThread) {
            CEntryPointSnippets.runtimeCallEnsureJavaThread(ENSURE_JAVA_THREAD);
        }
        return 0;
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int attachThread(Isolate isolate, boolean startedByIsolate, boolean inCrashHandler, int vmThreadSize, boolean ensuringJavaThread) {
        int error = Isolates.checkIsolate(isolate);
        if (error != 0) {
            return error;
        }
        CEntryPointListenerSupport.singleton().beforeThreadAttach();
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            CEntryPointSnippets.setHeapBase(Isolates.getHeapBase(isolate));
        }
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            if (!VMThreads.isInitialized()) {
                error = 5;
                CEntryPointListenerSupport.singleton().errorThreadAttach(error);
                return error;
            }
            IsolateThread thread = (IsolateThread)WordFactory.nullPointer();
            if (startedByIsolate) {
                assert (VMThreads.singleton().findIsolateThreadForCurrentOSThread(inCrashHandler).isNull());
            } else {
                thread = VMThreads.singleton().findIsolateThreadForCurrentOSThread(inCrashHandler);
            }
            if (thread.isNull()) {
                error = CEntryPointSnippets.attachUnattachedThread(isolate, startedByIsolate, inCrashHandler, vmThreadSize);
                if (error != 0) {
                    CEntryPointListenerSupport.singleton().errorThreadAttach(error);
                    return error;
                }
            } else {
                WriteCurrentVMThreadNode.writeCurrentVMThread(thread);
                if (ensuringJavaThread && !PlatformThreads.isCurrentAssigned()) {
                    throw VMError.shouldNotReachHere("thread was already attached but does not have a Thread object and we would assign one");
                }
            }
        } else {
            StackOverflowCheck.singleton().initialize((IsolateThread)WordFactory.nullPointer());
        }
        CEntryPointListenerSupport.singleton().afterThreadAttach();
        return 0;
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    private static int attachUnattachedThread(Isolate isolate, boolean startedByIsolate, boolean inCrashHandler, int vmThreadSize) {
        IsolateThread thread = VMThreads.singleton().allocateIsolateThread(vmThreadSize);
        if (thread.isNull()) {
            return 11;
        }
        StackOverflowCheck.singleton().initialize(thread);
        WriteCurrentVMThreadNode.writeCurrentVMThread(thread);
        if (inCrashHandler) {
            SubstrateDiagnostics.setOnlyAttachedForCrashHandler(thread);
        } else {
            int error = VMThreads.singleton().attachThread(thread, startedByIsolate);
            if (error != 0) {
                VMThreads.singleton().freeIsolateThread(thread);
                return error;
            }
        }
        VMThreads.IsolateTL.set(thread, isolate);
        return 0;
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native void runtimeCallEnsureJavaThread(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static void ensureJavaThread() {
        PlatformThreads.ensureCurrentAssigned();
    }

    @Snippet(allowMissingProbabilities=true)
    public static int detachThreadSnippet() {
        int result = 0;
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            IsolateThread thread = CurrentIsolate.getCurrentThread();
            result = CEntryPointSnippets.runtimeCall((ForeignCallDescriptor)DETACH_THREAD_MT, thread);
        }
        return result;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="Thread state going away.")
    private static int detachThreadMT(IsolateThread currentThread) {
        CEntryPointListenerSupport.singleton().beforeThreadDetach();
        try {
            VMThreads.singleton().detachThread(currentThread);
            CEntryPointListenerSupport.singleton().afterThreadDetach();
        }
        catch (Throwable t) {
            CEntryPointListenerSupport.singleton().errorThreadDetach(12);
            return 12;
        }
        return 0;
    }

    @Snippet(allowMissingProbabilities=true)
    public static int tearDownIsolateSnippet() {
        return CEntryPointSnippets.runtimeCallTearDownIsolate(TEAR_DOWN_ISOLATE);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="All code executed after VMThreads#tearDown must be uninterruptible")
    private static int tearDownIsolate() {
        try {
            if (!CEntryPointSnippets.initiateTearDownIsolateInterruptibly()) {
                return 1;
            }
            VMThreads.singleton().tearDown();
            IsolateThread finalThread = CurrentIsolate.getCurrentThread();
            int result = Isolates.tearDownCurrent();
            VMThreads.singleton().freeIsolateThread(finalThread);
            return result;
        }
        catch (Throwable t) {
            return CEntryPointSnippets.reportException(t);
        }
    }

    @Uninterruptible(reason="Used as a transition between uninterruptible and interruptible code", calleeMustBe=false)
    private static boolean initiateTearDownIsolateInterruptibly() {
        RuntimeSupport.executeTearDownHooks();
        return PlatformThreads.singleton().tearDown();
    }

    @Snippet(allowMissingProbabilities=true)
    public static int enterByIsolateSnippet(Isolate isolate) {
        int result;
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            WriteCurrentVMThreadNode.writeCurrentVMThread((IsolateThread)WordFactory.nullPointer());
            result = CEntryPointSnippets.runtimeCall((ForeignCallDescriptor)ENTER_BY_ISOLATE_MT, isolate);
            if (result == 0 && VMThreads.StatusSupport.isStatusNativeOrSafepoint()) {
                Safepoint.transitionNativeToJava(false);
            }
        } else {
            result = Isolates.checkIsolate(isolate);
            if (result == 0 && SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                CEntryPointSnippets.setHeapBase(Isolates.getHeapBase(isolate));
            }
        }
        return result;
    }

    @Uninterruptible(reason="Thread state not set up yet")
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int enterByIsolateMT(Isolate isolate) {
        int error = Isolates.checkIsolate(isolate);
        if (error != 0) {
            return error;
        }
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            CEntryPointSnippets.setHeapBase(Isolates.getHeapBase(isolate));
        }
        if (!VMThreads.isInitialized()) {
            return 5;
        }
        IsolateThread thread = VMThreads.singleton().findIsolateThreadForCurrentOSThread(false);
        if (thread.isNull()) {
            return 4;
        }
        WriteCurrentVMThreadNode.writeCurrentVMThread(thread);
        return 0;
    }

    @Snippet(allowMissingProbabilities=true)
    public static int enterSnippet(IsolateThread thread) {
        Isolate isolate;
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            if (thread.isNull()) {
                return 2;
            }
            WriteCurrentVMThreadNode.writeCurrentVMThread(thread);
            isolate = VMThreads.IsolateTL.get(thread);
        } else {
            if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                if (thread.isNull()) {
                    return 2;
                }
            } else if (!thread.equal((ComparableWord)CEntryPointSetup.SINGLE_THREAD_SENTINEL)) {
                return 4;
            }
            isolate = (Isolate)((Word)thread).subtract(1575);
        }
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            CEntryPointSnippets.setHeapBase(Isolates.getHeapBase(isolate));
        }
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            if (CEntryPointSnippets.runtimeAssertionsEnabled() || SubstrateOptions.CheckIsolateThreadAtEntry.getValue().booleanValue()) {
                CEntryPointSnippets.runtimeCall((ForeignCallDescriptor)VERIFY_ISOLATE_THREAD, thread);
            }
            Safepoint.transitionNativeToJava(false);
        }
        return 0;
    }

    @Fold
    static boolean runtimeAssertionsEnabled() {
        return RuntimeAssertionsSupport.singleton().desiredAssertionStatus(CEntryPointSnippets.class);
    }

    @Uninterruptible(reason="Thread state not set up yet")
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int verifyIsolateThread(IsolateThread thread) {
        VMError.guarantee(CurrentIsolate.getCurrentThread() == thread, "Threads must match for the call below");
        if (!VMThreads.singleton().verifyIsCurrentThread(thread) || !VMThreads.singleton().verifyThreadIsAttached(thread)) {
            throw VMError.shouldNotReachHere("A call from native code to Java code provided the wrong JNI environment or the wrong IsolateThread. The JNI environment / IsolateThread is a thread-local data structure and must not be shared between threads.");
        }
        return 0;
    }

    @Snippet(allowMissingProbabilities=true)
    public static int reportExceptionSnippet(Throwable exception) {
        return CEntryPointSnippets.runtimeCall((ForeignCallDescriptor)REPORT_EXCEPTION, exception);
    }

    @Uninterruptible(reason="Avoid StackOverflowError and safepoints until they are disabled permanently", calleeMustBe=false)
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in fatal error handling.")
    private static int reportException(Throwable exception) {
        VMThreads.SafepointBehavior.preventSafepoints();
        StackOverflowCheck.singleton().disableStackOverflowChecksForFatalError();
        CEntryPointSnippets.reportExceptionInterruptibly(exception);
        return 1;
    }

    private static void reportExceptionInterruptibly(Throwable exception) {
        CEntryPointSnippets.logException(exception);
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in fatal error handling.")
    private static void logException(Throwable exception) {
        try {
            Log.log().exception(exception);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Snippet(allowMissingProbabilities=true)
    public static int returnFromJavaToCSnippet() {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            VMThreads.StatusSupport.setStatusNative();
        }
        return 0;
    }

    @Snippet(allowMissingProbabilities=true)
    public static boolean isAttachedSnippet(Isolate isolate) {
        return Isolates.checkIsolate(isolate) == 0 && (SubstrateOptions.MultiThreaded.getValue() == false || CEntryPointSnippets.runtimeCallIsAttached(IS_ATTACHED_MT, isolate));
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static boolean isAttachedMT(Isolate isolate) {
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            CEntryPointSnippets.setHeapBase(Isolates.getHeapBase(isolate));
        }
        return VMThreads.isInitialized() && VMThreads.singleton().findIsolateThreadForCurrentOSThread(false).isNonNull();
    }

    @Snippet(allowMissingProbabilities=true)
    public static void failFatallySnippet(int code, CCharPointer message) {
        CEntryPointSnippets.runtimeCallFailFatally(FAIL_FATALLY, code, message);
    }

    @Uninterruptible(reason="Unknown thread state.")
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static void failFatally(int code, CCharPointer message) {
        VMThreads.singleton().failFatally(code, message);
    }

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(FOREIGN_CALLS);
    }

    public static void registerLowerings(OptionValues options, Providers providers, int vmThreadSize, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new CEntryPointSnippets(options, providers, vmThreadSize, lowerings);
    }

    private CEntryPointSnippets(OptionValues options, Providers providers, int vmThreadSize, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        this.createIsolate = this.snippet(providers, CEntryPointSnippets.class, "createIsolateSnippet", new LocationIdentity[0]);
        this.attachThread = this.snippet(providers, CEntryPointSnippets.class, "attachThreadSnippet", new LocationIdentity[0]);
        this.enter = this.snippet(providers, CEntryPointSnippets.class, "enterSnippet", new LocationIdentity[0]);
        this.enterByIsolate = this.snippet(providers, CEntryPointSnippets.class, "enterByIsolateSnippet", new LocationIdentity[0]);
        this.returnFromJavaToC = this.snippet(providers, CEntryPointSnippets.class, "returnFromJavaToCSnippet", new LocationIdentity[0]);
        this.detachThread = this.snippet(providers, CEntryPointSnippets.class, "detachThreadSnippet", new LocationIdentity[0]);
        this.reportException = this.snippet(providers, CEntryPointSnippets.class, "reportExceptionSnippet", new LocationIdentity[0]);
        this.tearDownIsolate = this.snippet(providers, CEntryPointSnippets.class, "tearDownIsolateSnippet", new LocationIdentity[0]);
        this.isAttached = this.snippet(providers, CEntryPointSnippets.class, "isAttachedSnippet", new LocationIdentity[0]);
        this.failFatally = this.snippet(providers, CEntryPointSnippets.class, "failFatallySnippet", new LocationIdentity[0]);
        lowerings.put(CEntryPointEnterNode.class, new EnterLowering(vmThreadSize));
        lowerings.put(CEntryPointLeaveNode.class, new LeaveLowering());
        lowerings.put(CEntryPointUtilityNode.class, new UtilityLowering());
    }

    private static final class FirstIsolateInitStates {
        static final int UNINITIALIZED = 0;
        static final int IN_PROGRESS = 1;
        static final int SUCCESSFUL = 2;
        static final int FAILED = -1;

        private FirstIsolateInitStates() {
        }
    }

    protected class EnterLowering
    implements NodeLoweringProvider<CEntryPointEnterNode> {
        private final int vmThreadSize;

        EnterLowering(int vmThreadSize) {
            this.vmThreadSize = vmThreadSize;
        }

        @Override
        public void lower(CEntryPointEnterNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args;
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                return;
            }
            switch (node.getEnterAction()) {
                case CreateIsolate: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.createIsolate, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("parameters", (Object)node.getParameter());
                    args.addConst("vmThreadSize", (Object)this.vmThreadSize);
                    break;
                }
                case AttachThread: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.attachThread, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("isolate", (Object)node.getParameter());
                    args.add("startedByIsolate", (Object)node.getStartedByIsolate());
                    args.add("ensureJavaThread", (Object)node.getEnsureJavaThread());
                    args.add("inCrashHandler", (Object)node.isCrashHandler());
                    args.addConst("vmThreadSize", (Object)this.vmThreadSize);
                    break;
                }
                case EnterByIsolate: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.enterByIsolate, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("isolate", (Object)node.getParameter());
                    break;
                }
                case Enter: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.enter, node.graph().getGuardsStage(), tool.getLoweringStage());
                    assert (node.getParameter() != null);
                    args.add("thread", (Object)node.getParameter());
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHereUnexpectedInput((Object)node.getEnterAction());
                }
            }
            SnippetTemplate template = CEntryPointSnippets.this.template((CoreProviders)tool, (ValueNode)node, args);
            template.setMayRemoveLocation(true);
            template.instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class LeaveLowering
    implements NodeLoweringProvider<CEntryPointLeaveNode> {
        protected LeaveLowering() {
        }

        @Override
        public void lower(CEntryPointLeaveNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args;
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                return;
            }
            switch (node.getLeaveAction()) {
                case Leave: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.returnFromJavaToC, node.graph().getGuardsStage(), tool.getLoweringStage());
                    break;
                }
                case DetachThread: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.detachThread, node.graph().getGuardsStage(), tool.getLoweringStage());
                    break;
                }
                case TearDownIsolate: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.tearDownIsolate, node.graph().getGuardsStage(), tool.getLoweringStage());
                    break;
                }
                case ExceptionAbort: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.reportException, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("exception", (Object)node.getException());
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHereUnexpectedInput((Object)node.getLeaveAction());
                }
            }
            CEntryPointSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class UtilityLowering
    implements NodeLoweringProvider<CEntryPointUtilityNode> {
        protected UtilityLowering() {
        }

        @Override
        public void lower(CEntryPointUtilityNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args;
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                return;
            }
            switch (node.getUtilityAction()) {
                case IsAttached: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.isAttached, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("isolate", (Object)node.getParameter0());
                    break;
                }
                case FailFatally: {
                    args = new SnippetTemplate.Arguments(CEntryPointSnippets.this.failFatally, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("code", (Object)node.getParameter0());
                    args.add("message", (Object)node.getParameter1());
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHereUnexpectedInput((Object)node.getUtilityAction());
                }
            }
            CEntryPointSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

