/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets.riscv64;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.graal.nodes.VaListInitializationNode;
import com.oracle.svm.core.graal.nodes.VaListNextArgNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;

final class PosixRISCV64VaListSnippets
extends SubstrateTemplates
implements Snippets {
    private static final int STACK_AREA_GP_ALIGNMENT = 8;
    private static final int STACK_AREA_FP_ALIGNMENT = 8;
    private static final StackValueNode.StackSlotIdentity vaListIdentity = new StackValueNode.StackSlotIdentity("PosixRISCV64VaListSnippets.vaListSlotIdentifier", false);
    private final SnippetTemplate.SnippetInfo vaArgDouble;
    private final SnippetTemplate.SnippetInfo vaArgFloat;
    private final SnippetTemplate.SnippetInfo vaArgLong;
    private final SnippetTemplate.SnippetInfo vaArgInt;

    @Snippet
    protected static double vaArgDoubleSnippet(Pointer vaListPointer) {
        Pointer vaList = (Pointer)vaListPointer.readWord(0);
        vaListPointer.writeWord(0, (WordBase)vaList.add(8));
        return vaList.readDouble(0);
    }

    @Snippet
    protected static float vaArgFloatSnippet(Pointer vaListPointer) {
        return (float)PosixRISCV64VaListSnippets.vaArgDoubleSnippet(vaListPointer);
    }

    @Snippet
    protected static long vaArgLongSnippet(Pointer vaListPointer) {
        Pointer vaList = (Pointer)vaListPointer.readWord(0);
        vaListPointer.writeWord(0, (WordBase)vaList.add(8));
        return vaList.readLong(0);
    }

    @Snippet
    protected static int vaArgIntSnippet(Pointer vaListPointer) {
        return (int)PosixRISCV64VaListSnippets.vaArgLongSnippet(vaListPointer);
    }

    public static void registerLowerings(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new PosixRISCV64VaListSnippets(options, providers, lowerings);
    }

    private PosixRISCV64VaListSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        this.vaArgDouble = this.snippet(providers, PosixRISCV64VaListSnippets.class, "vaArgDoubleSnippet", new LocationIdentity[0]);
        this.vaArgFloat = this.snippet(providers, PosixRISCV64VaListSnippets.class, "vaArgFloatSnippet", new LocationIdentity[0]);
        this.vaArgLong = this.snippet(providers, PosixRISCV64VaListSnippets.class, "vaArgLongSnippet", new LocationIdentity[0]);
        this.vaArgInt = this.snippet(providers, PosixRISCV64VaListSnippets.class, "vaArgIntSnippet", new LocationIdentity[0]);
        lowerings.put(VaListInitializationNode.class, new VaListInitializationSnippetsLowering());
        lowerings.put(VaListNextArgNode.class, new VaListSnippetsLowering());
    }

    protected class VaListInitializationSnippetsLowering
    implements NodeLoweringProvider<VaListInitializationNode> {
        protected VaListInitializationSnippetsLowering() {
        }

        @Override
        public void lower(VaListInitializationNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            StackValueNode stackValueNode = (StackValueNode)graph.add((Node)StackValueNode.create(FrameAccess.wordSize(), vaListIdentity, true));
            FrameState frameState = new FrameState(-5);
            frameState.invalidateForDeoptimization();
            stackValueNode.setStateAfter((FrameState)graph.add((Node)frameState));
            OffsetAddressNode address = (OffsetAddressNode)graph.unique((Node)new OffsetAddressNode((ValueNode)stackValueNode, (ValueNode)graph.unique((Node)ConstantNode.forLong((long)0L))));
            WriteNode writeNode = (WriteNode)graph.add((Node)new WriteNode((AddressNode)address, LocationIdentity.any(), node.getVaList(), BarrierType.NONE, MemoryOrderMode.PLAIN));
            FixedNode successor = node.next();
            node.replaceAndDelete((Node)stackValueNode);
            stackValueNode.setNext(successor);
            graph.addAfterFixed((FixedWithNextNode)stackValueNode, (FixedNode)writeNode);
            stackValueNode.lower(tool);
        }
    }

    protected class VaListSnippetsLowering
    implements NodeLoweringProvider<VaListNextArgNode> {
        protected VaListSnippetsLowering() {
        }

        @Override
        public void lower(VaListNextArgNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(switch (node.getStackKind()) {
                case JavaKind.Double -> PosixRISCV64VaListSnippets.this.vaArgDouble;
                case JavaKind.Float -> PosixRISCV64VaListSnippets.this.vaArgFloat;
                case JavaKind.Long -> PosixRISCV64VaListSnippets.this.vaArgLong;
                case JavaKind.Int -> PosixRISCV64VaListSnippets.this.vaArgInt;
                default -> throw VMError.shouldNotReachHereUnexpectedInput(node.getStackKind());
            }, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("vaListPointer", (Object)node.getVaList());
            PosixRISCV64VaListSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

