/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_EventWriter;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import jdk.internal.misc.Unsafe;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;

public final class JfrEventWriterAccess {
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final Field COMMITTED_POSITION_FIELD = ReflectionUtil.lookupField(JfrEventWriterAccess.getEventWriterClass(), (String)"startPosition");
    private static final Field CURRENT_POSITION_FIELD = ReflectionUtil.lookupField(JfrEventWriterAccess.getEventWriterClass(), (String)"currentPosition");
    private static final Field MAX_POSITION_FIELD = ReflectionUtil.lookupField(JfrEventWriterAccess.getEventWriterClass(), (String)"maxPosition");
    private static final Field VALID_FIELD = ReflectionUtil.lookupField(JfrEventWriterAccess.getEventWriterClass(), (String)"valid");

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JfrEventWriterAccess() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Class<?> getEventWriterClass() {
        String className = JavaVersionUtil.JAVA_SPEC >= 19 ? "jdk.jfr.internal.event.EventWriter" : "jdk.jfr.internal.EventWriter";
        return ReflectionUtil.lookupClass((boolean)false, (String)className);
    }

    public static Target_jdk_jfr_internal_EventWriter newEventWriter(JfrBuffer buffer, boolean isCurrentThreadExcluded) {
        assert (JfrBufferAccess.isEmpty(buffer)) : "a fresh JFR buffer must be empty";
        long committedPos = buffer.getCommittedPos().rawValue();
        long maxPos = JfrBufferAccess.getDataEnd(buffer).rawValue();
        long jfrThreadId = SubstrateJVM.getCurrentThreadId();
        if (JavaVersionUtil.JAVA_SPEC >= 19) {
            return new Target_jdk_jfr_internal_EventWriter(committedPos, maxPos, jfrThreadId, true, isCurrentThreadExcluded);
        }
        long addressOfCommittedPos = JfrBufferAccess.getAddressOfCommittedPos(buffer).rawValue();
        return new Target_jdk_jfr_internal_EventWriter(committedPos, maxPos, addressOfCommittedPos, jfrThreadId, true);
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    public static void update(Target_jdk_jfr_internal_EventWriter writer, JfrBuffer buffer, int uncommittedSize, boolean valid) {
        assert (SubstrateJVM.getThreadLocal().getJavaBuffer() == buffer);
        assert (JfrBufferAccess.verify(buffer));
        Pointer committedPos = buffer.getCommittedPos();
        Pointer currentPos = committedPos.add(uncommittedSize);
        Pointer maxPos = JfrBufferAccess.getDataEnd(buffer);
        U.putLong(writer, U.objectFieldOffset(COMMITTED_POSITION_FIELD), committedPos.rawValue());
        U.putLong(writer, U.objectFieldOffset(CURRENT_POSITION_FIELD), currentPos.rawValue());
        U.putLong(writer, U.objectFieldOffset(MAX_POSITION_FIELD), maxPos.rawValue());
        if (!valid) {
            JfrEventWriterAccess.markAsInvalid(writer);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void markAsInvalid(Target_jdk_jfr_internal_EventWriter writer) {
        U.putBooleanVolatile(writer, U.objectFieldOffset(VALID_FIELD), false);
    }
}

