/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.UnsignedWord;

public class SafepointBeginEvent {
    public static void emit(UnsignedWord safepointId, int numJavaThreads, long startTicks) {
        if (!HasJfrSupport.get() || startTicks == 0L) {
            return;
        }
        SafepointBeginEvent.emit0(safepointId, numJavaThreads, startTicks);
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emit0(UnsignedWord safepointId, int numJavaThreads, long startTicks) {
        long duration = JfrTicks.duration(startTicks);
        if (JfrEvent.SafepointBegin.shouldEmit(duration)) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.SafepointBegin);
            JfrNativeEventWriter.putLong(data, startTicks);
            JfrNativeEventWriter.putLong(data, duration);
            JfrNativeEventWriter.putEventThread(data);
            JfrNativeEventWriter.putLong(data, safepointId.rawValue());
            JfrNativeEventWriter.putInt(data, numJavaThreads);
            JfrNativeEventWriter.putInt(data, 0);
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }
}

