/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.methodhandles;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.invoke.Target_java_lang_invoke_MemberName;
import com.oracle.svm.core.methodhandles.MethodHandleIntrinsicImpl;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.graalvm.compiler.debug.GraalError;
import sun.invoke.util.VerifyAccess;

final class Util_java_lang_invoke_MethodHandleNatives {
    private static final Method SET_ACCESSIBLE0 = ReflectionUtil.lookupMethod(AccessibleObject.class, (String)"setAccessible0", (Class[])new Class[]{Boolean.TYPE});
    private static Method verifyAccess;

    Util_java_lang_invoke_MethodHandleNatives() {
    }

    static Method lookupMethod(Class<?> declaringClazz, String name, Class<?>[] parameterTypes) throws NoSuchMethodException {
        return Util_java_lang_invoke_MethodHandleNatives.lookupMethod(declaringClazz, name, parameterTypes, null);
    }

    private static Method lookupMethod(Class<?> declaringClazz, String name, Class<?>[] parameterTypes, NoSuchMethodException originalException) throws NoSuchMethodException {
        try {
            Method result = declaringClazz.getDeclaredMethod(name, parameterTypes);
            Util_java_lang_invoke_MethodHandleNatives.forceAccess(result);
            return result;
        }
        catch (NoSuchMethodException e) {
            NoSuchMethodException newOriginalException;
            Class<?> superClass = declaringClazz.getSuperclass();
            NoSuchMethodException noSuchMethodException = newOriginalException = originalException == null ? e : originalException;
            if (superClass == null) {
                throw newOriginalException;
            }
            return Util_java_lang_invoke_MethodHandleNatives.lookupMethod(superClass, name, parameterTypes, newOriginalException);
        }
    }

    static Field lookupField(Class<?> declaringClazz, String name) throws NoSuchFieldException {
        return Util_java_lang_invoke_MethodHandleNatives.lookupField(declaringClazz, name, null);
    }

    private static Field lookupField(Class<?> declaringClazz, String name, NoSuchFieldException originalException) throws NoSuchFieldException {
        try {
            Field result = declaringClazz.getDeclaredField(name);
            Util_java_lang_invoke_MethodHandleNatives.forceAccess(result);
            return result;
        }
        catch (NoSuchFieldException e) {
            NoSuchFieldException newOriginalException;
            Class<?> superClass = declaringClazz.getSuperclass();
            NoSuchFieldException noSuchFieldException = newOriginalException = originalException == null ? e : originalException;
            if (superClass == null) {
                throw newOriginalException;
            }
            return Util_java_lang_invoke_MethodHandleNatives.lookupField(superClass, name, newOriginalException);
        }
    }

    private static void forceAccess(AccessibleObject target) {
        try {
            SET_ACCESSIBLE0.invoke((Object)target, true);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    public static Target_java_lang_invoke_MemberName resolve(Target_java_lang_invoke_MemberName self, Class<?> caller, boolean speculativeResolve) throws LinkageError, ClassNotFoundException {
        if (self.reflectAccess != null || self.intrinsic != null) {
            return self;
        }
        Class<?> declaringClass = self.getDeclaringClass();
        if (declaringClass == null) {
            return null;
        }
        self.intrinsic = MethodHandleIntrinsicImpl.resolve(self);
        if (self.intrinsic != null) {
            self.flags |= ((MethodHandleIntrinsicImpl)self.intrinsic).variant.flags;
            return self;
        }
        try {
            if (self.isMethod()) {
                Class<?>[] parameterTypes = self.getMethodType().parameterArray();
                Method method = Util_java_lang_invoke_MethodHandleNatives.lookupMethod(declaringClass, self.name, parameterTypes);
                if (method.getReturnType() != self.getMethodType().returnType()) {
                    throw new NoSuchMethodException(SubstrateUtil.cast(declaringClass, DynamicHub.class).methodToString(self.name, parameterTypes));
                }
                self.reflectAccess = method;
                self.flags |= method.getModifiers();
            } else if (self.isConstructor()) {
                Constructor<?> constructor = declaringClass.getDeclaredConstructor(self.getMethodType().parameterArray());
                Util_java_lang_invoke_MethodHandleNatives.forceAccess(constructor);
                self.reflectAccess = constructor;
                self.flags |= constructor.getModifiers();
            } else if (self.isField()) {
                Field field = Util_java_lang_invoke_MethodHandleNatives.lookupField(declaringClass, self.name);
                if (field.getType() != self.getFieldType()) {
                    throw new NoSuchFieldException(declaringClass.getName() + "." + self.name);
                }
                self.reflectAccess = field;
                self.flags |= field.getModifiers();
            }
            return self;
        }
        catch (NoSuchMethodException e) {
            if (speculativeResolve) {
                return null;
            }
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (NoSuchFieldException e) {
            if (speculativeResolve) {
                return null;
            }
            throw new NoSuchFieldError(e.getMessage());
        }
    }

    static boolean verifyAccess(Class<?> refc, Class<?> defc, int mods, Class<?> lookupClass, int allowedModes) {
        if (verifyAccess == null) {
            try {
                verifyAccess = VerifyAccess.class.getDeclaredMethod("isMemberAccessible", Class.class, Class.class, Integer.TYPE, Class.class, Class.class, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
        try {
            return (Boolean)verifyAccess.invoke(null, refc, defc, mods, lookupClass, null, allowedModes);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new GraalError((Throwable)e);
        }
    }
}

