/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.graal.nodes.ComputedIndirectCallTargetNode;
import com.oracle.svm.core.graal.nodes.SubstrateFieldLocationIdentity;
import com.oracle.svm.core.graal.nodes.SubstrateNarrowOopStamp;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.core.common.Fields;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.FieldLocationIdentity;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectState;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.SnippetTemplate;

public class AnalysisToHostedGraphTransplanter {
    protected final HostedUniverse universe;
    protected final CompileQueue compileQueue;

    public AnalysisToHostedGraphTransplanter(HostedUniverse universe, CompileQueue compileQueue) {
        this.universe = universe;
        this.compileQueue = compileQueue;
    }

    public StructuredGraph transplantGraph(DebugContext debug, HostedMethod hMethod, CompileQueue.CompileReason reason) {
        AnalysisMethod aMethod = hMethod.getWrapped();
        StructuredGraph aGraph = aMethod.decodeAnalyzedGraph(debug, null);
        if (aGraph == null) {
            throw VMError.shouldNotReachHere("Method not parsed during static analysis: " + aMethod.format("%r %H.%n(%p)") + ". Reachable from: " + reason);
        }
        aMethod.setAnalyzedGraph(null);
        OptionValues compileOptions = this.compileQueue.getCustomizedOptions(hMethod, debug);
        boolean trackNodeSourcePosition = (Boolean)GraalOptions.TrackNodeSourcePosition.getValue(compileOptions);
        assert (aMethod.equals((Object)aGraph.method()));
        List inlinedHMethods = null;
        if (aGraph.isRecordingInlinedMethods()) {
            inlinedHMethods = aGraph.getMethods().stream().map(m -> AnalysisToHostedGraphTransplanter.getHostedMethod(this.universe, m)).collect(Collectors.toList());
        }
        StructuredGraph graph = aGraph.copy((ResolvedJavaMethod)hMethod, inlinedHMethods, compileOptions, debug, trackNodeSourcePosition);
        this.transplantEscapeAnalysisState(graph);
        IdentityHashMap<Object, Object> replacements = new IdentityHashMap<Object, Object>();
        for (Node node : graph.getNodes()) {
            NodeClass nodeClass = node.getNodeClass();
            for (int i = 0; i < nodeClass.getData().getCount(); ++i) {
                Object newValue;
                Object oldValue = nodeClass.getData().get((Object)node, i);
                if (oldValue == (newValue = AnalysisToHostedGraphTransplanter.replaceAnalysisObjects(oldValue, node, replacements, this.universe))) continue;
                nodeClass.getData().putObjectChecked((Object)node, i, newValue);
            }
            if (trackNodeSourcePosition) {
                node.setNodeSourcePosition((NodeSourcePosition)AnalysisToHostedGraphTransplanter.replaceAnalysisObjects(node.getNodeSourcePosition(), node, replacements, this.universe));
                continue;
            }
            node.clearNodeSourcePosition();
        }
        return graph;
    }

    protected void transplantEscapeAnalysisState(StructuredGraph graph) {
        ArrayList<ValueNode> aValues;
        List values;
        for (CommitAllocationNode node : graph.getNodes().filter(CommitAllocationNode.class)) {
            values = node.getValues();
            aValues = new ArrayList<ValueNode>(values);
            values.clear();
            int aObjectStartIndex = 0;
            for (VirtualObjectNode virtualObject : node.getVirtualObjects()) {
                this.transplantVirtualObjectState(virtualObject, aValues, values, aObjectStartIndex);
                aObjectStartIndex += virtualObject.entryCount();
            }
            assert (aValues.size() == aObjectStartIndex);
        }
        for (CommitAllocationNode node : graph.getNodes().filter(VirtualObjectState.class)) {
            values = node.values();
            aValues = new ArrayList(values);
            values.clear();
            this.transplantVirtualObjectState(node.object(), aValues, values, 0);
        }
        for (CommitAllocationNode node : graph.getNodes(VirtualInstanceNode.TYPE)) {
            AnalysisType aType = (AnalysisType)node.type();
            Object[] aFields = node.getFields();
            assert (Arrays.equals(aFields, aType.getInstanceFields(true)));
            HostedField[] hFields = this.universe.lookup((JavaType)aType).getInstanceFields(true);
            Fields nodeClassDataFields = node.getNodeClass().getData();
            for (int i = 0; i < nodeClassDataFields.getCount(); ++i) {
                if (nodeClassDataFields.get((Object)node, i) != aFields) continue;
                nodeClassDataFields.putObjectChecked((Object)node, i, (Object)hFields);
            }
        }
    }

    private void transplantVirtualObjectState(VirtualObjectNode virtualObject, List<ValueNode> aValues, List<ValueNode> hValues, int aObjectStartIndex) {
        AnalysisType aType = (AnalysisType)virtualObject.type();
        if (aType.isArray()) {
            for (int i = 0; i < virtualObject.entryCount(); ++i) {
                hValues.add(aValues.get(aObjectStartIndex + i));
            }
        } else {
            HostedField[] hFields;
            assert (virtualObject.entryCount() == aType.getInstanceFields(true).length);
            for (HostedField hField : hFields = this.universe.lookup((JavaType)aType).getInstanceFields(true)) {
                int aPosition = hField.wrapped.getPosition();
                assert (hField.wrapped.equals(aType.getInstanceFields(true)[aPosition]));
                hValues.add(aValues.get(aObjectStartIndex + aPosition));
            }
        }
    }

    private static HostedMethod getHostedMethod(HostedUniverse universe, ResolvedJavaMethod method) {
        AnalysisMethod aMethod;
        if (method instanceof AnalysisMethod && !(aMethod = (AnalysisMethod)method).isOriginalMethod()) {
            AnalysisMethod aOrig = aMethod.getMultiMethod(MultiMethod.ORIGINAL_METHOD);
            assert (aOrig != null);
            HostedMethod hOrig = universe.lookup((JavaMethod)aOrig);
            HostedMethod hMethod = hOrig.getMultiMethod(aMethod.getMultiMethodKey());
            assert (hMethod != null);
            return hMethod;
        }
        return universe.lookup((JavaMethod)method);
    }

    static Object replaceAnalysisObjects(Object obj, Node node, IdentityHashMap<Object, Object> replacements, HostedUniverse hUniverse) {
        Object newReplacement;
        if (obj == null) {
            return obj;
        }
        Object existingReplacement = replacements.get(obj);
        if (existingReplacement != null) {
            return existingReplacement;
        }
        if (obj instanceof Node) {
            throw VMError.shouldNotReachHere("Must not replace a Graal graph nodes, only data objects referenced from a node");
        }
        if (obj instanceof AnalysisType) {
            newReplacement = hUniverse.lookup((JavaType)((AnalysisType)obj));
        } else if (obj instanceof AnalysisMethod) {
            newReplacement = AnalysisToHostedGraphTransplanter.getHostedMethod(hUniverse, (ResolvedJavaMethod)((AnalysisMethod)obj));
        } else if (obj instanceof AnalysisField) {
            newReplacement = hUniverse.lookup((JavaField)((AnalysisField)obj));
        } else if (obj instanceof FieldLocationIdentity) {
            ResolvedJavaField inner = ((FieldLocationIdentity)obj).getField();
            assert (inner instanceof AnalysisField);
            newReplacement = new SubstrateFieldLocationIdentity((ResolvedJavaField)AnalysisToHostedGraphTransplanter.replaceAnalysisObjects(inner, node, replacements, hUniverse), ((FieldLocationIdentity)obj).isImmutable());
        } else if (obj.getClass() == ObjectStamp.class) {
            ObjectStamp stamp = (ObjectStamp)obj;
            newReplacement = stamp.type() == null ? obj : new ObjectStamp((ResolvedJavaType)AnalysisToHostedGraphTransplanter.replaceAnalysisObjects(stamp.type(), node, replacements, hUniverse), stamp.isExactType(), stamp.nonNull(), stamp.alwaysNull(), stamp.isAlwaysArray());
        } else if (obj.getClass() == SubstrateNarrowOopStamp.class) {
            SubstrateNarrowOopStamp stamp = (SubstrateNarrowOopStamp)((Object)obj);
            newReplacement = stamp.type() == null ? obj : new SubstrateNarrowOopStamp((ResolvedJavaType)AnalysisToHostedGraphTransplanter.replaceAnalysisObjects(stamp.type(), node, replacements, hUniverse), stamp.isExactType(), stamp.nonNull(), stamp.alwaysNull(), stamp.isAlwaysArray(), stamp.getEncoding());
        } else if (obj.getClass() == PiNode.PlaceholderStamp.class) {
            assert (((PiNode.PlaceholderStamp)obj).type() == null) : "PlaceholderStamp never references a type";
            newReplacement = obj;
        } else {
            if (obj instanceof AbstractObjectStamp) {
                throw VMError.shouldNotReachHere("missing replacement of a subclass of AbstractObjectStamp: " + obj.getClass().getTypeName());
            }
            if (obj.getClass() == StampPair.class) {
                StampPair pair = (StampPair)obj;
                Stamp trustedStamp = (Stamp)AnalysisToHostedGraphTransplanter.replaceAnalysisObjects(pair.getTrustedStamp(), node, replacements, hUniverse);
                Stamp uncheckedStamp = (Stamp)AnalysisToHostedGraphTransplanter.replaceAnalysisObjects(pair.getUncheckedStamp(), node, replacements, hUniverse);
                newReplacement = trustedStamp != pair.getTrustedStamp() || uncheckedStamp != pair.getUncheckedStamp() ? StampPair.create((Stamp)trustedStamp, (Stamp)uncheckedStamp) : pair;
            } else if (obj.getClass() == ResolvedJavaMethodBytecode.class) {
                ResolvedJavaMethodBytecode bc = (ResolvedJavaMethodBytecode)obj;
                newReplacement = new ResolvedJavaMethodBytecode((ResolvedJavaMethod)AnalysisToHostedGraphTransplanter.getHostedMethod(hUniverse, bc.getMethod()), bc.getOrigin());
            } else if (obj instanceof Object[]) {
                T[] originalArray = (T[])obj;
                T[] copyArray = null;
                for (int i = 0; i < originalArray.length; ++i) {
                    Object original = originalArray[i];
                    Object replaced = AnalysisToHostedGraphTransplanter.replaceAnalysisObjects(original, node, replacements, hUniverse);
                    if (replaced == original) continue;
                    if (copyArray == null) {
                        copyArray = Arrays.copyOf(originalArray, originalArray.length);
                    }
                    copyArray[i] = replaced;
                }
                newReplacement = copyArray != null ? copyArray : originalArray;
            } else if (obj.getClass() == NodeSourcePosition.class) {
                NodeSourcePosition nsp = (NodeSourcePosition)obj;
                NodeSourcePosition replacedCaller = (NodeSourcePosition)AnalysisToHostedGraphTransplanter.replaceAnalysisObjects(nsp.getCaller(), node, replacements, hUniverse);
                ResolvedJavaMethod replacedMethod = (ResolvedJavaMethod)AnalysisToHostedGraphTransplanter.replaceAnalysisObjects(nsp.getMethod(), node, replacements, hUniverse);
                newReplacement = new NodeSourcePosition(nsp.getSourceLanguage(), replacedCaller, replacedMethod, nsp.getBCI(), nsp.getMarker());
            } else if (obj.getClass() == BytecodePosition.class) {
                BytecodePosition nsp = (BytecodePosition)obj;
                BytecodePosition replacedCaller = (BytecodePosition)AnalysisToHostedGraphTransplanter.replaceAnalysisObjects(nsp.getCaller(), node, replacements, hUniverse);
                ResolvedJavaMethod replacedMethod = (ResolvedJavaMethod)AnalysisToHostedGraphTransplanter.replaceAnalysisObjects(nsp.getMethod(), node, replacements, hUniverse);
                newReplacement = new BytecodePosition(replacedCaller, replacedMethod, nsp.getBCI());
            } else if (obj.getClass() == SubstrateMethodPointerConstant.class) {
                SubstrateMethodPointerConstant methodPointerConstant = (SubstrateMethodPointerConstant)obj;
                MethodPointer methodPointer = methodPointerConstant.pointer();
                ResolvedJavaMethod method = methodPointer.getMethod();
                ResolvedJavaMethod replacedMethod = (ResolvedJavaMethod)AnalysisToHostedGraphTransplanter.replaceAnalysisObjects(method, node, replacements, hUniverse);
                newReplacement = new SubstrateMethodPointerConstant(new MethodPointer(replacedMethod));
            } else if (obj.getClass() == ComputedIndirectCallTargetNode.FieldLoad.class) {
                ComputedIndirectCallTargetNode.FieldLoad fieldLoad = (ComputedIndirectCallTargetNode.FieldLoad)obj;
                newReplacement = new ComputedIndirectCallTargetNode.FieldLoad(hUniverse.lookup((JavaField)fieldLoad.getField()));
            } else if (obj.getClass() == ComputedIndirectCallTargetNode.FieldLoadIfZero.class) {
                ComputedIndirectCallTargetNode.FieldLoadIfZero fieldLoadIfZero = (ComputedIndirectCallTargetNode.FieldLoadIfZero)obj;
                newReplacement = new ComputedIndirectCallTargetNode.FieldLoadIfZero(fieldLoadIfZero.getObject(), hUniverse.lookup((JavaField)fieldLoadIfZero.getField()));
            } else if (obj.getClass() == SnippetTemplate.EagerSnippetInfo.class) {
                SnippetTemplate.EagerSnippetInfo info = (SnippetTemplate.EagerSnippetInfo)obj;
                newReplacement = info.copyWith((ResolvedJavaMethod)AnalysisToHostedGraphTransplanter.replaceAnalysisObjects(info.getMethod(), node, replacements, hUniverse));
            } else if (obj instanceof ImageHeapConstant) {
                newReplacement = obj;
            } else {
                assert (!obj.getClass().getName().toLowerCase().contains("analysis")) : "Object " + obj + " of " + obj.getClass() + " in node " + node;
                assert (!obj.getClass().getName().toLowerCase().contains("pointsto")) : "Object " + obj + " of " + obj.getClass() + " in node " + node;
                newReplacement = obj;
            }
        }
        replacements.put(obj, newReplacement);
        return newReplacement;
    }
}

