/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jfr;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.svm.core.jfr.JfrEventWriterAccess;
import com.oracle.svm.core.jfr.JfrJavaEvents;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import jdk.internal.event.Event;
import jdk.internal.misc.Unsafe;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.SecuritySupport;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class JfrEventSubstitution
extends SubstitutionProcessor {
    private final ResolvedJavaType baseEventType;
    private final ConcurrentHashMap<ResolvedJavaType, Boolean> typeSubstitution;
    private final ConcurrentHashMap<ResolvedJavaMethod, ResolvedJavaMethod> methodSubstitutions;
    private final ConcurrentHashMap<ResolvedJavaField, ResolvedJavaField> fieldSubstitutions;
    private final EconomicMap<String, Class<? extends jdk.jfr.Event>> mirrorEventMapping;

    JfrEventSubstitution(MetaAccessProvider metaAccess) {
        this.baseEventType = metaAccess.lookupJavaType(Event.class);
        ResolvedJavaType jdkJfrEventWriter = metaAccess.lookupJavaType(JfrEventWriterAccess.getEventWriterClass());
        JfrEventSubstitution.changeWriterResetMethod(jdkJfrEventWriter);
        this.typeSubstitution = new ConcurrentHashMap();
        this.methodSubstitutions = new ConcurrentHashMap();
        this.fieldSubstitutions = new ConcurrentHashMap();
        this.mirrorEventMapping = JfrEventSubstitution.createMirrorEventsMapping();
    }

    public ResolvedJavaField lookup(ResolvedJavaField field) {
        ResolvedJavaType type = field.getDeclaringClass();
        if (this.needsClassRedefinition(type)) {
            this.typeSubstitution.computeIfAbsent(type, this::initEventClass);
            return this.fieldSubstitutions.computeIfAbsent(field, JfrEventSubstitution::initEventField);
        }
        return field;
    }

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        ResolvedJavaType type = method.getDeclaringClass();
        if (this.needsClassRedefinition(type)) {
            this.typeSubstitution.computeIfAbsent(type, this::initEventClass);
            return this.methodSubstitutions.computeIfAbsent(method, JfrEventSubstitution::initEventMethod);
        }
        return method;
    }

    public ResolvedJavaType lookup(ResolvedJavaType type) {
        if (this.needsClassRedefinition(type)) {
            this.typeSubstitution.computeIfAbsent(type, this::initEventClass);
        }
        return type;
    }

    private static ResolvedJavaField initEventField(ResolvedJavaField oldField) throws RuntimeException {
        ResolvedJavaType type = oldField.getDeclaringClass();
        if (oldField.isStatic()) {
            for (ResolvedJavaField field : type.getStaticFields()) {
                if (!field.getName().equals(oldField.getName())) continue;
                return field;
            }
        } else {
            for (ResolvedJavaField field : type.getInstanceFields(false)) {
                if (!field.getName().equals(oldField.getName())) continue;
                return field;
            }
        }
        throw VMError.shouldNotReachHere("Could not re-resolve field: " + oldField);
    }

    private static ResolvedJavaMethod initEventMethod(ResolvedJavaMethod oldMethod) throws RuntimeException {
        ResolvedJavaMethod newMethod;
        ResolvedJavaType type = oldMethod.getDeclaringClass();
        String name = oldMethod.getName();
        Signature signature = oldMethod.getSignature();
        if (name.equals("<clinit>")) {
            return type.getClassInitializer();
        }
        if (name.equals("<init>")) {
            for (ResolvedJavaMethod m : type.getDeclaredConstructors(false)) {
                if (!m.getName().equals(name) || !m.getSignature().equals(signature)) continue;
                return m;
            }
        }
        if ((newMethod = type.findMethod(name, signature)) != null) {
            return newMethod;
        }
        throw VMError.shouldNotReachHere("Could not re-resolve method: " + oldMethod);
    }

    private Boolean initEventClass(ResolvedJavaType eventType) throws RuntimeException {
        try {
            Class<Event> newEventClass = OriginalClassProvider.getJavaClass((ResolvedJavaType)eventType).asSubclass(Event.class);
            eventType.initialize();
            Class mirrorEventClass = (Class)this.mirrorEventMapping.get((Object)newEventClass.getName());
            if (mirrorEventClass != null) {
                SecuritySupport.registerMirror(mirrorEventClass);
            }
            SecuritySupport.registerEvent(newEventClass);
            JfrJavaEvents.registerEventClass(newEventClass);
            JVM.getJVM().retransformClasses(new Class[]{newEventClass});
            return Boolean.TRUE;
        }
        catch (Throwable ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private boolean needsClassRedefinition(ResolvedJavaType type) {
        return !type.isAbstract() && this.baseEventType.isAssignableFrom(type) && !this.baseEventType.equals(type);
    }

    private static void changeWriterResetMethod(ResolvedJavaType eventWriterType) {
        for (ResolvedJavaMethod m : eventWriterType.getDeclaredMethods(false)) {
            if (!m.getName().equals("reset")) continue;
            JfrEventSubstitution.setPublicModifier(m);
        }
    }

    private static void setPublicModifier(ResolvedJavaMethod m) {
        try {
            Class<?> hotspotMethodClass = m.getClass();
            Method metaspaceMethodM = JfrEventSubstitution.getMethodToFetchMetaspaceMethod(hotspotMethodClass);
            metaspaceMethodM.setAccessible(true);
            long metaspaceMethod = (Long)metaspaceMethodM.invoke((Object)m, new Object[0]);
            VMError.guarantee(metaspaceMethod != 0L);
            Class<?> hotSpotVMConfigC = Class.forName("jdk.vm.ci.hotspot.HotSpotVMConfig");
            Method configM = hotSpotVMConfigC.getDeclaredMethod("config", new Class[0]);
            configM.setAccessible(true);
            Field methodAccessFlagsOffsetF = hotSpotVMConfigC.getDeclaredField("methodAccessFlagsOffset");
            methodAccessFlagsOffsetF.setAccessible(true);
            Object hotSpotVMConfig = configM.invoke(null, new Object[0]);
            int methodAccessFlagsOffset = methodAccessFlagsOffsetF.getInt(hotSpotVMConfig);
            int modifiers = Unsafe.getUnsafe().getInt(metaspaceMethod + (long)methodAccessFlagsOffset);
            int newModifiers = modifiers & 0xFFFFFFFD | 1;
            Unsafe.getUnsafe().putInt(metaspaceMethod + (long)methodAccessFlagsOffset, newModifiers);
        }
        catch (Exception ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private static Method getMethodToFetchMetaspaceMethod(Class<?> method) throws NoSuchMethodException {
        try {
            return method.getDeclaredMethod("getMethodPointer", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                return method.getDeclaredMethod("getMetaspaceMethod", new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                return method.getDeclaredMethod("getMetaspacePointer", new Class[0]);
            }
        }
    }

    private static EconomicMap<String, Class<? extends jdk.jfr.Event>> createMirrorEventsMapping() {
        EconomicMap result = EconomicMap.create();
        Class mirrorEventAnnotationClass = ReflectionUtil.lookupClass((boolean)false, (String)"jdk.jfr.internal.MirrorEvent");
        Class jdkEventsClass = ReflectionUtil.lookupClass((boolean)false, (String)"jdk.jfr.internal.instrument.JDKEvents");
        Class[] mirrorEventClasses = (Class[])ReflectionUtil.readStaticField((Class)jdkEventsClass, (String)"mirrorEventClasses");
        for (int i = 0; i < mirrorEventClasses.length; ++i) {
            Class mirrorEventClass = mirrorEventClasses[i];
            Annotation mirrorEvent = AnnotationAccess.getAnnotation((AnnotatedElement)mirrorEventClass, (Class)mirrorEventAnnotationClass);
            Method m = ReflectionUtil.lookupMethod((Class)mirrorEventAnnotationClass, (String)"className", (Class[])new Class[0]);
            try {
                String className = (String)m.invoke((Object)mirrorEvent, new Object[0]);
                result.put((Object)className, (Object)mirrorEventClass);
                continue;
            }
            catch (Exception e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
        return result;
    }
}

