/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.snippets.CEntryPointListener;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticallyRegisteredImageSingleton
public class CEntryPointListenerSupport {
    @Fold
    public static CEntryPointListenerSupport singleton() {
        return (CEntryPointListenerSupport)ImageSingletons.lookup(CEntryPointListenerSupport.class);
    }

    @Fold
    public static boolean isInstalled() {
        return ImageSingletons.contains(CEntryPointListener.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void beforeThreadAttach() {
        if (CEntryPointListenerSupport.isInstalled()) {
            CEntryPointListener.singleton().beforeThreadAttach();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void afterThreadAttach() {
        if (CEntryPointListenerSupport.isInstalled()) {
            CEntryPointListener.singleton().afterThreadAttach();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void errorThreadAttach(int error) {
        if (CEntryPointListenerSupport.isInstalled()) {
            CEntryPointListener.singleton().errorThreadAttach(error);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void beforeThreadDetach() {
        if (CEntryPointListenerSupport.isInstalled()) {
            CEntryPointListener.singleton().beforeThreadDetach();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void afterThreadDetach() {
        if (CEntryPointListenerSupport.isInstalled()) {
            CEntryPointListener.singleton().afterThreadDetach();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void errorThreadDetach(int error) {
        if (CEntryPointListenerSupport.isInstalled()) {
            CEntryPointListener.singleton().errorThreadDetach(error);
        }
    }
}

