/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.AnnotateOriginal;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK20OrEarlier;
import com.oracle.svm.core.jdk.JDK20OrLater;
import com.oracle.svm.core.jdk.JDK21OrLater;
import com.oracle.svm.core.jdk.LoomJDK;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_ContinuationScope;
import com.oracle.svm.core.thread.Target_sun_nio_ch_Interruptible;
import com.oracle.svm.core.thread.VirtualThreadHelper;
import com.oracle.svm.core.util.VMError;
import java.util.Locale;
import java.util.concurrent.Executor;

@TargetClass(className="java.lang.VirtualThread", onlyWith={LoomJDK.class})
public final class Target_java_lang_VirtualThread {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    @TargetElement(onlyWith={JDK20OrEarlier.class})
    private static boolean notifyJvmtiEvents;
    @Alias
    static int NEW;
    @Alias
    static int STARTED;
    @Alias
    static int RUNNABLE;
    @Alias
    static int RUNNING;
    @Alias
    static int PARKING;
    @Alias
    static int PARKED;
    @Alias
    static int PINNED;
    @Alias
    static int YIELDING;
    @Alias
    static int TERMINATED;
    @Alias
    static int RUNNABLE_SUSPENDED;
    @Alias
    static int PARKED_SUSPENDED;
    @Alias
    static Target_jdk_internal_vm_ContinuationScope VTHREAD_SCOPE;
    @Alias
    Executor scheduler;
    @Alias
    volatile Thread carrierThread;
    @Alias
    volatile Target_sun_nio_ch_Interruptible nioBlocker;
    @Alias
    volatile boolean interrupted;

    @Substitute
    private static void registerNatives() {
    }

    @Substitute
    @TargetElement(onlyWith={JDK21OrLater.class})
    private void notifyJvmtiStart() {
    }

    @Substitute
    @TargetElement(onlyWith={JDK21OrLater.class})
    private void notifyJvmtiEnd() {
    }

    @Substitute
    @TargetElement(onlyWith={JDK21OrLater.class})
    private void notifyJvmtiMount(boolean hide) {
    }

    @Substitute
    @TargetElement(onlyWith={JDK21OrLater.class})
    private void notifyJvmtiUnmount(boolean hide) {
    }

    @Substitute
    @TargetElement(onlyWith={JDK21OrLater.class})
    private void notifyJvmtiHideFrames(boolean hide) {
    }

    @Substitute
    @TargetElement(onlyWith={JDK20OrLater.class, JDK20OrEarlier.class}, name="notifyJvmtiHideFrames")
    private void notifyJvmtiHideFramesJDK20(boolean hide) {
        throw VMError.shouldNotReachHereSubstitution();
    }

    @Alias
    public static native Target_jdk_internal_vm_ContinuationScope continuationScope();

    @Alias
    native boolean joinNanos(long var1) throws InterruptedException;

    @Delete
    native StackTraceElement[] asyncGetStackTrace();

    @Alias
    native StackTraceElement[] tryGetStackTrace();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    boolean getAndClearInterrupt() {
        assert (Thread.currentThread() == SubstrateUtil.cast(this, Object.class));
        Object token = VirtualThreadHelper.acquireInterruptLockMaybeSwitch(this);
        try {
            boolean oldValue = this.interrupted;
            if (oldValue) {
                this.interrupted = false;
            }
            VirtualThreadHelper.asTarget(this.carrierThread).clearInterrupt();
            boolean bl = oldValue;
            return bl;
        }
        finally {
            VirtualThreadHelper.releaseInterruptLockMaybeSwitchBack(this, token);
        }
    }

    @Alias
    private native void setCarrierThread(Target_java_lang_Thread var1);

    @Substitute
    void mount() {
        Target_java_lang_Thread carrier = VirtualThreadHelper.asTarget(Target_java_lang_Thread.currentCarrierThread());
        this.setCarrierThread(carrier);
        if (this.interrupted) {
            carrier.setInterrupt();
        } else if (carrier.isInterrupted()) {
            Object token = VirtualThreadHelper.acquireInterruptLockMaybeSwitch(this);
            try {
                if (!this.interrupted) {
                    carrier.clearInterrupt();
                }
            }
            finally {
                VirtualThreadHelper.releaseInterruptLockMaybeSwitchBack(this, token);
            }
        }
        carrier.setCurrentThread(VirtualThreadHelper.asThread(this));
        if (HasJfrSupport.get()) {
            SubstrateJVM.getThreadRepo().registerThread(VirtualThreadHelper.asThread(this));
        }
    }

    @Substitute
    void unmount() {
        Target_java_lang_Thread carrier = VirtualThreadHelper.asTarget(this.carrierThread);
        carrier.setCurrentThread(VirtualThreadHelper.asThread(carrier));
        Object token = VirtualThreadHelper.acquireInterruptLockMaybeSwitch(this);
        try {
            this.setCarrierThread(null);
        }
        finally {
            VirtualThreadHelper.releaseInterruptLockMaybeSwitchBack(this, token);
        }
        carrier.clearInterrupt();
    }

    @Alias
    native int state();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    Thread.State threadState() {
        int state = this.state();
        if (state == NEW) {
            return Thread.State.NEW;
        }
        if (state == STARTED) {
            if (VirtualThreadHelper.asTarget(this).threadContainer() == null) {
                return Thread.State.NEW;
            }
            return Thread.State.RUNNABLE;
        }
        if (state == RUNNABLE || state == RUNNABLE_SUSPENDED) {
            return Thread.State.RUNNABLE;
        }
        if (state == RUNNING) {
            Object token = VirtualThreadHelper.acquireInterruptLockMaybeSwitch(this);
            try {
                Thread carrier = this.carrierThread;
                if (carrier != null) {
                    Thread.State state2 = VirtualThreadHelper.asTarget(carrier).threadState();
                    return state2;
                }
            }
            finally {
                VirtualThreadHelper.releaseInterruptLockMaybeSwitchBack(this, token);
            }
            return Thread.State.RUNNABLE;
        }
        if (state == PARKING || state == YIELDING) {
            return Thread.State.RUNNABLE;
        }
        if (state == PARKED || state == PARKED_SUSPENDED || state == PINNED) {
            int parkedThreadStatus = MonitorSupport.singleton().getParkedThreadStatus(VirtualThreadHelper.asThread(this), false);
            switch (parkedThreadStatus) {
                case 1025: {
                    return Thread.State.BLOCKED;
                }
                case 401: 
                case 657: {
                    return Thread.State.WAITING;
                }
            }
            throw VMError.shouldNotReachHereUnexpectedInput(parkedThreadStatus);
        }
        if (state == TERMINATED) {
            return Thread.State.TERMINATED;
        }
        throw new InternalError();
    }

    @AnnotateOriginal
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    native boolean isTerminated();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    public String toString() {
        StringBuilder sb = new StringBuilder("VirtualThread[#");
        sb.append(VirtualThreadHelper.asTarget(this).threadId());
        String name = VirtualThreadHelper.asThread(this).getName();
        if (!name.isEmpty()) {
            sb.append(",");
            sb.append(name);
        }
        sb.append("]/");
        Thread carrier = this.carrierThread;
        if (carrier != null) {
            Object token = VirtualThreadHelper.acquireInterruptLockMaybeSwitch(this);
            try {
                carrier = this.carrierThread;
                if (carrier != null) {
                    String stateAsString = VirtualThreadHelper.asTarget(carrier).threadState().toString();
                    sb.append(stateAsString.toLowerCase(Locale.ROOT));
                    sb.append('@');
                    sb.append(carrier.getName());
                }
            }
            finally {
                VirtualThreadHelper.releaseInterruptLockMaybeSwitchBack(this, token);
            }
        }
        if (carrier == null) {
            String stateAsString = this.threadState().toString();
            sb.append(stateAsString.toLowerCase(Locale.ROOT));
        }
        return sb.toString();
    }

    @Alias
    native void interrupt();

    @Alias
    native void unpark();
}

