/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.hosted.RuntimeCompilationFeature;
import com.oracle.svm.graal.hosted.RuntimeStrengthenStampsPhase;
import com.oracle.svm.graal.meta.SubstrateMethod;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.HeapBreakdownProvider;
import com.oracle.svm.hosted.code.DeoptimizationUtils;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.phases.SubstrateGraphBuilderPhase;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphEncoder;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.IterativeConditionalEliminationPhase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.truffle.compiler.phases.DeoptimizeOnExceptionPhase;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public class LegacyRuntimeCompilationFeature
extends RuntimeCompilationFeature
implements Feature {
    protected Map<AnalysisMethod, CallTreeNode> runtimeCompiledMethodMap;
    protected Set<RuntimeCompilationFeature.RuntimeCompilationCandidate> runtimeCompilationCandidates;

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return RuntimeCompilationFeature.getRequiredFeaturesHelper();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        VMError.guarantee(SubstrateOptions.ParseOnceJIT.getValue() == false, "This feature is only supported when ParseOnceJIT is not set");
        ImageSingletons.add(RuntimeCompilationFeature.class, (Object)this);
    }

    public void duringSetup(Feature.DuringSetupAccess c) {
        super.duringSetupHelper(c);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess c) {
        super.beforeAnalysisHelper(c);
        this.runtimeCompiledMethodMap = new LinkedHashMap<AnalysisMethod, CallTreeNode>();
        this.runtimeCompilationCandidates = new HashSet<RuntimeCompilationFeature.RuntimeCompilationCandidate>();
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess c) {
        NodeClass[] nodeClasses;
        FeatureImpl.DuringAnalysisAccessImpl config = (FeatureImpl.DuringAnalysisAccessImpl)c;
        ArrayDeque<CallTreeNode> worklist = new ArrayDeque<CallTreeNode>();
        worklist.addAll(this.runtimeCompiledMethodMap.values());
        while (!worklist.isEmpty()) {
            this.processMethod((CallTreeNode)worklist.removeFirst(), worklist, config.getBigBang());
        }
        SubstrateMethod[] methodsToCompileArr = new SubstrateMethod[this.runtimeCompiledMethodMap.size()];
        int idx = 0;
        for (CallTreeNode node : this.runtimeCompiledMethodMap.values()) {
            methodsToCompileArr[idx++] = this.objectReplacer.createMethod((ResolvedJavaMethod)node.getImplementationMethod());
        }
        if (GraalSupport.setMethodsToCompile(config, methodsToCompileArr)) {
            config.requireAnalysisIteration();
        }
        this.graphEncoder.finishPrepare();
        AnalysisMetaAccess metaAccess = config.getMetaAccess();
        for (NodeClass nodeClass : nodeClasses = this.graphEncoder.getNodeClasses()) {
            metaAccess.lookupJavaType(nodeClass.getClazz()).registerAsAllocated((Object)("All " + NodeClass.class.getName() + " classes are marked as instantiated eagerly."));
        }
        if (GraalSupport.setGraphEncoding(config, this.graphEncoder.getEncoding(), this.graphEncoder.getObjects(), nodeClasses)) {
            config.requireAnalysisIteration();
        }
    }

    private void processMethod(CallTreeNode node, Deque<CallTreeNode> worklist, BigBang bb) {
        AnalysisMethod method = node.getImplementationMethod();
        assert (method.isImplementationInvoked());
        if (node.graph == null) {
            if (method.getAnnotation(Fold.class) != null || method.getAnnotation(Node.NodeIntrinsic.class) != null) {
                throw VMError.shouldNotReachHere("Parsing method annotated with @Fold or @NodeIntrinsic: " + method.format("%H.%n(%p)"));
            }
            if (!method.allowRuntimeCompilation()) {
                throw VMError.shouldNotReachHere("Parsing method that is not available for runtime compilation: " + method.format("%H.%n(%p)"));
            }
            boolean parse = false;
            DebugContext debug = bb.getDebug();
            StructuredGraph graph = method.buildGraph(debug, (ResolvedJavaMethod)method, this.hostedProviders, GraphProvider.Purpose.PREPARE_RUNTIME_COMPILATION);
            if (graph == null) {
                if (!method.hasBytecodes()) {
                    return;
                }
                parse = true;
                graph = new StructuredGraph.Builder(debug.getOptions(), debug, StructuredGraph.AllowAssumptions.YES).method((ResolvedJavaMethod)method).recordInlinedMethods(true).build();
            }
            try (DebugContext.Scope scope = debug.scope((Object)"RuntimeCompile", (Object)graph);){
                if (parse) {
                    RuntimeGraphBuilderPhase builderPhase = new RuntimeGraphBuilderPhase((Providers)this.hostedProviders, this.graphBuilderConfig, this.optimisticOpts, null, this.hostedProviders.getWordTypes());
                    builderPhase.apply(graph);
                }
                if (graph.getNodes(StackValueNode.TYPE).isNotEmpty()) {
                    return;
                }
                CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
                canonicalizer.apply(graph, (Object)this.hostedProviders);
                if (this.deoptimizeOnExceptionPredicate != null) {
                    new DeoptimizeOnExceptionPhase(this.deoptimizeOnExceptionPredicate).apply(graph);
                }
                new ConvertDeoptimizeToGuardPhase(canonicalizer).apply(graph, (Object)this.hostedProviders);
                this.graphEncoder.prepare(graph);
                node.graph = graph;
                assert (RuntimeCompilationFeature.verifyNodes(graph));
            }
            catch (Throwable ex) {
                debug.handle(ex);
            }
        }
        assert (node.graph != null);
        List callTargets = node.graph.getNodes(MethodCallTargetNode.TYPE).snapshot();
        callTargets.sort(Comparator.comparingInt(t -> t.invoke().bci()));
        for (MethodCallTargetNode targetNode : callTargets) {
            Collection<Object> allImplementationMethods;
            AnalysisMethod targetMethod = (AnalysisMethod)targetNode.targetMethod();
            ResolvedJavaMethod callerMethod = targetNode.invoke().stateAfter().getMethod();
            if (callerMethod instanceof PointsToAnalysisMethod) {
                PointsToAnalysisMethod pointToCalledMethod = (PointsToAnalysisMethod)callerMethod;
                InvokeTypeFlow invokeFlow = (InvokeTypeFlow)pointToCalledMethod.getTypeFlow().getInvokes().get((Object)targetNode.invoke().bci());
                if (invokeFlow == null) continue;
                allImplementationMethods = invokeFlow.getOriginalCallees();
            } else {
                allImplementationMethods = Arrays.asList(method.getImplementations());
            }
            if (allImplementationMethods.size() == 0) {
                node.unreachableInvokes.add(targetNode.invoke());
            } else {
                node.unreachableInvokes.remove(targetNode.invoke());
            }
            if (allImplementationMethods.size() <= 0) continue;
            ArrayList<AnalysisMethod> implementationMethods = new ArrayList<AnalysisMethod>(allImplementationMethods);
            implementationMethods.sort(Comparator.comparing(AnalysisMethod::getQualifiedName));
            String sourceReference = LegacyRuntimeCompilationFeature.buildSourceReference(targetNode.invoke().stateAfter());
            for (AnalysisMethod implementationMethod : implementationMethods) {
                CallTreeNode calleeNode = new CallTreeNode(implementationMethod, targetMethod, node, sourceReference);
                boolean added = this.runtimeCompilationCandidates.add(calleeNode);
                if (added) {
                    calleeNode.linkAsChild();
                }
                if (this.runtimeCompiledMethodMap.containsKey(implementationMethod)) continue;
                if (this.runtimeCompilationCandidatePredicate.allowRuntimeCompilation((ResolvedJavaMethod)implementationMethod)) {
                    assert (!this.runtimeCompiledMethodMap.containsKey(implementationMethod));
                    this.runtimeCompiledMethodMap.put(implementationMethod, calleeNode);
                    worklist.add(calleeNode);
                    this.objectReplacer.createMethod((ResolvedJavaMethod)implementationMethod);
                }
                SubstrateCompilationDirectives.singleton().registerForcedCompilation((ResolvedJavaMethod)implementationMethod);
            }
        }
    }

    @Override
    protected RuntimeCompilationFeature.AbstractCallTreeNode getCallTreeNode(RuntimeCompilationFeature.RuntimeCompilationCandidate candidate) {
        assert (candidate != null);
        return (CallTreeNode)candidate;
    }

    @Override
    protected CallTreeNode getCallTreeNode(RuntimeCompilationFeature.RuntimeCompiledMethod method) {
        assert (method != null);
        return (CallTreeNode)method;
    }

    @Override
    protected RuntimeCompilationFeature.AbstractCallTreeNode getCallTreeNode(ResolvedJavaMethod method) {
        AnalysisMethod aMethod = method instanceof HostedMethod ? ((HostedMethod)method).getWrapped() : (AnalysisMethod)method;
        CallTreeNode result = this.runtimeCompiledMethodMap.get(aMethod);
        assert (result != null);
        return result;
    }

    @Override
    public Collection<RuntimeCompilationFeature.RuntimeCompiledMethod> getRuntimeCompiledMethods() {
        return Collections.unmodifiableCollection(this.runtimeCompiledMethodMap.values());
    }

    @Override
    public Collection<RuntimeCompilationFeature.RuntimeCompilationCandidate> getAllRuntimeCompilationCandidates() {
        return this.runtimeCompilationCandidates;
    }

    private static String buildSourceReference(FrameState startState) {
        StringBuilder sourceReferenceBuilder = new StringBuilder();
        for (FrameState state = startState; state != null; state = state.outerFrameState()) {
            if (sourceReferenceBuilder.length() > 0) {
                sourceReferenceBuilder.append(" -> ");
            }
            sourceReferenceBuilder.append(state.getCode().asStackTraceElement(state.bci).toString());
        }
        return sourceReferenceBuilder.toString();
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        super.afterAnalysisHelper();
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess c) {
        super.beforeCompilationHelper();
        FeatureImpl.CompilationAccessImpl config = (FeatureImpl.CompilationAccessImpl)c;
        this.graphEncoder = new GraphEncoder(ConfigurationValues.getTarget().arch);
        RuntimeStrengthenStampsPhase strengthenStamps = new RuntimeStrengthenStampsPhase(config.getUniverse(), this.objectReplacer);
        CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
        IterativeConditionalEliminationPhase conditionalElimination = new IterativeConditionalEliminationPhase(canonicalizer, true);
        ConvertDeoptimizeToGuardPhase convertDeoptimizeToGuard = new ConvertDeoptimizeToGuardPhase(canonicalizer);
        for (CallTreeNode node : this.runtimeCompiledMethodMap.values()) {
            StructuredGraph graph = node.getGraph();
            if (graph == null) continue;
            DebugContext debug = graph.getDebug();
            try {
                DebugContext.Scope scope = debug.scope((Object)"RuntimeOptimize", (Object)graph);
                try {
                    LegacyRuntimeCompilationFeature.removeUnreachableInvokes(node);
                    strengthenStamps.apply(graph);
                    canonicalizer.apply(graph, (Object)this.hostedProviders);
                    conditionalElimination.apply(graph, (Object)this.hostedProviders);
                    convertDeoptimizeToGuard.apply(graph, (Object)this.hostedProviders);
                    this.graphEncoder.prepare(graph);
                    assert (RuntimeCompilationFeature.verifyNodes(graph));
                }
                finally {
                    if (scope == null) continue;
                    scope.close();
                }
            }
            catch (Throwable ex) {
                debug.handle(ex);
            }
        }
        this.graphEncoder.finishPrepare();
        Iterator<CallTreeNode> iterator = this.runtimeCompiledMethodMap.values().iterator();
        while (iterator.hasNext()) {
            CallTreeNode node;
            CallTreeNode callTreeNode = node = iterator.next();
            if (callTreeNode.graph == null) continue;
            DeoptimizationUtils.registerDeoptEntries(callTreeNode.graph, callTreeNode.getLevel() == 0, m -> m);
            long startOffset = this.graphEncoder.encode(callTreeNode.graph);
            this.objectReplacer.createMethod((ResolvedJavaMethod)callTreeNode.getImplementationMethod()).setEncodedGraphStartOffset(startOffset);
            callTreeNode.graph = null;
        }
        HeapBreakdownProvider.singleton().setGraphEncodingByteLength(this.graphEncoder.getEncoding().length);
        GraalSupport.setGraphEncoding(config, this.graphEncoder.getEncoding(), this.graphEncoder.getObjects(), this.graphEncoder.getNodeClasses());
        this.objectReplacer.setMethodsImplementations();
        this.graphEncoder = null;
    }

    private static void removeUnreachableInvokes(CallTreeNode node) {
        for (Invoke invoke : node.unreachableInvokes) {
            if (!invoke.asNode().isAlive()) continue;
            if (invoke.callTarget().invokeKind().hasReceiver()) {
                InliningUtil.nonNullReceiver((Invoke)invoke);
            }
            FixedGuardNode guard = new FixedGuardNode((LogicNode)LogicConstantNode.forBoolean((boolean)true, (Graph)node.graph), DeoptimizationReason.UnreachedCode, DeoptimizationAction.None, true);
            node.graph.addBeforeFixed(invoke.asFixedNode(), (FixedWithNextNode)node.graph.add((Node)guard));
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess a) {
        super.afterCompilationHelper(a);
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess a) {
        super.afterHeapLayoutHelper(a);
    }

    @Override
    public SubstrateMethod prepareMethodForRuntimeCompilation(ResolvedJavaMethod method, FeatureImpl.BeforeAnalysisAccessImpl config) {
        AnalysisMethod aMethod = (AnalysisMethod)method;
        SubstrateMethod sMethod = this.objectReplacer.createMethod((ResolvedJavaMethod)aMethod);
        if (!this.runtimeCompiledMethodMap.containsKey(aMethod)) {
            this.runtimeCompiledMethodMap.put(aMethod, new CallTreeNode(aMethod, aMethod, null, ""));
            config.registerAsRoot(aMethod, true, "Runtime compilation, registered in " + LegacyRuntimeCompilationFeature.class, new MultiMethod.MultiMethodKey[0]);
        }
        return sMethod;
    }

    @Override
    protected void requireFrameInformationForMethodHelper(AnalysisMethod aMethod) {
        SubstrateCompilationDirectives.singleton().registerFrameInformationRequired(aMethod, aMethod);
    }

    @Override
    public void initializeAnalysisProviders(BigBang bb, Function<ConstantFieldProvider, ConstantFieldProvider> generator) {
    }

    @Override
    public void registerAllowInliningPredicate(RuntimeCompilationFeature.AllowInliningPredicate predicate) {
    }

    private static final class CallTreeNode
    extends RuntimeCompilationFeature.AbstractCallTreeNode
    implements RuntimeCompilationFeature.RuntimeCompiledMethod,
    RuntimeCompilationFeature.RuntimeCompilationCandidate {
        final String sourceReference;
        StructuredGraph graph;
        final Set<Invoke> unreachableInvokes;

        CallTreeNode(AnalysisMethod implementationMethod, AnalysisMethod targetMethod, CallTreeNode parent, String sourceReference) {
            super(parent, targetMethod, implementationMethod);
            this.sourceReference = sourceReference;
            this.unreachableInvokes = new HashSet<Invoke>();
        }

        @Override
        public String getPosition() {
            return this.sourceReference;
        }

        @Override
        public int getNodeCount() {
            return this.graph == null ? -1 : this.graph.getNodeCount();
        }

        private StructuredGraph getGraph() {
            return this.graph;
        }

        @Override
        public AnalysisMethod getMethod() {
            return this.getImplementationMethod();
        }

        @Override
        public Collection<ResolvedJavaMethod> getInlinedMethods() {
            return this.graph == null ? List.of() : this.graph.getMethods();
        }

        @Override
        public Collection<ResolvedJavaMethod> getInvokeTargets() {
            if (this.graph != null) {
                return this.graph.getNodes(MethodCallTargetNode.TYPE).stream().map(CallTargetNode::targetMethod).collect(Collectors.toUnmodifiableList());
            }
            return List.of();
        }
    }

    public static class RuntimeGraphBuilderPhase
    extends SubstrateGraphBuilderPhase {
        RuntimeGraphBuilderPhase(Providers providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext, WordTypes wordTypes) {
            super((CoreProviders)providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext, wordTypes);
        }

        @Override
        protected BytecodeParser createBytecodeParser(StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
            return new RuntimeBytecodeParser(this, graph, parent, method, entryBCI, intrinsicContext);
        }
    }

    public static class RuntimeBytecodeParser
    extends SubstrateGraphBuilderPhase.SubstrateBytecodeParser {
        RuntimeBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
            super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext, false);
        }

        protected boolean tryInvocationPlugin(CallTargetNode.InvokeKind invokeKind, ValueNode[] args, ResolvedJavaMethod targetMethod, JavaKind resultType) {
            boolean result = super.tryInvocationPlugin(invokeKind, args, targetMethod, resultType);
            if (result) {
                SubstrateCompilationDirectives.singleton().registerAsDeoptInlininingExclude(targetMethod);
            }
            return result;
        }

        @Override
        protected boolean shouldVerifyFrameStates() {
            return false;
        }
    }
}

