/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.nodes.DeoptEntryNode;
import com.oracle.svm.core.graal.nodes.DeoptEntrySupport;
import com.oracle.svm.core.graal.nodes.DeoptProxyAnchorNode;
import com.oracle.svm.core.graal.nodes.InlinedInvokeArgumentsNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.hosted.RuntimeCompilationFeature;
import com.oracle.svm.graal.meta.SubstrateMethod;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.HeapBreakdownProvider;
import com.oracle.svm.hosted.RuntimeCompilationSupport;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.analysis.SVMParsingSupport;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.code.DeoptimizationUtils;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.nodes.DeoptProxyNode;
import com.oracle.svm.hosted.phases.AnalysisGraphBuilderPhase;
import com.oracle.svm.hosted.phases.ConstantFoldLoadFieldPlugin;
import com.oracle.svm.hosted.phases.InlineBeforeAnalysisPolicyUtils;
import com.oracle.svm.hosted.phases.StrengthenStampsPhase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.BytecodeParserOptions;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphEncoder;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.IterativeConditionalEliminationPhase;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.truffle.compiler.phases.DeoptimizeOnExceptionPhase;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public class ParseOnceRuntimeCompilationFeature
extends RuntimeCompilationFeature
implements Feature,
RuntimeCompilationSupport {
    private final Set<AnalysisMethod> registeredRuntimeCompilations = ConcurrentHashMap.newKeySet();
    private final Set<SubstrateMethod> substrateAnalysisMethods = ConcurrentHashMap.newKeySet();
    private final Map<AnalysisMethod, String> invalidForRuntimeCompilation = new ConcurrentHashMap<AnalysisMethod, String>();
    private final Set<RuntimeCompilationFeature.RuntimeCompilationCandidate> runtimeCompilationCandidates = ConcurrentHashMap.newKeySet();
    private Set<RuntimeCompilationFeature.RuntimeCompiledMethod> runtimeCompilations = null;
    private Map<RuntimeCompilationFeature.RuntimeCompilationCandidate, CallTreeNode> runtimeCandidateCallTree = null;
    private Map<AnalysisMethod, CallTreeNode> runtimeCompiledMethodCallTree = null;
    private HostedProviders analysisProviders = null;
    private RuntimeCompilationFeature.AllowInliningPredicate allowInliningPredicate = (builder, target) -> RuntimeCompilationFeature.AllowInliningPredicate.InlineDecision.INLINING_DISALLOWED;
    private boolean allowInliningPredicateUpdated = false;
    boolean newRuntimeMethodsSeen = false;
    public Set<ResolvedJavaMethod> parsedRuntimeMethods = ConcurrentHashMap.newKeySet();
    public AtomicLong totalParsedRuntimeMethods = new AtomicLong();
    public Set<ResolvedJavaMethod> parsedDeoptMethods = ConcurrentHashMap.newKeySet();
    public AtomicLong totalParsedDeoptMethods = new AtomicLong();
    private final Map<HostedMethod, StructuredGraph> runtimeGraphs = new ConcurrentHashMap<HostedMethod, StructuredGraph>();

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return RuntimeCompilationFeature.getRequiredFeaturesHelper();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(SVMParsingSupport.class, (Object)new RuntimeCompilationParsingSupport());
        ImageSingletons.add(HostVM.MultiMethodAnalysisPolicy.class, (Object)new RuntimeCompilationAnalysisPolicy());
        ImageSingletons.add(RuntimeCompilationFeature.class, (Object)this);
        ImageSingletons.add(RuntimeCompilationSupport.class, (Object)this);
    }

    public void duringSetup(Feature.DuringSetupAccess c) {
        this.duringSetupHelper(c);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess c) {
        this.beforeAnalysisHelper(c);
    }

    @Override
    public void registerAllowInliningPredicate(RuntimeCompilationFeature.AllowInliningPredicate predicate) {
        assert (!this.allowInliningPredicateUpdated);
        this.allowInliningPredicate = predicate;
        this.allowInliningPredicateUpdated = true;
    }

    @Override
    public void initializeAnalysisProviders(BigBang bb, Function<ConstantFieldProvider, ConstantFieldProvider> generator) {
        HostedProviders defaultProviders = bb.getProviders(MultiMethod.ORIGINAL_METHOD);
        HostedProviders customHostedProviders = (HostedProviders)defaultProviders.copyWith(generator.apply(defaultProviders.getConstantFieldProvider()));
        customHostedProviders.setGraphBuilderPlugins(this.hostedProviders.getGraphBuilderPlugins());
        this.analysisProviders = customHostedProviders;
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess c) {
        NodeClass[] nodeClasses;
        FeatureImpl.DuringAnalysisAccessImpl config = (FeatureImpl.DuringAnalysisAccessImpl)c;
        if (this.newRuntimeMethodsSeen) {
            SubstrateMethod[] methodsToCompileArr = (SubstrateMethod[])this.substrateAnalysisMethods.stream().toArray(SubstrateMethod[]::new);
            GraalSupport.setMethodsToCompile(config, methodsToCompileArr);
            config.requireAnalysisIteration();
            this.newRuntimeMethodsSeen = false;
        }
        this.graphEncoder.finishPrepare();
        AnalysisMetaAccess metaAccess = config.getMetaAccess();
        for (NodeClass nodeClass : nodeClasses = this.graphEncoder.getNodeClasses()) {
            metaAccess.lookupJavaType(nodeClass.getClazz()).registerAsAllocated((Object)("All " + NodeClass.class.getName() + " classes are marked as instantiated eagerly."));
        }
        if (GraalSupport.setGraphEncoding(config, this.graphEncoder.getEncoding(), this.graphEncoder.getObjects(), nodeClasses)) {
            config.requireAnalysisIteration();
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.buildCallTrees();
        this.runtimeCompilations = new HashSet<RuntimeCompilationFeature.RuntimeCompiledMethod>();
        FeatureImpl.AfterAnalysisAccessImpl impl = (FeatureImpl.AfterAnalysisAccessImpl)access;
        for (AnalysisMethod method : impl.getUniverse().getMethods()) {
            AnalysisMethod rMethod = method.getMultiMethod(SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD);
            if (rMethod == null || !rMethod.isReachable() || this.invalidForRuntimeCompilation.containsKey(rMethod)) continue;
            List runtimeInlinedMethods = rMethod.getAnalyzedGraph().getInlinedMethods();
            Set<ResolvedJavaMethod> inlinedMethods = runtimeInlinedMethods.stream().map(inlinedMethod -> {
                AnalysisMethod orig = ((AnalysisMethod)inlinedMethod).getMultiMethod(MultiMethod.ORIGINAL_METHOD);
                assert (orig != null);
                return orig;
            }).collect(Collectors.toUnmodifiableSet());
            boolean added = this.runtimeCompilations.add(new RuntimeCompiledMethodImpl(method, inlinedMethods));
            assert (added);
            assert (this.runtimeCompiledMethodCallTree.containsKey(method));
        }
        this.afterAnalysisHelper();
        this.objectReplacer.forbidNewTypes();
    }

    @Override
    protected RuntimeCompilationFeature.AbstractCallTreeNode getCallTreeNode(RuntimeCompilationFeature.RuntimeCompilationCandidate candidate) {
        CallTreeNode result = this.runtimeCandidateCallTree.get(candidate);
        assert (result != null);
        return result;
    }

    @Override
    protected RuntimeCompilationFeature.AbstractCallTreeNode getCallTreeNode(RuntimeCompilationFeature.RuntimeCompiledMethod method) {
        return this.getCallTreeNode((ResolvedJavaMethod)method.getMethod());
    }

    @Override
    protected RuntimeCompilationFeature.AbstractCallTreeNode getCallTreeNode(ResolvedJavaMethod method) {
        CallTreeNode result = this.runtimeCompiledMethodCallTree.get(method);
        assert (result != null);
        return result;
    }

    @Override
    public Collection<RuntimeCompilationFeature.RuntimeCompiledMethod> getRuntimeCompiledMethods() {
        return this.runtimeCompilations;
    }

    @Override
    public Collection<RuntimeCompilationFeature.RuntimeCompilationCandidate> getAllRuntimeCompilationCandidates() {
        return this.runtimeCompilationCandidates;
    }

    private void buildCallTrees() {
        assert (this.runtimeCandidateCallTree == null && this.runtimeCompiledMethodCallTree == null);
        this.runtimeCandidateCallTree = new HashMap<RuntimeCompilationFeature.RuntimeCompilationCandidate, CallTreeNode>();
        this.runtimeCompiledMethodCallTree = new HashMap<AnalysisMethod, CallTreeNode>();
        LinkedList worklist = new LinkedList();
        for (AnalysisMethod root : this.registeredRuntimeCompilations) {
            AnalysisMethod runtimeRoot = root.getMultiMethod(SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD);
            if (runtimeRoot == null) continue;
            this.runtimeCandidateCallTree.computeIfAbsent(new RuntimeCompilationCandidateImpl(root, root), candidate -> {
                CallTreeNode result = new CallTreeNode(root, root, null, null);
                worklist.add(result);
                return result;
            });
        }
        while (!worklist.isEmpty()) {
            CallTreeNode caller = (CallTreeNode)worklist.remove();
            caller.linkAsChild();
            AnalysisMethod method = caller.getImplementationMethod();
            if (this.runtimeCompiledMethodCallTree.containsKey(method)) continue;
            this.runtimeCompiledMethodCallTree.put(method, caller);
            AnalysisMethod runtimeMethod = method.getMultiMethod(SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD);
            assert (runtimeMethod != null);
            for (InvokeInfo invokeInfo : runtimeMethod.getInvokes()) {
                AnalysisMethod invokeTarget = invokeInfo.getTargetMethod();
                if (invokeInfo.isDeoptInvokeTypeFlow()) {
                    assert (SubstrateCompilationDirectives.isRuntimeCompiledMethod((ResolvedJavaMethod)invokeTarget));
                    invokeTarget = invokeTarget.getMultiMethod(MultiMethod.ORIGINAL_METHOD);
                }
                AnalysisMethod target = invokeTarget;
                assert (target.isOriginalMethod());
                for (AnalysisMethod implementation : invokeInfo.getAllCallees()) {
                    if (SubstrateCompilationDirectives.isRuntimeCompiledMethod((ResolvedJavaMethod)implementation)) {
                        AnalysisMethod origImpl = implementation.getMultiMethod(MultiMethod.ORIGINAL_METHOD);
                        assert (origImpl != null);
                        this.runtimeCandidateCallTree.computeIfAbsent(new RuntimeCompilationCandidateImpl(origImpl, target), candidate -> {
                            CallTreeNode result = new CallTreeNode(origImpl, target, caller, invokeInfo.getPosition());
                            worklist.add(result);
                            return result;
                        });
                        continue;
                    }
                    if (!implementation.isOriginalMethod() || implementation.getMultiMethod(SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) != null) continue;
                    this.runtimeCandidateCallTree.computeIfAbsent(new RuntimeCompilationCandidateImpl(implementation, target), candidate -> {
                        CallTreeNode result = new CallTreeNode(implementation, target, caller, invokeInfo.getPosition());
                        result.linkAsChild();
                        return result;
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileRuntimeCompiledMethod(DebugContext debug, HostedMethod method) {
        assert (method.getMultiMethodKey() == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD);
        AnalysisMethod aMethod = method.getWrapped();
        StructuredGraph graph = aMethod.decodeAnalyzedGraph(debug, null);
        if (graph == null) {
            throw VMError.shouldNotReachHere("Method not parsed during static analysis: " + aMethod.format("%r %H.%n(%p)"));
        }
        aMethod.setAnalyzedGraph(null);
        CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
        IterativeConditionalEliminationPhase conditionalElimination = new IterativeConditionalEliminationPhase(canonicalizer, true);
        ConvertDeoptimizeToGuardPhase convertDeoptimizeToGuard = new ConvertDeoptimizeToGuardPhase(canonicalizer);
        try (DebugContext.Scope s = debug.scope((Object)"RuntimeOptimize", (Object)graph, (Object)method, (Object)this);){
            canonicalizer.apply(graph, (Object)this.hostedProviders);
            conditionalElimination.apply(graph, (Object)this.hostedProviders);
            convertDeoptimizeToGuard.apply(graph, (Object)this.hostedProviders);
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        AnalysisMethod origMethod = method.getMultiMethod(MultiMethod.ORIGINAL_METHOD).getWrapped();
        DeoptimizationUtils.registerDeoptEntries(graph, this.registeredRuntimeCompilations.contains(origMethod), deoptEntryMethod -> {
            PointsToAnalysisMethod deoptMethod = (PointsToAnalysisMethod)((PointsToAnalysisMethod)deoptEntryMethod).getMultiMethod(MultiMethod.DEOPT_TARGET_METHOD);
            VMError.guarantee(deoptMethod != null, "New deopt target method seen: %s", deoptEntryMethod);
            return deoptMethod;
        });
        assert (RuntimeCompilationFeature.verifyNodes(graph));
        StructuredGraph previous = this.runtimeGraphs.put(method, graph);
        assert (previous == null);
        ParseOnceRuntimeCompilationFeature parseOnceRuntimeCompilationFeature = this;
        synchronized (parseOnceRuntimeCompilationFeature) {
            this.graphEncoder.prepare(graph);
        }
    }

    private void encodeRuntimeCompiledMethods() {
        this.graphEncoder.finishPrepare();
        SubstrateCompilationDirectives.singleton().sealDeoptimizationInfo();
        for (Map.Entry<HostedMethod, StructuredGraph> runtimeInfo : this.runtimeGraphs.entrySet()) {
            StructuredGraph graph = runtimeInfo.getValue();
            HostedMethod method = runtimeInfo.getKey();
            DebugContext debug = new DebugContext.Builder(graph.getOptions(), (DebugHandlersFactory)new GraalDebugHandlersFactory(this.hostedProviders.getSnippetReflection())).build();
            graph.resetDebug(debug);
            try {
                DebugContext.Scope s = debug.scope((Object)"Graph Encoding", (Object)graph);
                try {
                    DebugContext.Activation a = debug.activate();
                    try {
                        long startOffset = this.graphEncoder.encode(graph);
                        this.objectReplacer.createMethod(method).setEncodedGraphStartOffset(startOffset);
                    }
                    finally {
                        if (a == null) continue;
                        a.close();
                    }
                }
                finally {
                    if (s == null) continue;
                    s.close();
                }
            }
            catch (Throwable ex) {
                debug.handle(ex);
            }
        }
        HeapBreakdownProvider.singleton().setGraphEncodingByteLength(this.graphEncoder.getEncoding().length);
        GraalSupport.setGraphEncoding(null, this.graphEncoder.getEncoding(), this.graphEncoder.getObjects(), this.graphEncoder.getNodeClasses());
        this.objectReplacer.setMethodsImplementations();
        this.graphEncoder = null;
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess c) {
        this.beforeCompilationHelper();
    }

    @Override
    public void onCompileQueueCreation(HostedUniverse universe, CompileQueue compileQueue) {
        this.graphEncoder = new GraphEncoder(ConfigurationValues.getTarget().arch);
        SubstrateCompilationDirectives.singleton().resetDeoptEntries();
        CompletionExecutor executor = compileQueue.getExecutor();
        try {
            compileQueue.runOnExecutor(() -> universe.getMethods().stream().map(method -> method.getMultiMethod(SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD)).filter(method -> {
                if (method != null) {
                    AnalysisMethod aMethod = method.getWrapped();
                    return aMethod.isImplementationInvoked() && !this.invalidForRuntimeCompilation.containsKey(aMethod);
                }
                return false;
            }).forEach(method -> executor.execute((CompletionExecutor.DebugContextRunnable)new RuntimeCompileTask((HostedMethod)method))));
        }
        catch (InterruptedException exception) {
            VMError.shouldNotReachHere(exception);
        }
        this.encodeRuntimeCompiledMethods();
        CompileQueue.ParseHooks deoptParseHooks = new CompileQueue.ParseHooks(compileQueue){

            @Override
            protected PhaseSuite<HighTierContext> getAfterParseSuite() {
                PhaseSuite<HighTierContext> suite = super.getAfterParseSuite();
                if (Options.RemoveUnneededDeoptSupport.getValue().booleanValue()) {
                    ListIterator iterator = suite.findPhase(StrengthenStampsPhase.class);
                    if (iterator == null) {
                        suite.prependPhase((BasePhase)new RemoveUnneededDeoptSupport());
                    } else {
                        iterator.add(new RemoveUnneededDeoptSupport());
                    }
                }
                return suite;
            }
        };
        universe.getMethods().stream().map(method -> method.getMultiMethod(MultiMethod.DEOPT_TARGET_METHOD)).filter(method -> {
            if (method != null) {
                return compileQueue.isRegisteredDeoptTarget((HostedMethod)method);
            }
            return false;
        }).forEach(method -> method.compilationInfo.setCustomParseHooks(deoptParseHooks));
    }

    public void afterCompilation(Feature.AfterCompilationAccess a) {
        super.afterCompilationHelper(a);
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess a) {
        this.afterHeapLayoutHelper(a);
    }

    @Override
    public SubstrateMethod prepareMethodForRuntimeCompilation(ResolvedJavaMethod method, FeatureImpl.BeforeAnalysisAccessImpl config) {
        AnalysisMethod aMethod = (AnalysisMethod)method;
        assert (aMethod.isOriginalMethod());
        SubstrateMethod sMethod = this.objectReplacer.createMethod((ResolvedJavaMethod)aMethod);
        this.substrateAnalysisMethods.add(sMethod);
        if (this.registeredRuntimeCompilations.add(aMethod)) {
            aMethod.getOrCreateMultiMethod(SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD);
            AnalysisMethod deoptMethod = aMethod.getOrCreateMultiMethod(MultiMethod.DEOPT_TARGET_METHOD, newMethod -> ((PointsToAnalysisMethod)newMethod).getTypeFlow().setAsStubFlow());
            SubstrateCompilationDirectives.singleton().registerDeoptTarget((ResolvedJavaMethod)deoptMethod);
            config.registerAsRoot(aMethod, true, "Runtime compilation, registered in " + ParseOnceRuntimeCompilationFeature.class, SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD, MultiMethod.DEOPT_TARGET_METHOD);
        }
        return sMethod;
    }

    @Override
    protected void requireFrameInformationForMethodHelper(AnalysisMethod aMethod) {
        AnalysisMethod deoptTarget = aMethod.getOrCreateMultiMethod(MultiMethod.DEOPT_TARGET_METHOD);
        SubstrateCompilationDirectives.singleton().registerFrameInformationRequired(aMethod, deoptTarget);
    }

    private class RuntimeCompilationParsingSupport
    implements SVMParsingSupport {
        RuntimeCompilationInlineBeforeAnalysisPolicy runtimeInlineBeforeAnalysisPolicy = null;

        private RuntimeCompilationParsingSupport() {
        }

        @Override
        public HostedProviders getHostedProviders(MultiMethod.MultiMethodKey key) {
            if (key == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) {
                assert (ParseOnceRuntimeCompilationFeature.this.analysisProviders != null);
                return ParseOnceRuntimeCompilationFeature.this.analysisProviders;
            }
            return null;
        }

        @Override
        public boolean allowAssumptions(AnalysisMethod method) {
            return method.getMultiMethodKey() == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD;
        }

        @Override
        public boolean recordInlinedMethods(AnalysisMethod method) {
            return method.getMultiMethodKey() == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD;
        }

        @Override
        public Object parseGraph(BigBang bb, DebugContext debug, AnalysisMethod method) {
            if (method.getMultiMethodKey() == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) {
                return this.parseRuntimeCompiledMethod(bb, debug, method);
            }
            return HostVM.PARSING_UNHANDLED;
        }

        @Override
        public GraphBuilderConfiguration updateGraphBuilderConfiguration(GraphBuilderConfiguration config, AnalysisMethod method) {
            if (method.isDeoptTarget()) {
                return config.withOmitAssertions(ParseOnceRuntimeCompilationFeature.this.graphBuilderConfig.omitAssertions()).withRetainLocalVariables(false);
            }
            return config;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Object parseRuntimeCompiledMethod(BigBang bb, DebugContext debug, AnalysisMethod method) {
            boolean parsed = false;
            StructuredGraph graph = method.buildGraph(debug, (ResolvedJavaMethod)method, ParseOnceRuntimeCompilationFeature.this.analysisProviders, GraphProvider.Purpose.PREPARE_RUNTIME_COMPILATION);
            if (graph == null) {
                if (!method.hasBytecodes()) {
                    this.recordFailed(method);
                    return HostVM.PARSING_FAILED;
                }
                parsed = true;
                graph = new StructuredGraph.Builder(debug.getOptions(), debug, StructuredGraph.AllowAssumptions.YES).method((ResolvedJavaMethod)method).recordInlinedMethods(true).build();
            }
            try {
                DebugContext.Scope scope = debug.scope((Object)"RuntimeCompile", (Object)graph, (Object)method);
                try {
                    if (parsed) {
                        try (Indent indent2 = debug.logAndIndent("parse graph phases");){
                            RuntimeGraphBuilderPhase.createRuntimeGraphBuilderPhase(bb, (Providers)ParseOnceRuntimeCompilationFeature.this.analysisProviders, ParseOnceRuntimeCompilationFeature.this.graphBuilderConfig, ParseOnceRuntimeCompilationFeature.this.optimisticOpts).apply(graph);
                        }
                        catch (PermanentBailoutException ex) {
                            bb.getUnsupportedFeatures().addMessage(method.format("%H.%n(%p)"), method, ex.getLocalizedMessage(), null, (Throwable)ex);
                            this.recordFailed(method);
                            Object object = HostVM.PARSING_FAILED;
                            if (scope == null) return object;
                            scope.close();
                            return object;
                        }
                    }
                    if (graph.getNodes(StackValueNode.TYPE).isNotEmpty()) {
                        this.recordFailed(method);
                        Object ex = HostVM.PARSING_FAILED;
                        return ex;
                    }
                    CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
                    canonicalizer.apply(graph, (Object)ParseOnceRuntimeCompilationFeature.this.analysisProviders);
                    if (ParseOnceRuntimeCompilationFeature.this.deoptimizeOnExceptionPredicate != null) {
                        new DeoptimizeOnExceptionPhase(ParseOnceRuntimeCompilationFeature.this.deoptimizeOnExceptionPredicate).apply(graph);
                    }
                    new ConvertDeoptimizeToGuardPhase(canonicalizer).apply(graph, (Object)ParseOnceRuntimeCompilationFeature.this.analysisProviders);
                    return graph;
                }
                finally {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            catch (Throwable ex) {
                debug.handle(ex);
            }
            return graph;
        }

        private void recordFailed(AnalysisMethod method) {
            ParseOnceRuntimeCompilationFeature.this.invalidForRuntimeCompilation.computeIfAbsent(method, m -> "generic failure");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean validateGraph(PointsToAnalysis bb, StructuredGraph graph) {
            PointsToAnalysisMethod aMethod = (PointsToAnalysisMethod)graph.method();
            MultiMethod.MultiMethodKey multiMethodKey = aMethod.getMultiMethodKey();
            Supplier<Boolean> hasStackValues = () -> graph.getNodes(StackValueNode.TYPE).isNotEmpty();
            if (aMethod.isOriginalMethod() && DeoptimizationUtils.canDeoptForTesting((AnalysisMethod)aMethod, false, hasStackValues)) {
                DeoptimizationUtils.registerDeoptEntriesForDeoptTesting(bb, graph, aMethod);
                return true;
            }
            if (multiMethodKey != MultiMethod.ORIGINAL_METHOD && hasStackValues.get().booleanValue()) {
                this.recordFailed((AnalysisMethod)aMethod);
                return false;
            }
            if (multiMethodKey == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) {
                ParseOnceRuntimeCompilationFeature.this.parsedRuntimeMethods.add((ResolvedJavaMethod)aMethod);
                ParseOnceRuntimeCompilationFeature.this.totalParsedRuntimeMethods.incrementAndGet();
                AnalysisMethod origMethod = aMethod.getMultiMethod(MultiMethod.ORIGINAL_METHOD);
                Collection<ResolvedJavaMethod> recomputeMethods = DeoptimizationUtils.registerDeoptEntries(graph, ParseOnceRuntimeCompilationFeature.this.registeredRuntimeCompilations.contains(origMethod), deoptEntryMethod -> ((PointsToAnalysisMethod)deoptEntryMethod).getOrCreateMultiMethod(MultiMethod.DEOPT_TARGET_METHOD));
                for (ResolvedJavaMethod method : recomputeMethods) {
                    assert (MultiMethod.isDeoptTarget((ResolvedJavaMethod)method));
                    ((PointsToAnalysisMethod)method).getTypeFlow().updateFlowsGraph(bb, MethodFlowsGraph.GraphKind.FULL, null, true);
                }
                RuntimeCompilationParsingSupport runtimeCompilationParsingSupport = this;
                synchronized (runtimeCompilationParsingSupport) {
                    ParseOnceRuntimeCompilationFeature.this.newRuntimeMethodsSeen = true;
                    AnalysisMethod origAMethod = aMethod.getMultiMethod(MultiMethod.ORIGINAL_METHOD);
                    assert (origAMethod != null);
                    SubstrateMethod sMethod = ParseOnceRuntimeCompilationFeature.this.objectReplacer.createMethod((ResolvedJavaMethod)origAMethod);
                    ParseOnceRuntimeCompilationFeature.this.substrateAnalysisMethods.add(sMethod);
                    ParseOnceRuntimeCompilationFeature.this.graphEncoder.prepare(graph);
                }
                assert (RuntimeCompilationFeature.verifyNodes(graph));
            } else if (multiMethodKey == MultiMethod.DEOPT_TARGET_METHOD) {
                ParseOnceRuntimeCompilationFeature.this.parsedDeoptMethods.add((ResolvedJavaMethod)aMethod);
                ParseOnceRuntimeCompilationFeature.this.totalParsedDeoptMethods.incrementAndGet();
            }
            return true;
        }

        @Override
        public void initializeInlineBeforeAnalysisPolicy(SVMHost svmHost, InlineBeforeAnalysisPolicyUtils inliningUtils) {
            if (Options.RuntimeCompilationInlineBeforeAnalysis.getValue().booleanValue()) {
                assert (this.runtimeInlineBeforeAnalysisPolicy == null);
                this.runtimeInlineBeforeAnalysisPolicy = new RuntimeCompilationInlineBeforeAnalysisPolicy(svmHost, inliningUtils);
            }
        }

        @Override
        public InlineBeforeAnalysisPolicy inlineBeforeAnalysisPolicy(MultiMethod.MultiMethodKey multiMethodKey, InlineBeforeAnalysisPolicy defaultPolicy) {
            if (multiMethodKey == MultiMethod.ORIGINAL_METHOD) {
                return defaultPolicy;
            }
            if (multiMethodKey == MultiMethod.DEOPT_TARGET_METHOD) {
                return InlineBeforeAnalysisPolicy.NO_INLINING;
            }
            if (multiMethodKey == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) {
                if (Options.RuntimeCompilationInlineBeforeAnalysis.getValue().booleanValue()) {
                    assert (this.runtimeInlineBeforeAnalysisPolicy != null);
                    return this.runtimeInlineBeforeAnalysisPolicy;
                }
                return InlineBeforeAnalysisPolicy.NO_INLINING;
            }
            throw VMError.shouldNotReachHere("Unexpected method key: %s", multiMethodKey);
        }

        @Override
        public Function<AnalysisType, ResolvedJavaType> getStrengthenGraphsToTargetFunction(MultiMethod.MultiMethodKey key) {
            if (key == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) {
                return t -> ParseOnceRuntimeCompilationFeature.this.objectReplacer.typeCreated((JavaType)t) ? t : null;
            }
            return null;
        }
    }

    private class RuntimeCompilationAnalysisPolicy
    implements HostVM.MultiMethodAnalysisPolicy {
        private RuntimeCompilationAnalysisPolicy() {
        }

        public <T extends AnalysisMethod> Collection<T> determineCallees(BigBang bb, T implementation, T target, MultiMethod.MultiMethodKey callerMultiMethodKey, InvokeTypeFlow invokeFlow) {
            boolean runtimeCompilationCandidate;
            if (invokeFlow.isDeoptInvokeTypeFlow()) {
                assert (SubstrateCompilationDirectives.isRuntimeCompiledMethod(implementation));
                AnalysisMethod originalTarget = implementation.getMultiMethod(MultiMethod.ORIGINAL_METHOD);
                assert (originalTarget != null);
                ParseOnceRuntimeCompilationFeature.this.runtimeCompilationCandidates.add(new RuntimeCompilationCandidateImpl(originalTarget, originalTarget));
                return List.of(this.getDeoptVersion(implementation));
            }
            assert (implementation.isOriginalMethod() && target.isOriginalMethod());
            boolean registeredRuntimeCompilation = ParseOnceRuntimeCompilationFeature.this.registeredRuntimeCompilations.contains(implementation);
            if (callerMultiMethodKey == MultiMethod.ORIGINAL_METHOD) {
                if (registeredRuntimeCompilation) {
                    return List.of(implementation, this.getDeoptVersion(implementation), this.getRuntimeVersion(bb, implementation, true, invokeFlow));
                }
                if (DeoptimizationUtils.canDeoptForTesting(implementation, false, () -> false)) {
                    return List.of(implementation, this.getDeoptVersion(implementation));
                }
                return List.of(implementation);
            }
            boolean bl = runtimeCompilationCandidate = registeredRuntimeCompilation || ParseOnceRuntimeCompilationFeature.this.runtimeCompilationCandidatePredicate.allowRuntimeCompilation((ResolvedJavaMethod)implementation);
            if (callerMultiMethodKey == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) {
                ParseOnceRuntimeCompilationFeature.this.runtimeCompilationCandidates.add(new RuntimeCompilationCandidateImpl(implementation, target));
                if (runtimeCompilationCandidate) {
                    return List.of(implementation, this.getDeoptVersion(implementation), this.getRuntimeVersion(bb, implementation, true, invokeFlow));
                }
                return List.of(implementation);
            }
            assert (callerMultiMethodKey == MultiMethod.DEOPT_TARGET_METHOD);
            if (runtimeCompilationCandidate) {
                return List.of(implementation, this.getDeoptVersion(implementation), this.getRuntimeVersion(bb, implementation, false, invokeFlow));
            }
            return List.of(implementation);
        }

        protected <T extends AnalysisMethod> T getDeoptVersion(T implementation) {
            return (T)implementation.getOrCreateMultiMethod(MultiMethod.DEOPT_TARGET_METHOD, newMethod -> ((PointsToAnalysisMethod)newMethod).getTypeFlow().setAsStubFlow());
        }

        protected <T extends AnalysisMethod> T getRuntimeVersion(BigBang bb, T implementation, boolean createFlow, InvokeTypeFlow parsingReason) {
            if (createFlow) {
                PointsToAnalysisMethod runtimeMethod = (PointsToAnalysisMethod)implementation.getOrCreateMultiMethod(SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD);
                PointsToAnalysis analysis = (PointsToAnalysis)bb;
                runtimeMethod.getTypeFlow().updateFlowsGraph(analysis, MethodFlowsGraph.GraphKind.FULL, parsingReason, false);
                return (T)runtimeMethod;
            }
            return (T)implementation.getOrCreateMultiMethod(SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD, newMethod -> ((PointsToAnalysisMethod)newMethod).getTypeFlow().setAsStubFlow());
        }

        public boolean performParameterLinking(MultiMethod.MultiMethodKey callerMultiMethodKey, MultiMethod.MultiMethodKey calleeMultiMethodKey) {
            if (callerMultiMethodKey == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) {
                return true;
            }
            if (callerMultiMethodKey == MultiMethod.DEOPT_TARGET_METHOD) {
                return calleeMultiMethodKey == MultiMethod.ORIGINAL_METHOD;
            }
            assert (callerMultiMethodKey == MultiMethod.ORIGINAL_METHOD);
            return true;
        }

        public boolean performReturnLinking(MultiMethod.MultiMethodKey callerMultiMethodKey, MultiMethod.MultiMethodKey calleeMultiMethodKey) {
            if (callerMultiMethodKey == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) {
                return calleeMultiMethodKey == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD || calleeMultiMethodKey == MultiMethod.ORIGINAL_METHOD;
            }
            if (callerMultiMethodKey == MultiMethod.DEOPT_TARGET_METHOD) {
                return true;
            }
            assert (callerMultiMethodKey == MultiMethod.ORIGINAL_METHOD);
            return true;
        }

        public boolean canComputeReturnedParameterIndex(MultiMethod.MultiMethodKey multiMethodKey) {
            return multiMethodKey != MultiMethod.DEOPT_TARGET_METHOD;
        }

        public boolean insertPlaceholderParamAndReturnFlows(MultiMethod.MultiMethodKey multiMethodKey) {
            return multiMethodKey == MultiMethod.DEOPT_TARGET_METHOD || multiMethodKey == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD;
        }
    }

    static final class RuntimeCompiledMethodImpl
    implements RuntimeCompilationFeature.RuntimeCompiledMethod {
        final AnalysisMethod method;
        final Collection<ResolvedJavaMethod> inlinedMethods;

        private RuntimeCompiledMethodImpl(AnalysisMethod method, Collection<ResolvedJavaMethod> inlinedMethods) {
            this.method = method;
            this.inlinedMethods = inlinedMethods;
        }

        @Override
        public AnalysisMethod getMethod() {
            return this.method;
        }

        @Override
        public Collection<ResolvedJavaMethod> getInlinedMethods() {
            return this.inlinedMethods;
        }

        @Override
        public Collection<ResolvedJavaMethod> getInvokeTargets() {
            ArrayList<ResolvedJavaMethod> targets = new ArrayList<ResolvedJavaMethod>();
            for (InvokeInfo invoke : this.method.getInvokes()) {
                targets.add((ResolvedJavaMethod)invoke.getTargetMethod());
            }
            return targets;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RuntimeCompiledMethodImpl that = (RuntimeCompiledMethodImpl)o;
            return this.method.equals((Object)that.method);
        }

        public int hashCode() {
            return Objects.hash(this.method);
        }
    }

    public static final class CallTreeNode
    extends RuntimeCompilationFeature.AbstractCallTreeNode {
        final BytecodePosition position;

        CallTreeNode(AnalysisMethod implementationMethod, AnalysisMethod targetMethod, CallTreeNode parent, BytecodePosition position) {
            super(parent, targetMethod, implementationMethod);
            this.position = position;
        }

        @Override
        public String getPosition() {
            if (this.position == null) {
                return "[root]";
            }
            return this.position.toString();
        }

        @Override
        public int getNodeCount() {
            return -1;
        }
    }

    static class RuntimeCompilationCandidateImpl
    implements RuntimeCompilationFeature.RuntimeCompilationCandidate {
        AnalysisMethod implementationMethod;
        AnalysisMethod targetMethod;

        RuntimeCompilationCandidateImpl(AnalysisMethod implementationMethod, AnalysisMethod targetMethod) {
            this.implementationMethod = implementationMethod;
            this.targetMethod = targetMethod;
        }

        @Override
        public AnalysisMethod getImplementationMethod() {
            return this.implementationMethod;
        }

        @Override
        public AnalysisMethod getTargetMethod() {
            return this.targetMethod;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RuntimeCompilationCandidateImpl that = (RuntimeCompilationCandidateImpl)o;
            return this.implementationMethod.equals((Object)that.implementationMethod) && this.targetMethod.equals((Object)that.targetMethod);
        }

        public int hashCode() {
            return Objects.hash(this.implementationMethod, this.targetMethod);
        }
    }

    private class RuntimeCompileTask
    implements CompletionExecutor.DebugContextRunnable {
        final HostedMethod method;

        RuntimeCompileTask(HostedMethod method) {
            this.method = method;
        }

        public DebugContext getDebug(OptionValues options, List<DebugHandlersFactory> factories) {
            return new DebugContext.Builder(options, factories).description(this.getDescription()).build();
        }

        public void run(DebugContext debug) {
            ParseOnceRuntimeCompilationFeature.this.compileRuntimeCompiledMethod(debug, this.method);
        }
    }

    static class RemoveUnneededDeoptSupport
    extends Phase {
        RemoveUnneededDeoptSupport() {
        }

        protected void run(StructuredGraph graph) {
            EconomicMap decisionCache = EconomicMap.create();
            for (DeoptProxyNode proxyNode : graph.getNodes(DeoptProxyNode.TYPE).snapshot()) {
                ValueNode proxyPoint = proxyNode.getProxyPoint();
                if (!(proxyPoint instanceof StateSplit) || this.getDecision((StateSplit)proxyPoint, (EconomicMap<StateSplit, RemovalDecision>)decisionCache) != RemovalDecision.REMOVE) continue;
                proxyNode.replaceAtAllUsages((Node)proxyNode.getOriginalNode(), true);
                proxyNode.safeDelete();
            }
            for (DeoptEntryNode deoptEntry : graph.getNodes().filter(DeoptEntryNode.class).snapshot()) {
                switch (this.getDecision(deoptEntry, (EconomicMap<StateSplit, RemovalDecision>)decisionCache)) {
                    case REMOVE: {
                        deoptEntry.killExceptionEdge();
                        graph.removeSplit((ControlSplitNode)deoptEntry, deoptEntry.getPrimarySuccessor());
                        break;
                    }
                    case PROXIFY: {
                        deoptEntry.killExceptionEdge();
                        DeoptProxyAnchorNode newAnchor = (DeoptProxyAnchorNode)graph.add((Node)new DeoptProxyAnchorNode(deoptEntry.getProxifiedInvokeBci()));
                        newAnchor.setStateAfter(deoptEntry.stateAfter());
                        graph.replaceSplitWithFixed((ControlSplitNode)deoptEntry, (FixedWithNextNode)newAnchor, deoptEntry.getPrimarySuccessor());
                    }
                }
            }
            for (DeoptProxyAnchorNode proxyAnchor : graph.getNodes().filter(DeoptProxyAnchorNode.class).snapshot()) {
                if (this.getDecision(proxyAnchor, (EconomicMap<StateSplit, RemovalDecision>)decisionCache) != RemovalDecision.REMOVE) continue;
                graph.removeFixed((FixedWithNextNode)proxyAnchor);
            }
        }

        RemovalDecision getDecision(StateSplit node, EconomicMap<StateSplit, RemovalDecision> decisionCache) {
            int proxifiedInvokeBci;
            DeoptEntrySupport proxyNode;
            RemovalDecision cached = (RemovalDecision)((Object)decisionCache.get((Object)node));
            if (cached != null) {
                return cached;
            }
            if (node instanceof ExceptionObjectNode) {
                ExceptionObjectNode exceptionObject = (ExceptionObjectNode)node;
                proxyNode = (DeoptEntrySupport)exceptionObject.predecessor();
            } else {
                proxyNode = (DeoptEntrySupport)node;
            }
            RemovalDecision decision = RemovalDecision.REMOVE;
            SubstrateCompilationDirectives directive = SubstrateCompilationDirectives.singleton();
            FrameState state = proxyNode.stateAfter();
            HostedMethod method = (HostedMethod)state.getMethod();
            if (proxyNode instanceof DeoptEntryNode && directive.isDeoptEntry(method, state.bci, state.duringCall(), state.rethrowException())) {
                decision = RemovalDecision.KEEP;
            }
            if (decision == RemovalDecision.REMOVE && (proxifiedInvokeBci = proxyNode.getProxifiedInvokeBci()) != -5 && directive.isDeoptEntry(method, proxifiedInvokeBci, true, false)) {
                decision = proxyNode instanceof DeoptEntryNode ? RemovalDecision.PROXIFY : RemovalDecision.KEEP;
            }
            decisionCache.put((Object)node, (Object)decision);
            if (proxyNode != node) {
                decisionCache.put((Object)proxyNode, (Object)decision);
            }
            return decision;
        }

        public CharSequence getName() {
            return "RemoveUnneededDeoptSupport";
        }

        static enum RemovalDecision {
            KEEP,
            PROXIFY,
            REMOVE;

        }
    }

    private class RuntimeCompilationInlineBeforeAnalysisPolicy
    extends InlineBeforeAnalysisPolicy {
        private final int accumulativeAllowedInliningDepth;
        private final int trivialAllowingInliningDepth;
        final SVMHost hostVM;
        final InlineBeforeAnalysisPolicyUtils inliningUtils;

        protected RuntimeCompilationInlineBeforeAnalysisPolicy(SVMHost hostVM, InlineBeforeAnalysisPolicyUtils inliningUtils) {
            super(new NodePlugin[]{new ConstantFoldLoadFieldPlugin(ParsingReason.PointsToAnalysis)});
            this.accumulativeAllowedInliningDepth = InlineBeforeAnalysisPolicyUtils.Options.InlineBeforeAnalysisAllowedDepth.getValue();
            this.trivialAllowingInliningDepth = (Integer)BytecodeParserOptions.InlineDuringParsingMaxDepth.getValue(HostedOptionValues.singleton());
            this.hostVM = hostVM;
            this.inliningUtils = inliningUtils;
        }

        protected boolean tryInvocationPlugins() {
            return true;
        }

        protected boolean needsExplicitExceptions() {
            return false;
        }

        protected FixedWithNextNode processInvokeArgs(ResolvedJavaMethod targetMethod, FixedWithNextNode insertionPoint, ValueNode[] arguments) {
            StructuredGraph graph = insertionPoint.graph();
            InlinedInvokeArgumentsNode newNode = (InlinedInvokeArgumentsNode)graph.add((Node)new InlinedInvokeArgumentsNode(targetMethod, arguments));
            graph.addAfterFixed(insertionPoint, (FixedNode)newNode);
            return newNode;
        }

        protected boolean shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
            if (this.inliningUtils.alwaysInlineInvoke((AnalysisMetaAccess)b.getMetaAccess(), method)) {
                return true;
            }
            if (b.getDepth() > this.trivialAllowingInliningDepth + this.accumulativeAllowedInliningDepth) {
                return false;
            }
            if (b.recursiveInliningDepth(method) > 0) {
                return false;
            }
            if (!InlineBeforeAnalysisPolicyUtils.inliningAllowed(this.hostVM, b, method)) {
                return false;
            }
            RuntimeCompilationFeature.AllowInliningPredicate.InlineDecision result = ParseOnceRuntimeCompilationFeature.this.allowInliningPredicate.allowInlining(b, method);
            return result == RuntimeCompilationFeature.AllowInliningPredicate.InlineDecision.INLINE;
        }

        protected InlineInvokePlugin.InlineInfo createInvokeInfo(ResolvedJavaMethod method) {
            AnalysisMethod runtimeMethod = ((AnalysisMethod)method).getOrCreateMultiMethod(SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD, newMethod -> ((PointsToAnalysisMethod)newMethod).getTypeFlow().setAsStubFlow());
            return InlineInvokePlugin.InlineInfo.createStandardInlineInfo((ResolvedJavaMethod)runtimeMethod);
        }

        protected InlineBeforeAnalysisPolicy.AbstractPolicyScope createRootScope() {
            return null;
        }

        protected InlineBeforeAnalysisPolicy.AbstractPolicyScope openCalleeScope(InlineBeforeAnalysisPolicy.AbstractPolicyScope outer, AnalysisMetaAccess metaAccess, ResolvedJavaMethod method, boolean[] constArgsWithReceiver, boolean intrinsifiedMethodHandle) {
            int inliningDepth;
            if (outer instanceof InlineBeforeAnalysisPolicyUtils.AccumulativeInlineScope) {
                InlineBeforeAnalysisPolicyUtils.AccumulativeInlineScope accOuter = (InlineBeforeAnalysisPolicyUtils.AccumulativeInlineScope)outer;
                return this.inliningUtils.createAccumulativeInlineScope(accOuter, metaAccess, method, constArgsWithReceiver, intrinsifiedMethodHandle);
            }
            assert (outer == null || outer instanceof InlineBeforeAnalysisPolicyUtils.AlwaysInlineScope) : "unexpected outer scope: " + outer;
            boolean trivialInlineAllowed = this.hostVM.isAnalysisTrivialMethod((AnalysisMethod)method);
            int n = inliningDepth = outer == null ? 1 : outer.inliningDepth + 1;
            if (trivialInlineAllowed && inliningDepth <= this.trivialAllowingInliningDepth) {
                return new InlineBeforeAnalysisPolicyUtils.AlwaysInlineScope(inliningDepth);
            }
            return this.inliningUtils.createAccumulativeInlineScope(null, metaAccess, method, constArgsWithReceiver, intrinsifiedMethodHandle);
        }
    }

    private static final class RuntimeBytecodeParser
    extends AnalysisGraphBuilderPhase.AnalysisBytecodeParser {
        RuntimeBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext, SVMHost svmHost) {
            super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext, svmHost, false);
        }

        @Override
        protected boolean tryInvocationPlugin(CallTargetNode.InvokeKind invokeKind, ValueNode[] args, ResolvedJavaMethod targetMethod, JavaKind resultType) {
            boolean result = super.tryInvocationPlugin(invokeKind, args, targetMethod, resultType);
            if (result) {
                SubstrateCompilationDirectives.singleton().registerAsDeoptInlininingExclude(targetMethod);
            }
            return result;
        }

        @Override
        protected boolean shouldVerifyFrameStates() {
            return false;
        }
    }

    private static final class RuntimeGraphBuilderPhase
    extends AnalysisGraphBuilderPhase {
        private RuntimeGraphBuilderPhase(Providers providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext, WordTypes wordTypes, SVMHost hostVM) {
            super((CoreProviders)providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext, wordTypes, hostVM);
        }

        static RuntimeGraphBuilderPhase createRuntimeGraphBuilderPhase(BigBang bb, Providers providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts) {
            GraphBuilderConfiguration newGraphBuilderConfig = graphBuilderConfig.withEagerResolving(true).withUnresolvedIsError(((Boolean)PointstoOptions.UnresolvedIsError.getValue(bb.getOptions())).booleanValue());
            return new RuntimeGraphBuilderPhase(providers, newGraphBuilderConfig, optimisticOpts, null, providers.getWordTypes(), (SVMHost)bb.getHostVM());
        }

        @Override
        protected BytecodeParser createBytecodeParser(StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
            return new RuntimeBytecodeParser((GraphBuilderPhase.Instance)this, graph, parent, method, entryBCI, intrinsicContext, this.hostVM);
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> RemoveUnneededDeoptSupport = new HostedOptionKey<Boolean>(true);
        public static final HostedOptionKey<Boolean> RuntimeCompilationInlineBeforeAnalysis = new HostedOptionKey<Boolean>(true);
    }
}

