/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jfr;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.jfr.JfrFeature;
import com.oracle.svm.core.jfr.JfrJavaEvents;
import com.oracle.svm.core.jfr.traceid.JfrTraceId;
import com.oracle.svm.core.jfr.traceid.JfrTraceIdMap;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.jfr.JfrEventSubstitution;
import com.oracle.svm.util.ModuleSupport;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdk.internal.event.Event;
import jdk.jfr.internal.JVM;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;

@AutomaticallyRegisteredFeature
public class JfrEventFeature
implements InternalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return JfrFeature.isInConfiguration(false);
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Collections.singletonList(JfrFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, JfrEventFeature.class, (boolean)false, (String)"jdk.jfr", (String[])new String[]{"jdk.jfr.events"});
        ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, JfrFeature.class, (boolean)false, (String)"jdk.jfr", (String[])new String[]{"jdk.jfr.events"});
        ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, JfrEventSubstitution.class, (boolean)false, (String)"jdk.internal.vm.ci", (String[])new String[]{"jdk.vm.ci.hotspot"});
        ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, JfrEventFeature.class, (boolean)false, (String)"java.base", (String[])new String[]{"jdk.internal.event"});
    }

    public void duringSetup(Feature.DuringSetupAccess c) {
        FeatureImpl.DuringSetupAccessImpl config = (FeatureImpl.DuringSetupAccessImpl)c;
        MetaAccessProvider metaAccess = config.getMetaAccess().getWrapped();
        for (Class<Event> eventSubClass : config.findSubclasses(Event.class)) {
            RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{eventSubClass.getName()});
        }
        config.registerSubstitutionProcessor(new JfrEventSubstitution(metaAccess));
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        int mapSize = ((DynamicHubSupport)ImageSingletons.lookup(DynamicHubSupport.class)).getMaxTypeId() + 1;
        ((JfrTraceIdMap)ImageSingletons.lookup(JfrTraceIdMap.class)).initialize(mapSize);
        Collection<? extends SharedType> types = ((FeatureImpl.CompilationAccessImpl)a).getTypes();
        for (SharedType sharedType : types) {
            DynamicHub hub = sharedType.getHub();
            Class<?> clazz = hub.getHostedJavaClass();
            JfrTraceId.assign(clazz, hub.getTypeID() + 1);
        }
        try {
            FeatureImpl.CompilationAccessImpl accessImpl = (FeatureImpl.CompilationAccessImpl)a;
            Method method = JVM.class.getDeclaredMethod("getConfiguration", Class.class);
            for (Class<? extends Event> newEventClass : JfrJavaEvents.getAllEventClasses()) {
                Object ec = method.invoke((Object)JVM.getJVM(), newEventClass);
                DynamicHub dynamicHub = accessImpl.getMetaAccess().lookupJavaType((Class)newEventClass).getHub();
                dynamicHub.setJrfEventConfiguration(ec);
            }
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

