/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.meta.SharedMethod;
import java.lang.module.ModuleDescriptor;
import java.util.Optional;
import jdk.internal.loader.BuiltinClassLoader;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.c.function.CodePointer;

public class FrameInfoQueryResult {
    protected FrameInfoQueryResult caller;
    protected SharedMethod deoptMethod;
    protected int deoptMethodOffset;
    protected long encodedBci;
    protected boolean isDeoptEntry;
    protected int numLocals;
    protected int numStack;
    protected int numLocks;
    protected ValueInfo[] valueInfos;
    protected ValueInfo[][] virtualObjects;
    protected Class<?> sourceClass;
    protected String sourceMethodName;
    protected int sourceLineNumber;
    protected int methodId;
    protected int sourceClassIndex;
    protected int sourceMethodNameIndex;

    public FrameInfoQueryResult() {
        this.init();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void init() {
        this.caller = null;
        this.deoptMethod = null;
        this.deoptMethodOffset = 0;
        this.encodedBci = -1L;
        this.isDeoptEntry = false;
        this.numLocals = 0;
        this.numStack = 0;
        this.numLocks = 0;
        this.valueInfos = null;
        this.virtualObjects = null;
        this.sourceClass = null;
        this.sourceMethodName = "";
        this.sourceLineNumber = -1;
        this.methodId = -1;
        this.sourceClassIndex = -1;
        this.sourceMethodNameIndex = -1;
    }

    public FrameInfoQueryResult getCaller() {
        return this.caller;
    }

    public SharedMethod getDeoptMethod() {
        return this.deoptMethod;
    }

    public int getDeoptMethodOffset() {
        return this.deoptMethodOffset;
    }

    public CodePointer getDeoptMethodAddress() {
        return CodeInfoAccess.absoluteIP(CodeInfoTable.getImageCodeInfo(), this.deoptMethodOffset);
    }

    public long getEncodedBci() {
        return this.encodedBci;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getBci() {
        return FrameInfoDecoder.decodeBci(this.encodedBci);
    }

    public boolean duringCall() {
        return FrameInfoDecoder.decodeDuringCall(this.encodedBci);
    }

    public boolean rethrowException() {
        return FrameInfoDecoder.decodeRethrowException(this.encodedBci);
    }

    public boolean isDeoptEntry() {
        return this.isDeoptEntry;
    }

    public int getNumLocals() {
        return this.numLocals;
    }

    public int getNumLocks() {
        return this.numLocks;
    }

    public int getNumStack() {
        return this.numStack;
    }

    public boolean hasLocalValueInfo() {
        return this.valueInfos != null;
    }

    public ValueInfo[] getValueInfos() {
        return this.valueInfos;
    }

    public ValueInfo[][] getVirtualObjects() {
        return this.virtualObjects;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    public String getSourceClassName() {
        return this.sourceClass != null ? this.sourceClass.getName() : "";
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getSourceMethodName() {
        return this.sourceMethodName;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getMethodId() {
        return this.methodId;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getSourceFileName() {
        return this.sourceClass != null ? DynamicHub.fromClass(this.sourceClass).getSourceFileName() : null;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getSourceLineNumber() {
        return this.sourceLineNumber;
    }

    public StackTraceElement getSourceReference() {
        return FrameInfoQueryResult.getSourceReference(this.sourceClass, this.sourceMethodName, this.sourceLineNumber);
    }

    public static StackTraceElement getSourceReference(Class<?> sourceClass, String sourceMethodName, int sourceLineNumber) {
        if (sourceClass == null) {
            return new StackTraceElement("", sourceMethodName, null, sourceLineNumber);
        }
        ClassLoader classLoader = sourceClass.getClassLoader();
        String classLoaderName = null;
        if (classLoader != null && !(classLoader instanceof BuiltinClassLoader)) {
            classLoaderName = classLoader.getName();
        }
        Module module = sourceClass.getModule();
        String moduleName = module.getName();
        String moduleVersion = Optional.ofNullable(module.getDescriptor()).flatMap(ModuleDescriptor::version).map(ModuleDescriptor.Version::toString).orElse(null);
        String className = sourceClass.getName();
        String sourceFileName = DynamicHub.fromClass(sourceClass).getSourceFileName();
        return new StackTraceElement(classLoaderName, moduleName, moduleVersion, className, sourceMethodName, sourceFileName, sourceLineNumber);
    }

    public boolean isNativeMethod() {
        return this.sourceLineNumber == -2;
    }

    public Log log(Log log) {
        String className = this.sourceClass != null ? this.sourceClass.getName() : "";
        String methodName = this.sourceMethodName != null ? this.sourceMethodName : "";
        log.string(className);
        if (!className.isEmpty() && !methodName.isEmpty()) {
            log.string(".");
        }
        log.string(methodName);
        if (this.isDeoptEntry()) {
            log.string("**");
        }
        log.string("(");
        if (this.isNativeMethod()) {
            log.string("Native Method");
        } else {
            String sourceFileName;
            String string = sourceFileName = this.sourceClass != null ? DynamicHub.fromClass(this.sourceClass).getSourceFileName() : null;
            if (sourceFileName != null) {
                if (this.sourceLineNumber >= 0) {
                    log.string(sourceFileName).string(":").signed(this.sourceLineNumber);
                } else {
                    log.string(sourceFileName);
                }
            } else {
                log.string("Unknown Source");
            }
        }
        log.string(")");
        return log;
    }

    public static class ValueInfo {
        protected ValueType type;
        protected JavaKind kind;
        protected boolean isCompressedReference;
        protected boolean isEliminatedMonitor;
        protected long data;
        protected JavaConstant value;

        public ValueType getType() {
            return this.type;
        }

        public JavaKind getKind() {
            return this.kind;
        }

        public boolean isCompressedReference() {
            return this.isCompressedReference;
        }

        public boolean isEliminatedMonitor() {
            return this.isEliminatedMonitor;
        }

        public long getData() {
            return this.data;
        }

        public JavaConstant getValue() {
            return this.value;
        }
    }

    public static enum ValueType {
        Illegal(false),
        StackSlot(true),
        Register(true),
        ReservedRegister(true),
        Constant(true),
        DefaultConstant(false),
        VirtualObject(true);

        final boolean hasData;

        private ValueType(boolean hasData) {
            this.hasData = hasData;
        }
    }
}

