/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.genscavenge.CollectionPolicy;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;

public final class SerialGCOptions {
    public static final HostedOptionKey<String> InitialCollectionPolicy = new HostedOptionKey<String>("Adaptive", SerialGCOptions::serialGCOnly);
    public static final RuntimeOptionKey<Integer> PercentTimeInIncrementalCollection = new RuntimeOptionKey<Integer>(Integer.valueOf(50), SerialGCOptions::serialGCOnly, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final RuntimeOptionKey<Long> MaxHeapFree = new RuntimeOptionKey<Long>(Long.valueOf(0L), SerialGCOptions::serialGCOnly, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final HostedOptionKey<Integer> MaxSurvivorSpaces = new HostedOptionKey<Integer>(null, SerialGCOptions::serialGCOnly){

        public Integer getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
            Integer value = (Integer)values.get((Object)this);
            UserError.guarantee(value == null || value >= 0, "%s value must be greater than or equal to 0", this.getName());
            return CollectionPolicy.getMaxSurvivorSpaces(value);
        }

        public Integer getValue(OptionValues values) {
            assert (this.checkDescriptorExists());
            return this.getValueOrDefault(values.getMap());
        }
    };
    public static final RuntimeOptionKey<Boolean> CollectYoungGenerationSeparately = new RuntimeOptionKey<Object>(null, SerialGCOptions::serialGCOnly, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final HostedOptionKey<Boolean> ImageHeapCardMarking = new HostedOptionKey<Object>(null, SerialGCOptions::serialGCOnly);
    public static final HostedOptionKey<Integer> SoftRefLRUPolicyMSPerMB = new HostedOptionKey<Integer>(1000, SerialGCOptions::serialGCOnly);
    public static final RuntimeOptionKey<Boolean> PrintGCSummary = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), SerialGCOptions::serialGCOnly, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final RuntimeOptionKey<Boolean> PrintGCTimeStamps = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), SerialGCOptions::serialGCOnly, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final RuntimeOptionKey<Boolean> PrintGCTimes = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), SerialGCOptions::serialGCOnly, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final HostedOptionKey<Boolean> CountWriteBarriers = new HostedOptionKey<Boolean>(false, SerialGCOptions::serialGCOnly);
    public static final HostedOptionKey<Boolean> VerifyBeforeGC = new HostedOptionKey<Boolean>(true, SerialGCOptions::serialGCOnly);
    public static final HostedOptionKey<Boolean> VerifyAfterGC = new HostedOptionKey<Boolean>(true, SerialGCOptions::serialGCOnly);
    public static final HostedOptionKey<Boolean> VerifyRememberedSet = new HostedOptionKey<Boolean>(true, SerialGCOptions::serialGCOnly);
    public static final HostedOptionKey<Boolean> VerifyReferences = new HostedOptionKey<Boolean>(true, SerialGCOptions::serialGCOnly);
    public static final HostedOptionKey<Boolean> VerifyReferencesPointIntoValidChunk = new HostedOptionKey<Boolean>(false, SerialGCOptions::serialGCOnly);
    public static final HostedOptionKey<Boolean> VerifyWriteBarriers = new HostedOptionKey<Boolean>(false, SerialGCOptions::serialGCOnly);
    public static final RuntimeOptionKey<Boolean> TraceHeapChunks = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), SerialGCOptions::serialGCOnly, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final HostedOptionKey<Boolean> GreyToBlackObjRefDemographics = new HostedOptionKey<Boolean>(false, SerialGCOptions::serialGCOnly);
    public static final HostedOptionKey<Boolean> IgnoreMaxHeapSizeWhileInVMOperation = new HostedOptionKey<Boolean>(false, SerialGCOptions::serialGCOnly);

    private SerialGCOptions() {
    }

    private static void serialGCOnly(OptionKey<?> optionKey) {
        if (!SubstrateOptions.UseSerialGC.getValue().booleanValue()) {
            throw new InterruptImageBuilding("The option '" + optionKey.getName() + "' can only be used together with the serial garbage collector ('--gc=serial').");
        }
    }
}

