/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.Containers;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class PhysicalMemory {
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final UnsignedWord UNSET_SENTINEL;
    private static UnsignedWord cachedSize;

    public static boolean isInitialized() {
        return cachedSize != UNSET_SENTINEL;
    }

    public static boolean isInitializationInProgress() {
        return LOCK.isHeldByCurrentThread();
    }

    public static UnsignedWord size() {
        if (PhysicalMemory.isInitializationDisallowed()) {
            throw VMError.shouldNotReachHere("Accessing the physical memory size may require allocation and synchronization");
        }
        if (!PhysicalMemory.isInitialized()) {
            long memoryLimit = SubstrateOptions.MaxRAM.getValue();
            if (memoryLimit > 0L) {
                cachedSize = WordFactory.unsigned((long)memoryLimit);
            } else {
                LOCK.lock();
                try {
                    if (!PhysicalMemory.isInitialized()) {
                        memoryLimit = Containers.memoryLimitInBytes();
                        cachedSize = memoryLimit > 0L ? WordFactory.unsigned((long)memoryLimit) : ((PhysicalMemorySupport)ImageSingletons.lookup(PhysicalMemorySupport.class)).size();
                    }
                }
                finally {
                    LOCK.unlock();
                }
            }
        }
        return cachedSize;
    }

    public static UnsignedWord getCachedSize() {
        VMError.guarantee(PhysicalMemory.isInitialized(), "Cached physical memory size is not available");
        return cachedSize;
    }

    private static boolean isInitializationDisallowed() {
        return Heap.getHeap().isAllocationDisallowed() || VMOperation.isInProgress() || !PlatformThreads.isCurrentAssigned() || StackOverflowCheck.singleton().isYellowZoneAvailable();
    }

    static {
        cachedSize = UNSET_SENTINEL = UnsignedUtils.MAX_VALUE;
    }

    public static interface PhysicalMemorySupport {
        default public boolean hasSize() {
            throw VMError.shouldNotReachHere("Unused, will be removed");
        }

        public UnsignedWord size();
    }
}

